/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.reffinder.params;

import com.google.common.collect.Lists;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.dicom.SeriesParameters;
import com.mimvista.dicom.UIDContainer;
import com.mimvista.dicom.reffinder.params.ReferencedSeriesFinderStrategy;
import com.mimvista.util.cn;
import com.mimvista.viewer.RTSeriesInfo;
import com.mimvista.viewer.SeriesInfo;

public class RefSeriesFinderStrategyRTPLAN
extends ReferencedSeriesFinderStrategy {
    public RefSeriesFinderStrategyRTPLAN(SeriesInfo seriesInfo) {
        super(seriesInfo);
    }

    @Override
    public boolean strategizeParams(SeriesParameters seriesParameters, SearchSource searchSource) {
        if (this.seriesInfo.modInfo == null || !(this.seriesInfo.modInfo instanceof RTSeriesInfo)) {
            return false;
        }
        RTSeriesInfo rTSeriesInfo = (RTSeriesInfo)this.seriesInfo.modInfo;
        String string = rTSeriesInfo.referencedRtStructUID;
        seriesParameters.uidList = Lists.newArrayList();
        seriesParameters.searchType = 3;
        seriesParameters.studyDate = this.seriesInfo.N();
        seriesParameters.contentDate = rTSeriesInfo.rtPlanDate;
        seriesParameters.modality = "RTst";
        if (!cn.h(rTSeriesInfo.rtPlanBrachyBaselineDoseUID)) {
            seriesParameters.uidList.add(rTSeriesInfo.rtPlanBrachyBaselineDoseUID);
            this.uidsReferenced.put(rTSeriesInfo.rtPlanBrachyBaselineDoseUID, new UIDContainer.SeriesUID(rTSeriesInfo.rtPlanBrachyBaselineDoseUID));
            seriesParameters.searchType = 0;
            seriesParameters.modality = null;
        }
        if (!cn.h(string)) {
            seriesParameters.uidList.add(string);
            this.uidsReferenced.put(string, new UIDContainer.SeriesUID(string));
        }
        if (!cn.h(rTSeriesInfo.rtPlanBrachyReferencedRtStructUID)) {
            seriesParameters.uidList.add(rTSeriesInfo.rtPlanBrachyReferencedRtStructUID);
            this.uidsReferenced.put(rTSeriesInfo.rtPlanBrachyReferencedRtStructUID, new UIDContainer.SOPInstanceUID(rTSeriesInfo.rtPlanBrachyReferencedRtStructUID));
        }
        return true;
    }
}

