/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.reftraversal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.d;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.UIDContainer;
import com.mimvista.dicom.reftraversal.DcmSeriesReferenceStrategy;
import com.mimvista.dicom.reftraversal.DcmSeriesReferenceTraverser;
import com.mimvista.dicom.reftraversal.DcmSeriesReferenceTraverserFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CachedDcmSeriesReferenceTraverser {
    final SearchSource source;
    final DcmSeriesReferenceTraverser traverser;
    final Map<UIDContainer.FrameOfReferenceUID, DcmSeriesReferenceTraverser> forTraversers = Maps.newHashMap();

    public CachedDcmSeriesReferenceTraverser(SearchSource searchSource) {
        this.source = searchSource;
        this.traverser = new DcmSeriesReferenceTraverser(searchSource);
        this.traverser.addStrategy(new DcmSeriesReferenceStrategy.MetabaseReferenceStrategy());
    }

    public boolean doesSeriesReferenceOtherSeries(DcmSeries dcmSeries, UIDContainer.SeriesUID seriesUID) {
        return this.retainSeriesWhichLoadToSeriesUID(Lists.newArrayList((Object[])new DcmSeries[]{dcmSeries}), seriesUID, null).size() == 1;
    }

    public List<DcmSeries> retainSeriesWhichLoadToSeriesUID(Collection<DcmSeries> arrayList, UIDContainer.SeriesUID seriesUID, @d UIDContainer.FrameOfReferenceUID frameOfReferenceUID) {
        ArrayList arrayList2 = Lists.newArrayList();
        ArrayList arrayList3 = Lists.newArrayList();
        ArrayList arrayList4 = Lists.newArrayList();
        for (Object object : arrayList) {
            if (((DcmSeries)object).getFrameOfReferenceUID() == null) {
                arrayList4.add(object);
                continue;
            }
            arrayList3.add(object);
        }
        arrayList3.addAll(this.traverser.querySSToCanonicalize(arrayList4));
        arrayList = arrayList3;
        Object object = null;
        for (DcmSeries dcmSeries : arrayList) {
            Set<DcmSeries> set = DcmSeriesReferenceTraverser.flattenMultimap(this.traverser.traverseFrom(dcmSeries));
            if (CachedDcmSeriesReferenceTraverser.matchesVCSeriesUID(seriesUID.uid, set)) {
                arrayList2.add(dcmSeries);
                continue;
            }
            if (!Modality.RTDOSE.isSameModality(dcmSeries.getModality())) continue;
            if (object == null) {
                object = this.getOrcreateFORReferenceTraverser(dcmSeries, frameOfReferenceUID);
            }
            if (!CachedDcmSeriesReferenceTraverser.matchesVCSeriesUID(seriesUID.uid, set = DcmSeriesReferenceTraverser.flattenMultimap(((DcmSeriesReferenceTraverser)object).traverseFrom(dcmSeries)))) continue;
            arrayList2.add(dcmSeries);
        }
        return arrayList2;
    }

    private DcmSeriesReferenceTraverser getOrcreateFORReferenceTraverser(DcmSeries dcmSeries, UIDContainer.FrameOfReferenceUID frameOfReferenceUID) {
        DcmSeriesReferenceTraverser dcmSeriesReferenceTraverser;
        UIDContainer.FrameOfReferenceUID frameOfReferenceUID2 = frameOfReferenceUID;
        if (frameOfReferenceUID2 == null) {
            frameOfReferenceUID2 = new UIDContainer.FrameOfReferenceUID(dcmSeries.getFrameOfReferenceUID());
        }
        if ((dcmSeriesReferenceTraverser = this.forTraversers.get(frameOfReferenceUID2)) == null) {
            dcmSeriesReferenceTraverser = DcmSeriesReferenceTraverserFactory.createFORReferenceTraverser(this.source, frameOfReferenceUID2);
            this.forTraversers.put(frameOfReferenceUID2, dcmSeriesReferenceTraverser);
        }
        return dcmSeriesReferenceTraverser;
    }

    private static boolean matchesVCSeriesUID(String string, Iterable<DcmSeries> iterable) {
        for (DcmSeries dcmSeries : iterable) {
            if (dcmSeries == null || dcmSeries.getSeriesInstanceUID() == null || !dcmSeries.getSeriesInstanceUID().equals(string)) continue;
            return true;
        }
        return false;
    }
}

