/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.reftraversal;

import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.mimvista.archive.gui.SeriesColumn;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.DcmSeriesReference;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.SeriesIdentifier;
import com.mimvista.dicom.reftraversal.PriceIsRightWinners;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public interface DcmSeriesReferenceStrategy {
    public Collection<DcmSeries> getReferences(DcmSeries var1);

    public static final class DoseFORMatchingReferenceStrategy
    implements DcmSeriesReferenceStrategy {
        private static final Ordering<DcmSeries> COMPARATOR = SeriesColumn.k.e();
        final List<DcmSeries> sameFOR = Lists.newArrayList();
        final String ourFOR;

        public DoseFORMatchingReferenceStrategy(Collection<DcmSeries> collection) {
            for (DcmSeries dcmSeries : collection) {
                String string = dcmSeries.getNumberOfImages();
                if (string == null) {
                    string = "";
                }
                if ("1".equals(string) || SeriesIdentifier.isReferringSeries(dcmSeries.getModality())) continue;
                this.sameFOR.add(dcmSeries);
            }
            Collections.sort(this.sameFOR, COMPARATOR);
            this.ourFOR = !collection.isEmpty() ? collection.iterator().next().getFrameOfReferenceUID() : null;
        }

        @Override
        public Collection<DcmSeries> getReferences(DcmSeries dcmSeries) {
            if (this.ourFOR == null || !this.ourFOR.equals(dcmSeries.getFrameOfReferenceUID())) {
                return Lists.newArrayList();
            }
            if (!Modality.RTDOSE.isSameModality(dcmSeries.getModality())) {
                return Lists.newArrayList();
            }
            List<DcmSeries> list = PriceIsRightWinners.findBestPriceIsRightAnswers(this.sameFOR, dcmSeries, COMPARATOR.reverse());
            if (list.size() == 0) {
                return Lists.newArrayList();
            }
            return Lists.newArrayList((Object[])new DcmSeries[]{list.get(list.size() - 1)});
        }
    }

    public static final class MetabaseReferenceStrategy
    implements DcmSeriesReferenceStrategy {
        @Override
        public Collection<DcmSeries> getReferences(DcmSeries dcmSeries) {
            ArrayList arrayList = Lists.newArrayList();
            if (dcmSeries.getReferencedSeries() != null) {
                for (DcmSeriesReference dcmSeriesReference : dcmSeries.getReferencedSeries().values()) {
                    arrayList.addAll(dcmSeriesReference.getReferencedDcmSeries());
                }
            }
            return arrayList;
        }
    }
}

