/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.reftraversal;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.archive.search.Searchable;
import com.mimvista.archive.search.f;
import com.mimvista.archive.search.i;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.SeriesParameters;
import com.mimvista.dicom.reftraversal.DcmSeriesReferenceStrategy;
import com.mimvista.metabase.MetabaseQuery;
import com.mimvista.metabase.b;
import com.mimvista.metabase.n;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;

public class DcmSeriesReferenceTraverser {
    private final SearchSource source;
    private final List<DcmSeriesReferenceStrategy> strategies = Lists.newArrayList();
    private final Map<Long, DcmSeries> metaPKMap = Maps.newHashMap();

    public static Set<DcmSeries> flattenMultimap(Multimap<DcmSeries, DcmSeries> multimap) {
        HashSet hashSet = Sets.newHashSet();
        hashSet.addAll(multimap.keySet());
        hashSet.addAll(multimap.values());
        return hashSet;
    }

    public DcmSeriesReferenceTraverser(SearchSource searchSource) {
        this.source = searchSource;
    }

    public void addStrategy(DcmSeriesReferenceStrategy dcmSeriesReferenceStrategy) {
        this.strategies.add(dcmSeriesReferenceStrategy);
    }

    public Multimap<DcmSeries, DcmSeries> traverseFrom(DcmSeries dcmSeries) {
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        ArrayList arrayList = Lists.newArrayList();
        if (this.strategies.size() == 0) {
            return arrayListMultimap;
        }
        HashSet hashSet = Sets.newHashSet();
        LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create();
        LinkedList<DcmSeries> linkedList = new LinkedList<DcmSeries>();
        linkedList.add(dcmSeries);
        do {
            Collection<DcmSeries> collection = this.querySSToCanonicalize(linkedHashMultimap.values());
            this.addCanonicalSeries(collection);
            linkedList.addAll(collection);
            for (Object object : linkedHashMultimap.keySet()) {
                for (Object object2 : linkedHashMultimap.get(object)) {
                    arrayListMultimap.put(object, (Object)this.canonicalize((DcmSeries)object2));
                }
            }
            linkedHashMultimap.clear();
            while (!linkedList.isEmpty()) {
                Object object;
                DcmSeries dcmSeries2 = (DcmSeries)linkedList.poll();
                if (hashSet.contains(dcmSeries2)) continue;
                hashSet.add(dcmSeries2);
                object = this.strategies.iterator();
                while (object.hasNext()) {
                    Object object2;
                    DcmSeriesReferenceStrategy dcmSeriesReferenceStrategy = (DcmSeriesReferenceStrategy)object.next();
                    object2 = dcmSeriesReferenceStrategy.getReferences(dcmSeries2);
                    linkedHashMultimap.putAll((Object)dcmSeries2, (Iterable)object2);
                }
            }
        } while (!linkedHashMultimap.isEmpty());
        return arrayListMultimap;
    }

    private DcmSeries canonicalize(DcmSeries dcmSeries) {
        return this.metaPKMap.get(dcmSeries.getPrimaryKey());
    }

    private void addCanonicalSeries(Collection<DcmSeries> collection) {
        for (DcmSeries dcmSeries : collection) {
            this.metaPKMap.put(dcmSeries.getPrimaryKey(), dcmSeries);
        }
    }

    Collection<DcmSeries> querySSToCanonicalize(Collection<DcmSeries> collection) {
        HashSet hashSet = Sets.newHashSet();
        SeriesParameters seriesParameters = new SeriesParameters();
        seriesParameters.uidList = Lists.newArrayList();
        seriesParameters.searchType = 7;
        for (DcmSeries object2 : collection) {
            if (!this.metaPKMap.containsKey(object2.getPrimaryKey())) {
                seriesParameters.uidList.add(object2.getSeriesInstanceUID());
                continue;
            }
            hashSet.add(this.canonicalize(object2));
        }
        if (hashSet.size() == collection.size()) {
            return hashSet;
        }
        MetabaseQuery metabaseQuery = b.a(n.a(), seriesParameters);
        Future<List<DcmSeries>> future = this.source.a(metabaseQuery, (Searchable.a)new Searchable.b(), (f<i>)null);
        try {
            List<DcmSeries> throwable = future.get();
            throwable.addAll(hashSet);
            return throwable;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }
}

