/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose;

import com.mimvista.dicom.rtdose.DVHGenerator;
import com.mimvista.dicom.util.RescaleConverter;
import com.mimvista.internals.ContourSlice;
import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.mui.overlays.SimpleVolumetricContourOverlay;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.MultipliedIndexPoint3i;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.VoxelIndexPoint3f;
import com.mimvista.numerics.VoxelPoint3d;
import com.mimvista.numerics.VoxelPoint3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class AffineDVHGenerator
extends DVHGenerator {
    private Matrix4f trans;
    private SimpleImageFrame srcVol;
    private int[] numSubSamples;
    private Point3f.PointVolumeInfo srcPVI;
    private Point3f.PointVolumeInfo dosePVI;
    private int[] mult;
    private float xVoxelStep;
    private float yVoxelStep;
    private float zVoxelStep;
    private double[] xOffsetsInDose;
    private double[] yOffsetsInDose;
    private double[] zOffsetsInDose;
    private boolean enableSamplePointNotification = false;

    public AffineDVHGenerator(SimpleVolumetricContourOverlay simpleVolumetricContourOverlay, SimpleImageFrame simpleImageFrame, SimpleImageVolume<ImageCube.ImageCubeShort> simpleImageVolume, Matrix4f matrix4f) {
        super(simpleVolumetricContourOverlay, simpleImageVolume);
        this.srcVol = simpleImageFrame;
        this.numSubSamples = this.getNumSubSamples();
        this.trans = matrix4f;
        this.initTransform();
    }

    private int[] getNumSubSamples() {
        int[] nArray = new int[3];
        float[] fArray = this.srcVol.b();
        int[] nArray2 = this.c.v();
        float[] fArray2 = this.doseVol.b();
        for (int i2 = 0; i2 < 3; ++i2) {
            float f2 = fArray[i2] / (float)nArray2[i2];
            nArray[i2] = Math.max(1, (int)Math.ceil(f2 / fArray2[i2]));
        }
        if (nArray[2] % 2 == 0) {
            nArray[2] = nArray[2] + 1;
        }
        return nArray;
    }

    @Override
    protected double getSampleVolume() {
        float f2 = MathUtils.k(this.srcVol.b());
        long l2 = MathUtils.d(this.c.v());
        long l3 = MathUtils.d(this.numSubSamples);
        return f2 / (float)l2 / (float)l3 / 1000.0f;
    }

    protected void initTransform() {
        this.srcPVI = new Point3f.PointVolumeInfo(this.srcVol);
        this.dosePVI = new Point3f.PointVolumeInfo(this.doseVol);
        this.mult = this.c.v();
        this.xVoxelStep = 1.0f / (float)(this.mult[0] * this.numSubSamples[0]);
        this.yVoxelStep = 1.0f / (float)(this.mult[1] * this.numSubSamples[1]);
        this.zVoxelStep = 1.0f / (float)(this.mult[2] * this.numSubSamples[2]);
        DVHPointTransformer dVHPointTransformer = new DVHPointTransformer(this.srcPVI, this.dosePVI, this.trans);
        Vector3d vector3d = dVHPointTransformer.getTransfomedVector(this.xVoxelStep, 0.0f, 0.0f);
        Vector3d vector3d2 = dVHPointTransformer.getTransfomedVector(0.0f, this.yVoxelStep, 0.0f);
        Vector3d vector3d3 = dVHPointTransformer.getTransfomedVector(0.0f, 0.0f, this.zVoxelStep);
        VoxelPoint3d voxelPoint3d = new VoxelPoint3d(0.0, 0.0, 0.0, this.dosePVI);
        VoxelPoint3d voxelPoint3d2 = new VoxelPoint3d(0.0, 0.0, 0.0, this.dosePVI);
        VoxelPoint3d voxelPoint3d3 = new VoxelPoint3d(0.0, 0.0, 0.0, this.dosePVI);
        int n2 = (int)MathUtils.d(this.numSubSamples);
        this.xOffsetsInDose = new double[n2];
        this.yOffsetsInDose = new double[n2];
        this.zOffsetsInDose = new double[n2];
        int n3 = 0;
        voxelPoint3d.scale(0.5, (Tuple3d)vector3d3);
        for (int i2 = 0; i2 < this.numSubSamples[2]; ++i2) {
            voxelPoint3d2.scaleAdd(0.5, (Tuple3d)vector3d2, (Tuple3d)voxelPoint3d);
            for (int i3 = 0; i3 < this.numSubSamples[1]; ++i3) {
                voxelPoint3d3.scaleAdd(0.5, (Tuple3d)vector3d, (Tuple3d)voxelPoint3d2);
                int n4 = 0;
                while (n4 < this.numSubSamples[0]) {
                    this.xOffsetsInDose[n3] = voxelPoint3d3.x;
                    this.yOffsetsInDose[n3] = voxelPoint3d3.y;
                    this.zOffsetsInDose[n3] = voxelPoint3d3.z;
                    voxelPoint3d3.add((Tuple3d)vector3d);
                    ++n4;
                    ++n3;
                }
                voxelPoint3d2.add((Tuple3d)vector3d2);
            }
            voxelPoint3d.add((Tuple3d)vector3d3);
        }
    }

    @Override
    protected double[] fillHistogramForSlice(long[] lArray, ContourSlice contourSlice) {
        double[] dArray = new double[2];
        this.computeSliceStatsForDVH(contourSlice, lArray, dArray, null);
        return dArray;
    }

    public void computeSliceStatsForDVH(ContourSlice contourSlice, long[] lArray, double[] dArray, MetricPoint3f[] metricPoint3fArray) {
        DVHPointTransformer dVHPointTransformer = new DVHPointTransformer(this.srcPVI, this.dosePVI, this.trans);
        VoxelPoint3f voxelPoint3f = new VoxelPoint3f(this.srcPVI);
        voxelPoint3f.x = 0.0f;
        voxelPoint3f.y = 0.0f;
        voxelPoint3f.z = (float)contourSlice.l() / (float)this.mult[2];
        VoxelPoint3f voxelPoint3f2 = new VoxelPoint3f(this.dosePVI);
        dVHPointTransformer.transform(voxelPoint3f, voxelPoint3f2);
        VoxelPoint3d voxelPoint3d = new VoxelPoint3d(voxelPoint3f2);
        Vector3d vector3d = dVHPointTransformer.getTransfomedVector(1.0f / (float)this.mult[0], 0.0f, 0.0f);
        Vector3d vector3d2 = dVHPointTransformer.getTransfomedVector(0.0f, 1.0f / (float)this.mult[1], 0.0f);
        VoxelPoint3d voxelPoint3d2 = new VoxelPoint3d(this.dosePVI);
        VoxelPoint3d voxelPoint3d3 = new VoxelPoint3d(this.dosePVI);
        float f2 = this.zeroGyVal;
        RescaleConverter rescaleConverter = this.doseVol.I().rescale;
        float f3 = -3.4028235E38f;
        float f4 = Float.MAX_VALUE;
        VoxelPoint3f voxelPoint3f3 = new VoxelPoint3f(this.dosePVI);
        VoxelPoint3f voxelPoint3f4 = new VoxelPoint3f(this.dosePVI);
        float f5 = 1.0E-4f;
        float[] fArray = this.srcVol.b();
        fArray[0] = fArray[0] / (float)(2 * contourSlice.f()[0]);
        fArray[1] = fArray[1] / (float)(2 * contourSlice.f()[1]);
        fArray[2] = fArray[2] / (float)(2 * contourSlice.f()[2]);
        fArray[0] = fArray[0] + f5;
        fArray[1] = fArray[1] + f5;
        fArray[2] = fArray[2] + f5;
        Matrix4f matrix4f = new Matrix4f(this.trans);
        matrix4f.invert();
        int[] nArray = this.doseVol.a();
        VoxelIndexPoint3f voxelIndexPoint3f = new VoxelIndexPoint3f(this.dosePVI);
        MetricPoint3f metricPoint3f = new MetricPoint3f(this.dosePVI);
        MetricPoint3f metricPoint3f2 = new MetricPoint3f(this.srcPVI);
        MultipliedIndexPoint3i multipliedIndexPoint3i = MultipliedIndexPoint3i.b(0, 0, contourSlice.zPosition, contourSlice.f(), this.srcPVI);
        VoxelIndexPoint3f voxelIndexPoint3f2 = new VoxelIndexPoint3f(this.srcPVI);
        MetricPoint3f metricPoint3f3 = new MetricPoint3f(this.srcPVI);
        for (ContourSlice.ScanLine scanLine : contourSlice.a()) {
            voxelPoint3d2.scaleAdd(scanLine.uniformY, (Tuple3d)vector3d2, (Tuple3d)voxelPoint3d);
            multipliedIndexPoint3i.y = scanLine.uniformY;
            for (int i2 = 0; i2 < scanLine.invPoints.size(); i2 += 2) {
                int n2 = scanLine.invPoints.get(i2).shortValue();
                short s2 = scanLine.invPoints.get(i2 + 1);
                voxelPoint3d3.scaleAdd(n2, (Tuple3d)vector3d, (Tuple3d)voxelPoint3d2);
                for (int i3 = n2; i3 < s2; ++i3) {
                    multipliedIndexPoint3i.x = i3;
                    for (int i4 = 0; i4 < this.xOffsetsInDose.length; ++i4) {
                        float f6;
                        int n3;
                        float f7 = (float)(voxelPoint3d3.x + this.xOffsetsInDose[i4]);
                        float f8 = (float)(voxelPoint3d3.y + this.yOffsetsInDose[i4]);
                        float f9 = (float)(voxelPoint3d3.z + this.zOffsetsInDose[i4]);
                        if (this.enableSamplePointNotification) {
                            VoxelPoint3f voxelPoint3f5 = new VoxelPoint3f(f7, f8, f9, this.doseVol);
                            MetricPoint3f metricPoint3f4 = voxelPoint3f5.b();
                            MetricPoint3f metricPoint3f5 = new MetricPoint3f(this.srcPVI);
                            matrix4f.transform((Point3f)metricPoint3f4, (Point3f)metricPoint3f5);
                            this.sampleTaken(metricPoint3f5);
                        }
                        if ((n3 = this.floor(f6 = this.doseVol.a(f7, f8, f9, f2))) < this.firstBinVal) {
                            throw new RuntimeException("Encountered a dose value (" + n3 + ") less than the expected minimum (" + this.firstBinVal + ")");
                        }
                        if (lArray != null) {
                            int n4 = n3 - this.firstBinVal;
                            lArray[n4] = lArray[n4] + 1L;
                        }
                        if (f3 < f6) {
                            f3 = f6;
                            voxelPoint3f3.set(f7, f8, f9);
                        }
                        if (f4 > f6) {
                            f4 = f6;
                            voxelPoint3f4.set(f7, f8, f9);
                        }
                        float f10 = this.zeroGyVal;
                        int n5 = this.floor(f7);
                        int n6 = this.floor(f8);
                        int n7 = this.floor(f9);
                        if (n5 >= 0 && n5 < nArray[0] && n6 >= 0 && n6 < nArray[1] && n7 >= 0 && n7 < nArray[2]) {
                            f10 = ((ImageCube.ImageCubeShort)this.doseVol.ad()).b(n5, n6, n7);
                        }
                        if (!(f3 < f10) && !(f4 > f10)) continue;
                        voxelIndexPoint3f.x = n5;
                        voxelIndexPoint3f.y = n6;
                        voxelIndexPoint3f.z = n7;
                        voxelIndexPoint3f.a(metricPoint3f);
                        matrix4f.transform((Point3f)metricPoint3f, (Point3f)metricPoint3f2);
                        multipliedIndexPoint3i.a(voxelIndexPoint3f2);
                        voxelIndexPoint3f2.a(metricPoint3f3);
                        if (!(metricPoint3f2.x < metricPoint3f3.x + fArray[0]) || !(metricPoint3f3.x - fArray[0] < metricPoint3f2.x) || !(metricPoint3f2.y < metricPoint3f3.y + fArray[1]) || !(metricPoint3f3.y - fArray[1] < metricPoint3f2.y) || !(metricPoint3f2.z < metricPoint3f3.z + fArray[2]) || !(metricPoint3f3.z - fArray[2] < metricPoint3f2.z)) continue;
                        if (this.enableSamplePointNotification) {
                            this.sampleTaken(metricPoint3f2);
                        }
                        if (f3 < f10) {
                            f3 = f10;
                            voxelPoint3f3.set((float)n5 + 0.5f, (float)n6 + 0.5f, (float)n7 + 0.5f);
                        }
                        if (!(f4 > f10)) continue;
                        f4 = f10;
                        voxelPoint3f4.set((float)n5 + 0.5f, (float)n6 + 0.5f, (float)n7 + 0.5f);
                    }
                    voxelPoint3d3.add((Tuple3d)vector3d);
                }
            }
        }
        if (dArray != null && dArray.length == 2) {
            dArray[0] = rescaleConverter.apply(f4);
            dArray[1] = rescaleConverter.apply(f3);
        }
        if (metricPoint3fArray != null && metricPoint3fArray.length == 2) {
            metricPoint3fArray[0] = voxelPoint3f4.b();
            metricPoint3fArray[1] = voxelPoint3f3.b();
        }
    }

    private int floor(float f2) {
        int n2 = (int)f2;
        if (f2 < 0.0f && (float)n2 != f2) {
            --n2;
        }
        return n2;
    }

    protected void sampleTaken(MetricPoint3f metricPoint3f) {
    }

    public boolean isEnableSamplePointNotification() {
        return this.enableSamplePointNotification;
    }

    public void setEnableSamplePointNotification(boolean bl2) {
        this.enableSamplePointNotification = bl2;
    }

    private class DVHPointTransformer {
        private MetricPoint3f srcMet;
        private MetricPoint3f destMet;
        private Matrix4f transform;

        public DVHPointTransformer(Point3f.PointVolumeInfo pointVolumeInfo, Point3f.PointVolumeInfo pointVolumeInfo2, Matrix4f matrix4f) {
            this.srcMet = new MetricPoint3f(pointVolumeInfo);
            this.destMet = new MetricPoint3f(pointVolumeInfo2);
            this.transform = matrix4f;
        }

        public void transform(VoxelPoint3f voxelPoint3f, VoxelPoint3f voxelPoint3f2) {
            voxelPoint3f.b(this.srcMet);
            this.transform.transform((Point3f)this.srcMet, (Point3f)this.destMet);
            this.destMet.a(voxelPoint3f2);
        }

        public Vector3d getTransfomedVector(float f2, float f3, float f4) {
            Vector3f vector3f = new Vector3f();
            vector3f.x = f2 * ((AffineDVHGenerator)AffineDVHGenerator.this).srcPVI.voxel[0];
            vector3f.y = f3 * ((AffineDVHGenerator)AffineDVHGenerator.this).srcPVI.voxel[1];
            vector3f.z = f4 * ((AffineDVHGenerator)AffineDVHGenerator.this).srcPVI.voxel[2];
            AffineDVHGenerator.this.trans.transform(vector3f);
            Vector3d vector3d = new Vector3d();
            vector3d.x = vector3f.x / ((AffineDVHGenerator)AffineDVHGenerator.this).dosePVI.voxel[0];
            vector3d.y = vector3f.y / ((AffineDVHGenerator)AffineDVHGenerator.this).dosePVI.voxel[1];
            vector3d.z = vector3f.z / ((AffineDVHGenerator)AffineDVHGenerator.this).dosePVI.voxel[2];
            return vector3d;
        }
    }
}

