/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose;

import com.google.common.collect.Lists;
import com.mimvista.dicom.read.DicomLoadingUtility;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.dicom.rtdose.DvhInfo;
import com.mimvista.dicom.rtdose.ReferencedRoi;
import com.mimvista.dicom.rtdose.gui.DvhDisplayInfo;
import com.mimvista.dicom.rtdose.stats.CummulativeDvhStatsGenerator;
import com.mimvista.dicom.rtdose.stats.DvhStatsSource;
import com.mimvista.dicom.rtdose.stats.StoredDvhStatsSource;
import com.mimvista.mui.overlays.OverlayColorPool;
import com.mimvista.numerics.MathUtils;
import com.mimvista.util.ay;
import com.mimvista.viewer.RTDoseSeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import java.awt.Color;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;

public class BasicDVHLoader {
    protected String rtstDesc;
    protected List<DvhDisplayInfo> DVHs = Lists.newArrayList();

    public boolean load(String string, String string2) {
        DicomObject dicomObject = DicomReader.readFileIntoDicomObject(string);
        SeriesInfo seriesInfo = DicomLoadingUtility.getSeriesInfo(dicomObject);
        DicomObject dicomObject2 = null;
        if (string2 != null) {
            dicomObject2 = this.findRtSt(seriesInfo, string2);
        }
        return this.load(seriesInfo, dicomObject2);
    }

    protected DicomObject findRtSt(SeriesInfo seriesInfo, String string) {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (file.isDirectory()) {
            for (String string2 : file.list()) {
                if (!string2.endsWith(".dcm")) continue;
                string = new File(string, string2).getAbsolutePath();
            }
        }
        return DicomReader.readFileIntoDicomObject(string);
    }

    public static boolean isBadAccurayDVH(SeriesInfo seriesInfo) {
        String string = seriesInfo.manufacturer;
        if (string != null && string.toLowerCase().contains("accuray")) {
            String string2 = seriesInfo.softwareVersions;
            try {
                String string3 = string2.substring(string2.lastIndexOf(91) + 1);
                string3 = string3.substring(0, string3.length() - 1);
                int n2 = Integer.parseInt(string3);
                if (n2 <= 4607) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                ay.b((Object)("Unable to determine if accuray stored DVH is bad. Version claims to be '" + string2 + "'."), BasicDVHLoader.class);
            }
        }
        return false;
    }

    public boolean load(SeriesInfo seriesInfo, DicomObject dicomObject) {
        if (seriesInfo.modInfo != null && seriesInfo.modInfo instanceof RTDoseSeriesInfo) {
            RTDoseSeriesInfo rTDoseSeriesInfo = (RTDoseSeriesInfo)seriesInfo.modInfo;
            if (BasicDVHLoader.isBadAccurayDVH(seriesInfo)) {
                ay.a((Object)"Won't try to load old acc DVH.", this);
                return false;
            }
            if (dicomObject == null) {
                dicomObject = this.findRtSt(seriesInfo, null);
            }
            if (dicomObject != null) {
                Object object;
                Object object2;
                DicomElement dicomElement = dicomObject.get(805699616);
                int n2 = dicomElement.countItems();
                HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
                HashMap<Integer, Color> hashMap2 = new HashMap<Integer, Color>();
                for (int i2 = 0; i2 < n2; ++i2) {
                    DicomObject dicomObject2 = dicomElement.getDicomObject(i2);
                    hashMap.put(dicomObject2.getInt(805699618), dicomObject2.getString(805699622));
                }
                dicomElement = dicomObject.get(805699641);
                OverlayColorPool overlayColorPool = new OverlayColorPool();
                for (int i3 = 0; i3 < n2; ++i3) {
                    object2 = dicomElement.getDicomObject(i3);
                    object = object2.getInts(805699626);
                    int n3 = object2.getInt(805699716);
                    hashMap2.put(n3, overlayColorPool.a((Color)new Color((int)object[0], (int)object[1], (int)object[2])).color);
                }
                this.rtstDesc = "";
                String string = dicomObject.getString(524320);
                object2 = dicomObject.getString(524336);
                if (string != null && object2 != null) {
                    this.rtstDesc = this.rtstDesc + string.substring(4, 6) + "-" + string.substring(6, 8) + "-" + string.substring(0, 4);
                    this.rtstDesc = this.rtstDesc + " " + ((String)object2).substring(0, 2) + ":" + ((String)object2).substring(2, 4) + ":" + ((String)object2).substring(4, 6);
                }
                this.rtstDesc = this.rtstDesc + " " + dicomObject.getString(528446);
                object = rTDoseSeriesInfo.dvhSequence;
                if (object == null) {
                    ay.d((Object)"No DVH sequence!", this);
                    return false;
                }
                float f2 = rTDoseSeriesInfo.doseGridScaling;
                int n4 = object.countItems();
                if (n4 == 0) {
                    ay.d((Object)"DVH sequence was empty!", this);
                    return false;
                }
                for (int i4 = 0; i4 < n4; ++i4) {
                    Serializable serializable;
                    int n5;
                    float[] fArray;
                    Object object3;
                    DicomObject dicomObject3 = object.getDicomObject(i4);
                    if (dicomObject3.isEmpty()) continue;
                    int n6 = dicomObject3.getInt(805568598);
                    String string2 = dicomObject3.getString(805568513);
                    DoseVolumeHistogram.DVHType dVHType = null;
                    if ("DIFFERENTIAL".equalsIgnoreCase(string2)) {
                        ++n6;
                        dVHType = DoseVolumeHistogram.DVHType.DIFFERENTIAL;
                    } else if ("CUMULATIVE".equalsIgnoreCase(string2)) {
                        dVHType = DoseVolumeHistogram.DVHType.CUMULATIVE;
                    } else if ("NATURAL".equalsIgnoreCase(string2)) {
                        dVHType = DoseVolumeHistogram.DVHType.NATURAL;
                    }
                    String string3 = dicomObject3.getString(805568514);
                    DoseVolumeHistogram.DoseUnits doseUnits = null;
                    try {
                        doseUnits = DoseVolumeHistogram.DoseUnits.valueOf(string3.toUpperCase());
                    }
                    catch (Exception exception) {
                        ay.d((Object)"Error reading dose units", (Throwable)exception, this.getClass());
                    }
                    String string4 = dicomObject3.getString(0x30040004);
                    DoseVolumeHistogram.DoseType doseType = null;
                    try {
                        doseType = DoseVolumeHistogram.DoseType.valueOf(string4.toUpperCase());
                    }
                    catch (Exception exception) {
                        ay.d((Object)"Error reading dose units", (Throwable)exception, this.getClass());
                    }
                    double d2 = dicomObject3.getDouble(805568594);
                    double d3 = dicomObject3.getDouble(805568624);
                    double d4 = d3 < 0.0 ? d3 : 0.0;
                    DicomElement dicomElement2 = dicomObject3.get(805568608);
                    int n7 = dicomElement2.countItems();
                    ArrayList arrayList = Lists.newArrayList();
                    for (int i5 = 0; i5 < n7; ++i5) {
                        object3 = dicomElement2.getDicomObject(i5);
                        int n8 = object3.getInt(805699716);
                        DoseVolumeHistogram.DvhRoiContributionType dvhRoiContributionType = DoseVolumeHistogram.DvhRoiContributionType.UNKNOWN;
                        String string5 = object3.getString(805568610);
                        try {
                            dvhRoiContributionType = DoseVolumeHistogram.DvhRoiContributionType.valueOf(string5);
                        }
                        catch (Exception exception) {
                            ay.c((Object)("DVH ROI Contribution Type not valid: " + string5), this.getClass());
                        }
                        String string6 = (String)hashMap.get(n8);
                        if (string6 == null) {
                            string6 = "(blank)";
                        }
                        arrayList.add(new ReferencedRoi(n8, string6, dvhRoiContributionType));
                    }
                    double[] dArray = new double[n6];
                    object3 = new double[n6];
                    if (dVHType == DoseVolumeHistogram.DVHType.CUMULATIVE) {
                        fArray = dicomObject3.getFloats(805568600);
                        n5 = 0;
                        for (int i6 = 0; i6 < fArray.length; i6 += 2) {
                            dArray[n5] = fArray[i6];
                            object3[n5] = (DicomObject)((double)fArray[i6 + 1]);
                            ++n5;
                        }
                    } else {
                        int n9;
                        fArray = dicomObject3.getFloats(805568600);
                        n5 = 0;
                        float f3 = 0.0f;
                        for (n9 = 0; n9 < fArray.length; n9 += 2) {
                            f3 += fArray[n9 + 1];
                        }
                        for (n9 = 0; n9 < fArray.length; n9 += 2) {
                            dArray[n5] = fArray[n9];
                            object3[n5] = (DicomObject)((double)f3);
                            f3 -= fArray[n9 + 1];
                            ++n5;
                        }
                        dArray[dArray.length - 1] = 0.01;
                        object3[dArray.length - 1] = (DicomObject)0.0;
                    }
                    int n10 = 0;
                    while (n10 < dArray.length) {
                        int n11 = n10++;
                        dArray[n11] = dArray[n11] * d2;
                    }
                    d2 = 1.0;
                    Serializable serializable2 = new CummulativeDvhStatsGenerator(d4, dArray, (double[])object3);
                    double d5 = dicomObject3.getDouble(805568626);
                    double d6 = dicomObject3.getDouble(805568628);
                    double d7 = serializable2.computeMaxDose();
                    double d8 = serializable2.computeMeanDose();
                    double d9 = serializable2.computeMinDose();
                    if (this.matchMax(d4, dArray, d5, d7) && this.matchMin(d4, dArray, d3, d9)) {
                        serializable = new StoredDvhStatsSource(d3, d6, d5, serializable2.computeStandardDeviation(), serializable2.computeMaxVolume());
                        serializable2 = serializable;
                    }
                    serializable = new DvhInfo(dVHType, doseUnits, doseType, d2, f2);
                    DoseVolumeHistogram doseVolumeHistogram = new DoseVolumeHistogram((DvhStatsSource)serializable2, (DvhInfo)serializable, dArray, (double[])object3, d4, arrayList);
                    DvhDisplayInfo dvhDisplayInfo = new DvhDisplayInfo(doseVolumeHistogram, (Color)hashMap2.get(((ReferencedRoi)arrayList.get((int)0)).ROINumber));
                    this.DVHs.add(dvhDisplayInfo);
                }
                return true;
            }
            ay.d((Object)("Couldn't find rtst object for " + seriesInfo.ag()), this.getClass());
            return false;
        }
        ay.d((Object)"Null dose object!", this.getClass());
        return false;
    }

    public List<DvhDisplayInfo> getCurves() {
        return this.DVHs;
    }

    public String getRtStDesc() {
        return this.rtstDesc;
    }

    private boolean matchMax(double d2, double[] dArray, double d3, double d4) {
        if (d3 > MathUtils.e(dArray) + 0.01) {
            return false;
        }
        double d5 = 0.001;
        return this.getBinForValue(d2, dArray, d3 + d5) == this.getBinForValue(d2, dArray, d4 - d5);
    }

    private boolean matchMin(double d2, double[] dArray, double d3, double d4) {
        if (Math.abs(d3 - d4) > MathUtils.k(dArray) + 0.001) {
            return false;
        }
        double d5 = 0.001;
        int n2 = Math.abs(this.getBinForValue(d2, dArray, d3 + d5) - this.getBinForValue(d2, dArray, d4 - d5));
        return n2 < 2;
    }

    private int getBinForValue(double d2, double[] dArray, double d3) {
        double d4 = d2;
        int n2 = 0;
        for (n2 = 0; n2 < dArray.length && d4 < d3; d4 += dArray[n2], ++n2) {
        }
        return n2 - 1;
    }
}

