/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.mimvista.d;
import com.mimvista.dicom.rtdose.DoseValue;
import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.dicom.rtdose.gui.DVHProducer;
import com.mimvista.dicom.rtdose.gui.DvhDisplayInfo;
import com.mimvista.dicom.rtdose.gui.DvhLineStyle;
import com.mimvista.internals.DynamicVolumeRef3D;
import com.mimvista.internals.FrameNumber;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.mui.overlays.IsodoseOverlay;
import com.mimvista.util.ay;
import com.mimvista.util.b;
import com.mimvista.util.cn;
import com.mimvista.viewer.ModalitySeriesInfo;
import com.mimvista.viewer.RTDoseSeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;

public class DVHCollection
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private SeriesInfo doseInfo;
    private DynamicVolumeRef3D ref;
    private transient WeakReference<ImageVolumeShort> doseVolumeRef = null;
    private DvhLineStyle lineStyle = null;
    private List<DvhDisplayInfo> list;
    private String updatedSeriesDesc;

    public DVHCollection(DynamicVolumeRef3D dynamicVolumeRef3D, @d ImageVolumeShort imageVolumeShort, SeriesInfo seriesInfo, Iterable<DVHProducer> iterable) {
        this(dynamicVolumeRef3D, imageVolumeShort, seriesInfo, iterable, 10);
    }

    public DVHCollection(DynamicVolumeRef3D dynamicVolumeRef3D, @d ImageVolumeShort imageVolumeShort, SeriesInfo seriesInfo, Iterable<DVHProducer> iterable, int n2) {
        ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)n2);
        for (DVHProducer dVHProducer : iterable) {
            arrayList.add(new DvhDisplayInfo(dVHProducer));
        }
        this.init(dynamicVolumeRef3D, imageVolumeShort, arrayList, seriesInfo);
    }

    public DVHCollection(DynamicVolumeRef3D dynamicVolumeRef3D, @d ImageVolumeShort imageVolumeShort, SeriesInfo seriesInfo, Collection<DoseVolumeHistogram> collection) {
        this(dynamicVolumeRef3D, imageVolumeShort, seriesInfo, collection, 10);
    }

    public DVHCollection(DynamicVolumeRef3D dynamicVolumeRef3D, @d ImageVolumeShort imageVolumeShort, SeriesInfo seriesInfo, int n2) {
        this(dynamicVolumeRef3D, imageVolumeShort, seriesInfo, (Collection<DoseVolumeHistogram>)new ArrayList<DoseVolumeHistogram>(), n2);
    }

    private DVHCollection(DynamicVolumeRef3D dynamicVolumeRef3D, @d ImageVolumeShort imageVolumeShort, SeriesInfo seriesInfo, Collection<DoseVolumeHistogram> collection, int n2) {
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)n2);
        for (DoseVolumeHistogram doseVolumeHistogram : collection) {
            arrayList.add(new DvhDisplayInfo(doseVolumeHistogram));
        }
        this.init(dynamicVolumeRef3D, imageVolumeShort, arrayList, seriesInfo);
    }

    public DVHCollection(DynamicVolumeRef3D dynamicVolumeRef3D, @d ImageVolumeShort imageVolumeShort, Collection<DvhDisplayInfo> collection, SeriesInfo seriesInfo) {
        this.init(dynamicVolumeRef3D, imageVolumeShort, collection, seriesInfo);
    }

    private void init(DynamicVolumeRef3D dynamicVolumeRef3D, @d ImageVolumeShort imageVolumeShort, Collection<DvhDisplayInfo> collection, SeriesInfo seriesInfo) {
        if (imageVolumeShort != null) {
            this.doseVolumeRef = new WeakReference<ImageVolumeShort>(imageVolumeShort);
        }
        this.updatedSeriesDesc = seriesInfo.seriesDesc;
        this.doseInfo = seriesInfo;
        this.ref = dynamicVolumeRef3D;
        this.list = Lists.newArrayList(collection);
        this.lineStyle = this.list.size() > 0 ? this.list.get(0).getLineStyle() : DvhLineStyle.THIN_SOLID;
    }

    public void setCustomName(String string) {
        this.updatedSeriesDesc = string;
    }

    public ImageVolumeShort getDoseVolume() {
        if (this.doseVolumeRef == null) {
            return null;
        }
        return (ImageVolumeShort)this.doseVolumeRef.get();
    }

    public double getOverallMaxDose() {
        double d2 = 0.0;
        for (DvhDisplayInfo dvhDisplayInfo : Lists.newArrayList(this.list)) {
            DoseVolumeHistogram doseVolumeHistogram = dvhDisplayInfo.getDVH();
            if (!(doseVolumeHistogram.getMaxDose() > d2)) continue;
            d2 = doseVolumeHistogram.getMaxDose();
        }
        return d2;
    }

    public DoseValue getRxDose() {
        ModalitySeriesInfo modalitySeriesInfo = this.getDoseInfo().modInfo;
        if (modalitySeriesInfo != null && modalitySeriesInfo instanceof RTDoseSeriesInfo) {
            RTDoseSeriesInfo rTDoseSeriesInfo = (RTDoseSeriesInfo)modalitySeriesInfo;
            return rTDoseSeriesInfo.curDose.c();
        }
        return null;
    }

    public SeriesInfo getDoseInfo() {
        return this.doseInfo;
    }

    public SeriesInfo getAnonDoseInfoIfNeeded() {
        if (b.b()) {
            return this.doseInfo.n();
        }
        return this.doseInfo.m();
    }

    public DvhLineStyle getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(DvhLineStyle dvhLineStyle) {
        this.lineStyle = dvhLineStyle;
    }

    public ViewController3D getViewController() {
        if (this.ref == null) {
            return null;
        }
        return this.ref.e();
    }

    public ImageVolumeShort getVolume() {
        if (this.ref == null) {
            return null;
        }
        return this.ref.f();
    }

    public boolean isSeries4D() {
        if (this.ref == null || this.ref.e() == null) {
            return false;
        }
        return this.ref.e().bl();
    }

    public FrameNumber getFrameNumber() {
        if (this.ref == null) {
            return null;
        }
        return this.ref.d();
    }

    public int size() {
        return this.list.size();
    }

    public List<DoseVolumeHistogram> getDVHs() {
        return Lists.transform(this.list, (Function)new Function<DvhDisplayInfo, DoseVolumeHistogram>(){

            public DoseVolumeHistogram apply(DvhDisplayInfo dvhDisplayInfo) {
                return dvhDisplayInfo.getDVH();
            }
        });
    }

    public List<DVHProducer> getDVHProducers() {
        return Lists.transform(this.list, (Function)new Function<DvhDisplayInfo, DVHProducer>(){

            public DVHProducer apply(DvhDisplayInfo dvhDisplayInfo) {
                return dvhDisplayInfo.getDVHProducer();
            }
        });
    }

    public List<DvhDisplayInfo> getDvhDisplayInfo() {
        return Lists.newArrayList(this.list);
    }

    public void clear() {
        this.list.clear();
    }

    public void add(DvhDisplayInfo dvhDisplayInfo) {
        this.list.add(dvhDisplayInfo);
    }

    public void add(DoseVolumeHistogram doseVolumeHistogram) {
        this.list.add(new DvhDisplayInfo(doseVolumeHistogram));
    }

    public void addDDIs(Collection<? extends DvhDisplayInfo> collection) {
        this.list.addAll(collection);
    }

    public void removeAll(Collection<? extends DoseVolumeHistogram> collection) {
        for (DoseVolumeHistogram doseVolumeHistogram : collection) {
            ListIterator<DvhDisplayInfo> listIterator = this.list.listIterator();
            while (listIterator.hasNext()) {
                if (!listIterator.next().getDVH().equals(doseVolumeHistogram)) continue;
                listIterator.remove();
            }
        }
    }

    public void removeAll(List<? extends DVHProducer> list) {
        for (DVHProducer dVHProducer : list) {
            ListIterator<DvhDisplayInfo> listIterator = this.list.listIterator();
            while (listIterator.hasNext()) {
                if (!listIterator.next().getDVHProducer().equals(dVHProducer)) continue;
                listIterator.remove();
            }
        }
    }

    public List<String> getCollectionInfoStrings() {
        ArrayList arrayList = Lists.newArrayList();
        if (!cn.g(this.doseInfo.patientName)) {
            arrayList.add(this.doseInfo.patientName);
        }
        if (!cn.g(this.doseInfo.patientId)) {
            arrayList.add(this.doseInfo.patientId);
        }
        if (!cn.g(this.getUpdatedSeriesDesc())) {
            arrayList.add(this.getUpdatedSeriesDesc());
        } else if (!cn.g(this.doseInfo.seriesDesc)) {
            arrayList.add(this.doseInfo.seriesDesc);
        }
        if (!cn.g(this.doseInfo.doseComment)) {
            arrayList.add(this.doseInfo.doseComment);
        }
        return arrayList;
    }

    public void addIsodoseInformation(IsodoseOverlay isodoseOverlay) {
        this.updatedSeriesDesc = isodoseOverlay.g(false);
    }

    public DVHCollection clone() {
        try {
            DVHCollection dVHCollection = (DVHCollection)super.clone();
            dVHCollection.list = Lists.newArrayList(this.list);
            return dVHCollection;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ay.d((Object)"Couldn't clone DVHCollection", (Throwable)cloneNotSupportedException, this);
            return null;
        }
    }

    public boolean hasSameIsodoseOverlay(DVHCollection dVHCollection) {
        if (dVHCollection.getDoseVolume() != null && this.getDoseVolume() == dVHCollection.getDoseVolume()) {
            return true;
        }
        if (dVHCollection.getDoseInfo() != null && this.getDoseInfo() == dVHCollection.getDoseInfo()) {
            return true;
        }
        return dVHCollection.getDoseInfo() != null && dVHCollection.getDoseInfo().ag() != null && dVHCollection.getDoseInfo().ag().equals(this.getDoseInfo().ag());
    }

    public String getUpdatedSeriesDesc() {
        return this.updatedSeriesDesc;
    }

    public static Comparator<DVHCollection> getDVHComparator() {
        return new Comparator<DVHCollection>(){

            @Override
            public int compare(DVHCollection dVHCollection, DVHCollection dVHCollection2) {
                if (dVHCollection.getFrameNumber() != null && dVHCollection2.getFrameNumber() != null && dVHCollection.getFrameNumber().a(dVHCollection2.getFrameNumber()) != 0) {
                    return dVHCollection.getFrameNumber().a(dVHCollection2.getFrameNumber());
                }
                if (dVHCollection.getUpdatedSeriesDesc() != null && dVHCollection2.getUpdatedSeriesDesc() != null) {
                    return dVHCollection.getUpdatedSeriesDesc().compareToIgnoreCase(dVHCollection2.getUpdatedSeriesDesc());
                }
                return 0;
            }
        };
    }
}

