/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose;

import com.google.common.collect.Lists;
import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.dicom.rtdose.DvhAccumulator;
import com.mimvista.dicom.rtdose.DvhInfo;
import com.mimvista.dicom.rtdose.ReferencedRoi;
import com.mimvista.dicom.rtdose.stats.DvhStatsGenerator;
import com.mimvista.dicom.rtdose.stats.DvhStatsSource;
import com.mimvista.dicom.util.RescaleConverter;
import com.mimvista.internals.ContourSlice;
import com.mimvista.internals.SimpleContour;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.mui.overlays.SimpleVolumetricContourOverlay;
import com.mimvista.mui.overlays.SimpleVolumetricContourOverlayishBase;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.o;
import com.mimvista.util.work.m;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadPoolExecutor;

public abstract class DVHGenerator {
    private static final int MAX_OUTPUT_BINS = 2000;
    protected static final boolean debugPrint = false;
    protected SimpleVolumetricContourOverlay contour;
    protected SimpleContour c;
    protected SimpleImageVolume<ImageCube.ImageCubeShort> doseVol;
    protected int firstBinVal;
    protected int lastBinVal;
    protected double binWidth;
    protected int indexOfZero;
    protected float zeroGyVal;
    protected float doseOfFirstBin;
    protected RescaleConverter contrast;
    protected Progress p = o.o();

    private static long[] trimUnusedBins(long[] lArray, int n2) {
        int n3;
        for (n3 = lArray.length - 1; lArray[n3] == 0L && n3 > n2 + 1; --n3) {
        }
        long[] lArray2 = new long[n3 + 1];
        System.arraycopy(lArray, 0, lArray2, 0, lArray2.length);
        return lArray2;
    }

    public DVHGenerator(SimpleVolumetricContourOverlay simpleVolumetricContourOverlay, SimpleImageVolume<ImageCube.ImageCubeShort> simpleImageVolume) {
        this.contour = simpleVolumetricContourOverlay;
        this.c = simpleVolumetricContourOverlay.a();
        this.initDoseParams(simpleImageVolume);
    }

    protected void initDoseParams(SimpleImageVolume<ImageCube.ImageCubeShort> simpleImageVolume) {
        this.doseVol = simpleImageVolume;
        this.contrast = simpleImageVolume.getUncopiedMutableInfo().rescale;
        this.binWidth = this.contrast.apply(1) - this.contrast.apply(0);
        this.zeroGyVal = this.contrast.removeRaw(0.0f);
        this.firstBinVal = (int)Math.floor(Math.min(this.doseVol.ah(), this.zeroGyVal));
        this.lastBinVal = (int)Math.floor(this.doseVol.ai());
        this.indexOfZero = (int)Math.floor(this.zeroGyVal) - this.firstBinVal;
        this.doseOfFirstBin = this.contrast.apply(this.firstBinVal);
    }

    public DoseVolumeHistogram generate() {
        return this.generate(true);
    }

    public DoseVolumeHistogram generate(boolean bl2) {
        long l2 = System.nanoTime();
        List<ContourSlice> list = this.c.t();
        DVHHistogramFunctor dVHHistogramFunctor = new DVHHistogramFunctor(this, list, this.p);
        boolean bl3 = true;
        if (bl3) {
            FuncUtils.a((ThreadPoolExecutor)m.c, list.size(), dVHHistogramFunctor, "DVH Histo Gen");
        } else {
            dVHHistogramFunctor.f(0, list.size(), 0);
        }
        if (this.p.n() == Progress.Status.e) {
            return null;
        }
        long[] lArray = dVHHistogramFunctor.getTotalHistogram();
        if (lArray == null) {
            return null;
        }
        double d2 = dVHHistogramFunctor.getMaximumValue();
        double d3 = dVHHistogramFunctor.getMinimumValue();
        long[] lArray2 = DVHGenerator.trimUnusedBins(lArray, this.indexOfZero);
        double d4 = this.getSampleVolume();
        DvhInfo dvhInfo = new DvhInfo(DoseVolumeHistogram.DVHType.CUMULATIVE, DoseVolumeHistogram.DoseUnits.GY, DoseVolumeHistogram.DoseType.PHYSICAL, 1.0, this.binWidth);
        int n2 = bl2 ? Math.max(1, lArray2.length / 2000) : 1;
        List<DoseVolumeHistogram.HistogramBin> list2 = DvhAccumulator.accumulate(lArray2, n2, this.binWidth, d4);
        DvhStatsGenerator dvhStatsGenerator = new DvhStatsGenerator(this.contrast, this.firstBinVal, lArray2, d4, d3, d2);
        ReferencedRoi referencedRoi = ReferencedRoi.defaultFromVco(this.contour);
        DoseVolumeHistogram doseVolumeHistogram = new DoseVolumeHistogram((DvhStatsSource)dvhStatsGenerator, dvhInfo, list2, (double)this.doseOfFirstBin, (Collection<ReferencedRoi>)Lists.newArrayList((Object[])new ReferencedRoi[]{referencedRoi}), (SimpleVolumetricContourOverlayishBase)this.contour);
        return doseVolumeHistogram;
    }

    public void setProgress(Progress progress) {
        this.p = progress;
    }

    protected abstract double[] fillHistogramForSlice(long[] var1, ContourSlice var2);

    protected abstract double getSampleVolume();

    private static final class DVHHistogramFunctor
    extends FuncUtils.e {
        private DVHGenerator gen;
        private Progress progress;
        private ConcurrentLinkedQueue<ContourSlice> sliceQueue;
        private ConcurrentLinkedQueue<long[]> threadHists;
        private List<double[]> slicesMaxes = Collections.synchronizedList(new ArrayList());
        private Double minValue = null;
        private Double maxValue = null;

        private DVHHistogramFunctor(DVHGenerator dVHGenerator, List<ContourSlice> list, Progress progress) {
            this.gen = dVHGenerator;
            this.sliceQueue = new ConcurrentLinkedQueue<ContourSlice>(list);
            this.threadHists = new ConcurrentLinkedQueue();
            this.progress = progress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void f(int n2, int n3, int n4) {
            long[] lArray = new long[this.gen.lastBinVal - this.gen.firstBinVal + 1];
            ContourSlice contourSlice = this.sliceQueue.poll();
            while (contourSlice != null) {
                if (this.progress.n() == Progress.Status.e) {
                    return;
                }
                try {
                    double[] dArray = this.gen.fillHistogramForSlice(lArray, contourSlice);
                    this.slicesMaxes.add(dArray);
                }
                finally {
                    this.progress.N_();
                }
                contourSlice = this.sliceQueue.poll();
            }
            if (this.progress.n() == Progress.Status.e) {
                return;
            }
            this.threadHists.add(lArray);
        }

        public long[] getTotalHistogram() {
            if (this.progress.n() == Progress.Status.e) {
                return null;
            }
            if (!this.sliceQueue.isEmpty()) {
                throw new RuntimeException("Attempted to get final histogram before processing was complete");
            }
            long[] lArray = new long[this.gen.lastBinVal - this.gen.firstBinVal + 1];
            for (long[] lArray2 : this.threadHists) {
                if (lArray2 == null) continue;
                for (int i2 = 0; i2 < lArray.length; ++i2) {
                    int n2 = i2;
                    lArray[n2] = lArray[n2] + lArray2[i2];
                }
            }
            return lArray;
        }

        private void calculateMinMax() {
            double d2 = Double.NEGATIVE_INFINITY;
            double d3 = Double.POSITIVE_INFINITY;
            for (double[] dArray : this.slicesMaxes) {
                if (dArray[1] > d2) {
                    d2 = dArray[1];
                }
                if (!(dArray[0] < d3)) continue;
                d3 = dArray[0];
            }
            this.minValue = d3;
            this.maxValue = d2;
        }

        public double getMaximumValue() {
            if (this.maxValue == null) {
                this.calculateMinMax();
            }
            return this.maxValue;
        }

        public double getMinimumValue() {
            if (this.minValue == null) {
                this.calculateMinMax();
            }
            return this.minValue;
        }
    }
}

