/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.util.ay;
import java.util.ArrayList;
import java.util.List;

public class DVHSquisher {
    private static final int BIGGEST_ALLOWED_DVH_AFTER_SQUISH = 1000;
    private static final int MAX_EQUAL_BINS_TO_COMBINE = 30;

    public static DoseVolumeHistogram squish(DoseVolumeHistogram doseVolumeHistogram) {
        if (doseVolumeHistogram.getNumberOfBins() > 1000) {
            return DVHSquisher.squishByCombiningEqualBins(doseVolumeHistogram);
        }
        return DVHSquisher.squishByCombiningSmallestBins(doseVolumeHistogram);
    }

    private static DoseVolumeHistogram squishByCombiningSmallestBins(DoseVolumeHistogram doseVolumeHistogram) {
        Object object = doseVolumeHistogram.getBins();
        if (object.size() > 1000) {
            ay.e("Going to megasquish " + doseVolumeHistogram.getName());
            while (object.size() > 1000) {
                ArrayList arrayList = Lists.newArrayList();
                double d2 = DVHSquisher.getMinBinWidth(object) * 1.1;
                double d3 = ((DoseVolumeHistogram.HistogramBin)object.get((int)0)).value;
                double d4 = ((DoseVolumeHistogram.HistogramBin)object.get((int)0)).width;
                for (int i2 = 1; i2 < object.size(); ++i2) {
                    double d5 = ((DoseVolumeHistogram.HistogramBin)object.get((int)i2)).width;
                    double d6 = ((DoseVolumeHistogram.HistogramBin)object.get((int)i2)).value;
                    if (d4 > d2) {
                        arrayList.add(new DoseVolumeHistogram.HistogramBin(d4, d3));
                        d4 = d5;
                        d3 = d6;
                        continue;
                    }
                    d4 += d5;
                }
                if (d4 <= d2) {
                    DoseVolumeHistogram.HistogramBin histogramBin = (DoseVolumeHistogram.HistogramBin)arrayList.get(arrayList.size() - 1);
                    arrayList.set(arrayList.size() - 1, new DoseVolumeHistogram.HistogramBin(histogramBin.width + d4, histogramBin.value));
                } else {
                    arrayList.add(new DoseVolumeHistogram.HistogramBin(d4, d3));
                }
                object = arrayList;
            }
        }
        return doseVolumeHistogram.copyWithNewBins((List<DoseVolumeHistogram.HistogramBin>)object);
    }

    private static DoseVolumeHistogram squishByCombiningEqualBins(DoseVolumeHistogram doseVolumeHistogram) {
        ImmutableList<DoseVolumeHistogram.HistogramBin> immutableList = doseVolumeHistogram.getBins();
        ArrayList arrayList = Lists.newArrayList();
        double d2 = ((DoseVolumeHistogram.HistogramBin)immutableList.get((int)0)).value;
        double d3 = ((DoseVolumeHistogram.HistogramBin)immutableList.get((int)0)).width;
        int n2 = 0;
        for (int i2 = 0; i2 < immutableList.size(); ++i2) {
            double d4 = ((DoseVolumeHistogram.HistogramBin)immutableList.get((int)i2)).width;
            double d5 = ((DoseVolumeHistogram.HistogramBin)immutableList.get((int)i2)).value;
            if (d5 != d2 || n2 > 30) {
                arrayList.add(new DoseVolumeHistogram.HistogramBin(d3, d2));
                d3 = d4;
                d2 = d5;
                n2 = 0;
                continue;
            }
            ++n2;
            d3 += d4;
        }
        arrayList.add(new DoseVolumeHistogram.HistogramBin(d3, d2));
        if (immutableList.size() > arrayList.size()) {
            ay.e("Squished " + doseVolumeHistogram.getName() + " from " + immutableList.size() + " to " + arrayList.size() + " by combining equiv");
        }
        return doseVolumeHistogram.copyWithNewBins(arrayList);
    }

    private static double getMinBinWidth(List<DoseVolumeHistogram.HistogramBin> list) {
        double d2 = Double.MAX_VALUE;
        for (DoseVolumeHistogram.HistogramBin histogramBin : list) {
            if (!(histogramBin.width < d2)) continue;
            d2 = histogramBin.width;
        }
        return d2;
    }
}

