/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose;

import com.mimvista.dicom.rtdose.DVHGenerator;
import com.mimvista.internals.ContourSlice;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.mui.overlays.SimpleVolumetricContourOverlay;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.MathUtils;

public class DirectDVHGenerator
extends DVHGenerator {
    public DirectDVHGenerator(SimpleVolumetricContourOverlay simpleVolumetricContourOverlay, SimpleImageVolume<ImageCube.ImageCubeShort> simpleImageVolume) {
        super(simpleVolumetricContourOverlay, simpleImageVolume);
    }

    @Override
    protected double[] fillHistogramForSlice(long[] lArray, ContourSlice contourSlice) {
        short s2;
        short s3;
        int[] nArray = this.c.v();
        short[] sArray = (short[])((ImageCube.ImageCubeShort)this.doseVol.ad()).b().get(contourSlice.zPosition / nArray[2]);
        int n2 = this.doseVol.a()[0];
        int s22 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        for (ContourSlice.ScanLine scanLine : contourSlice.a()) {
            int n4 = scanLine.uniformY / nArray[1] * n2;
            for (int i2 = 0; i2 < scanLine.invPoints.size(); i2 += 2) {
                int n5 = scanLine.invPoints.get(i2).shortValue();
                short s4 = scanLine.invPoints.get(i2 + 1);
                for (int i3 = n5; i3 < s4; ++i3) {
                    short s5 = sArray[n4 + i3 / nArray[0]];
                    if (s5 < this.firstBinVal) {
                        throw new RuntimeException("Encountered a dose value (" + s5 + ") less than the expected minimum (" + this.firstBinVal + ")");
                    }
                    if (s5 > s3) {
                        s3 = s5;
                    }
                    if (s5 < s2) {
                        s2 = s5;
                    }
                    int n6 = s5 - this.firstBinVal;
                    lArray[n6] = lArray[n6] + 1L;
                }
            }
        }
        return new double[]{this.doseVol.b(s2), this.doseVol.b(s3)};
    }

    @Override
    protected double getSampleVolume() {
        float f2 = MathUtils.k(this.doseVol.b());
        long l2 = MathUtils.d(this.c.v());
        return f2 / (float)l2 / 1000.0f;
    }
}

