/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose;

import a.a.a.a.b;
import com.google.common.collect.Lists;
import com.mimvista.dicom.rtdose.DVHCollection;
import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.dicom.rtdose.gui.DVHChartPanel;
import com.mimvista.dicom.rtdose.gui.DVHDisplayParams;
import com.mimvista.dicom.rtdose.gui.DoseNormType;
import com.mimvista.preferencesNew.DosePrefs;
import com.mimvista.util.ay;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DoseCSVFactory {
    private DoseCSVFactory() {
    }

    public static void writeDVHtoCSV(String string, Iterable<DVHCollection> iterable) throws IOException {
        DVHDisplayParams dVHDisplayParams = new DVHDisplayParams();
        dVHDisplayParams.setNormalizedVolume(false);
        DoseCSVFactory.writeDVHtoCSV(string, iterable, dVHDisplayParams);
    }

    /*
     * WARNING - void declaration
     */
    public static void writeDVHtoCSV(String string, Iterable<DVHCollection> iterable, DVHDisplayParams dVHDisplayParams) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("Destination file must not be null");
        }
        int n2 = 0;
        CSVEntry cSVEntry = null;
        if (!string.endsWith(".csv")) {
            string = string + ".csv";
        }
        File file = new File(string);
        ArrayList arrayList = Lists.newArrayList();
        ArrayList arrayList2 = Lists.newArrayList();
        arrayList2.add(new String());
        double d2 = DoseCSVFactory.getMinDoseofAllDVHs(iterable);
        for (DVHCollection object2 : iterable) {
            arrayList2.add(object2.getDoseInfo().patientName);
            for (int i2 = 0; i2 < object2.getDVHs().size() - 1; ++i2) {
                arrayList2.add(new String());
            }
            for (DoseVolumeHistogram i3 : object2.getDVHs()) {
                Object object = DoseCSVFactory.createCSVEntry(i3, dVHDisplayParams);
                double d3 = d2;
                if (dVHDisplayParams.getDoseNormType() != DoseNormType.ABSOLUTE) {
                    d3 = dVHDisplayParams.normalizeDose(d2, i3);
                }
                DoseCSVFactory.padCSVEntryToMinDose((CSVEntry)object, d3, DoseCSVFactory.getBinSize(dVHDisplayParams));
                if (((CSVEntry)object).doses.size() > n2) {
                    n2 = ((CSVEntry)object).doses.size();
                    cSVEntry = object;
                }
                arrayList.add(object);
            }
        }
        if (cSVEntry == null) {
            return;
        }
        File file2 = new File(file.getAbsolutePath());
        b b2 = new b(new FileWriter(file2));
        Object i2 = null;
        try {
            void var13_17;
            b2.b(arrayList2);
            arrayList2.clear();
            arrayList2.add(dVHDisplayParams.getDescriptionHeaderForCSV());
            for (Object object : arrayList) {
                arrayList2.add(((CSVEntry)object).name + dVHDisplayParams.getInfoDescForDVHInCSV(((CSVEntry)object).histogram));
            }
            b2.b(arrayList2);
            boolean throwable = false;
            while (var13_17 < n2) {
                arrayList2.clear();
                arrayList2.add(Double.toString(DoseCSVFactory.truncateNumber(cSVEntry.doses.get((int)var13_17))));
                for (CSVEntry cSVEntry2 : arrayList) {
                    if (var13_17 >= cSVEntry2.doses.size()) {
                        arrayList2.add(new String());
                        continue;
                    }
                    if (cSVEntry2.volumes.get((int)var13_17) < (double)1.0E-6f) {
                        arrayList2.add(Double.toString(0.0));
                        continue;
                    }
                    arrayList2.add(Double.toString(DoseCSVFactory.truncateNumber(cSVEntry2.volumes.get((int)var13_17))));
                }
                b2.b(arrayList2);
                ++var13_17;
            }
        }
        catch (Throwable throwable) {
            i2 = throwable;
            throw throwable;
        }
        finally {
            if (b2 != null) {
                if (i2 != null) {
                    try {
                        b2.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)i2).addSuppressed(throwable);
                    }
                } else {
                    b2.close();
                }
            }
        }
    }

    private static double getMinDoseofAllDVHs(Iterable<DVHCollection> iterable) {
        double d2 = Double.MAX_VALUE;
        for (DVHCollection dVHCollection : iterable) {
            for (DoseVolumeHistogram doseVolumeHistogram : dVHCollection.getDVHs()) {
                double d3 = doseVolumeHistogram.getMinDose();
                if (!(d3 < d2)) continue;
                d2 = d3;
            }
        }
        if (d2 < 0.0) {
            return d2;
        }
        return 0.0;
    }

    private static void padCSVEntryToMinDose(CSVEntry cSVEntry, double d2, double d3) {
        if (!cSVEntry.doses.isEmpty() && cSVEntry.doses.get(0) > d2) {
            double d4 = cSVEntry.volumes.get(0);
            double d5 = cSVEntry.doses.get(0);
            do {
                cSVEntry.doses.add(0, d5 -= d3);
                cSVEntry.volumes.add(0, d4);
            } while (d5 > d2);
        }
    }

    private static CSVEntry createCSVEntry(DoseVolumeHistogram doseVolumeHistogram, DVHDisplayParams dVHDisplayParams) {
        double d2;
        CSVEntry cSVEntry = new CSVEntry(doseVolumeHistogram.getName(), doseVolumeHistogram);
        double d3 = DoseCSVFactory.getBinSize(dVHDisplayParams);
        if (dVHDisplayParams.isNormalizationDoseZero(doseVolumeHistogram)) {
            cSVEntry.doses.add(0.0);
            cSVEntry.doses.add(d3);
            if (dVHDisplayParams.isNormalizedVolume()) {
                cSVEntry.volumes.add(100.0);
            } else {
                cSVEntry.volumes.add(doseVolumeHistogram.getMaxVolume());
            }
            cSVEntry.volumes.add(0.0);
            return cSVEntry;
        }
        int n2 = 0;
        double d4 = dVHDisplayParams.normalizeDose(doseVolumeHistogram.getMinDose(), doseVolumeHistogram);
        do {
            double d5 = (double)n2++ * d3;
            if (doseVolumeHistogram.getMinDose() < 0.0) {
                d5 = dVHDisplayParams.getDoseNormType() == DoseNormType.ABSOLUTE ? (d5 += doseVolumeHistogram.getMinDose()) : (d5 += d4);
            }
            cSVEntry.doses.add(d5);
            if (dVHDisplayParams.getDoseNormType() != DoseNormType.ABSOLUTE) {
                d5 = dVHDisplayParams.unnormalizeDoseInGy(d5, doseVolumeHistogram);
            }
            d2 = doseVolumeHistogram.getInterpolatedMLValue(d5);
            if (dVHDisplayParams.isNormalizedVolume()) {
                cSVEntry.volumes.add(DVHChartPanel.normalizeVolume(d2, doseVolumeHistogram));
                continue;
            }
            cSVEntry.volumes.add(d2);
        } while (d2 > 1.0E-4);
        return cSVEntry;
    }

    private static double getBinSize(DVHDisplayParams dVHDisplayParams) {
        switch (dVHDisplayParams.getDoseNormType()) {
            case ABSOLUTE: {
                return DosePrefs.csvDvhBinSize.getValue().floatValue();
            }
        }
        return DosePrefs.csvDvhBinPercentSize.getValue().floatValue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<List<String>> parseValidationCurvesCSV(String string) {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(string));){
            Object[] objectArray;
            Object[] objectArray2 = new ArrayList();
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                objectArray = string2.split(",", -2);
                ArrayList arrayList = Lists.newArrayList((Object[])objectArray);
                objectArray2.add(arrayList);
            }
            objectArray = objectArray2;
            return objectArray;
        }
        catch (IOException iOException) {
            ay.d((Object)iOException.getMessage(), DoseCSVFactory.class);
            return null;
        }
    }

    private static double truncateNumber(double d2) {
        int n2 = 100000;
        return (double)Math.round(d2 * (double)n2) / (double)n2;
    }

    static class CSVEntry {
        String name;
        List<Double> doses;
        List<Double> volumes;
        DoseVolumeHistogram histogram;

        public CSVEntry(String string, DoseVolumeHistogram doseVolumeHistogram) {
            this.name = string;
            this.doses = new ArrayList<Double>();
            this.volumes = new ArrayList<Double>();
            this.histogram = doseVolumeHistogram;
        }
    }
}

