/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose;

import com.google.common.collect.ArrayListMultimap;
import com.mimvista.update.VersionNumber;
import com.mimvista.util.ay;
import com.mimvista.viewer.SeriesInfo;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DoseChecker {
    private static final String VALID_DOSE_RESOURCE_PATH = "/rtdosevalidation.txt";
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(MIM VERSION:) (.*)$", 2);
    private static final String MATCH_ALL = "*";
    List<String> possibleMimVersions;
    String manufacturer;
    String model;
    String version;
    private ArrayListMultimap<String, ValidDoseEntry> versionMap = ArrayListMultimap.create();

    public DoseChecker(VersionNumber versionNumber, SeriesInfo seriesInfo) {
        this.manufacturer = seriesInfo.manufacturer;
        this.model = seriesInfo.modelName;
        this.version = seriesInfo.softwareVersions;
        this.createPossibleVersionList(versionNumber);
        this.loadVersionMap(VALID_DOSE_RESOURCE_PATH);
    }

    private void createPossibleVersionList(VersionNumber versionNumber) {
        this.possibleMimVersions = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(versionNumber.getMajor());
        stringBuilder.append(".");
        stringBuilder.append(versionNumber.getMinor());
        this.possibleMimVersions.add(stringBuilder.toString());
        stringBuilder.append(".");
        stringBuilder.append(versionNumber.getBugFix());
        this.possibleMimVersions.add(stringBuilder.toString());
        stringBuilder.append(".");
        stringBuilder.append(versionNumber.getBuild());
        this.possibleMimVersions.add(stringBuilder.toString());
    }

    public void loadVersionMap(String string) {
        InputStream inputStream = DoseChecker.class.getResourceAsStream(string);
        if (inputStream == null) {
            ay.c((Object)"Could not locate valid dose file.", this);
            return;
        }
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            String string2;
            String string3 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                Matcher matcher = VERSION_PATTERN.matcher(string2);
                if (matcher.matches()) {
                    string3 = matcher.group(2);
                }
                if (string3 == null || string2.indexOf(":") == 0 || string2.indexOf(":") == string2.lastIndexOf(":")) continue;
                this.versionMap.put((Object)string3, (Object)new ValidDoseEntry(string2));
            }
        }
        catch (Exception exception) {
            ay.d((Object)exception, this);
        }
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getModel() {
        return this.model;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean matches() {
        if (this.manufacturer != null && this.manufacturer.contains("MIM Software")) {
            return true;
        }
        for (String string : this.possibleMimVersions) {
            if (!this.versionMap.containsKey((Object)string)) continue;
            for (ValidDoseEntry validDoseEntry : this.versionMap.get((Object)string)) {
                if (!validDoseEntry.manufacturer.equals(this.manufacturer) && !validDoseEntry.manufacturer.equals(MATCH_ALL) || !validDoseEntry.model.equals(this.model) && !validDoseEntry.model.equals(MATCH_ALL) || !validDoseEntry.version.equals(this.version) && !validDoseEntry.version.equals(MATCH_ALL)) continue;
                return true;
            }
        }
        return false;
    }

    private static class ValidDoseEntry {
        public String manufacturer;
        public String model;
        public String version;

        public ValidDoseEntry(String string) {
            String[] stringArray = string.split(":");
            this.manufacturer = stringArray[0].trim();
            this.model = stringArray[1].trim();
            this.version = stringArray[2].trim();
        }
    }
}

