/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose;

import com.google.common.collect.Lists;
import com.mimvista.archive.remote.QueryResult;
import com.mimvista.dicom.read.DicomLoadingUtility;
import com.mimvista.dicom.reffinder.StudyFinder;
import com.mimvista.dicom.rtdose.BasicDVHLoader;
import com.mimvista.dicom.rtdose.DVHCollection;
import com.mimvista.dicom.rtdose.gui.DvhDisplayInfo;
import com.mimvista.preferencesNew.ArchivePrefs;
import com.mimvista.util.Messages;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.ProgressPanel;
import com.mimvista.viewer.RTSeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import java.io.File;
import java.util.List;
import org.dcm4che2.data.DicomObject;

public class DoseLoader
extends BasicDVHLoader {
    public static String loadDVHs(List<String> list, List<String> list2, List<DVHCollection> list3) {
        String string = "";
        for (int i2 = 0; i2 < list.size(); ++i2) {
            DoseLoader doseLoader;
            String string2 = list.get(i2);
            String string3 = null;
            if (list2 != null) {
                string3 = list2.get(i2);
            }
            if (!(doseLoader = new DoseLoader()).load(string2, string3)) continue;
            List<DvhDisplayInfo> list4 = doseLoader.getCurves();
            SeriesInfo seriesInfo = DicomLoadingUtility.createFuzzySeriesInfoFromFiles(Lists.newArrayList((Object[])new File[]{new File(string2)}));
            if (list4.size() <= 0) continue;
            list3.add(new DVHCollection(null, null, list4, seriesInfo));
            string = string + " " + doseLoader.getRtStDesc();
        }
        return string;
    }

    @Override
    protected DicomObject findRtSt(SeriesInfo seriesInfo, String string) {
        if (string == null) {
            String string2 = seriesInfo.patientNameRaw;
            StudyFinder studyFinder = new StudyFinder();
            studyFinder.setSearchType(3);
            studyFinder.setArchivePath(ArchivePrefs.archivePath.getValue().getAbsolutePath());
            studyFinder.setContentDate(seriesInfo.N());
            studyFinder.setName(string2);
            studyFinder.addUID(((RTSeriesInfo)seriesInfo.modInfo).referencedRtStructUID);
            this.addProgressDialog(studyFinder);
            List<QueryResult> list = studyFinder.search();
            string = list.get((int)0).path;
        }
        return super.findRtSt(seriesInfo, string);
    }

    private void addProgressDialog(StudyFinder studyFinder) {
        final ProgressPanel progressPanel = new ProgressPanel();
        progressPanel.b_(Messages.a("Dicom", "STUDYFIND_SEARCH"));
        progressPanel.a(true);
        studyFinder.setNotifier(new StudyFinder.SearchNotifier(){

            @Override
            public void setLabelText(String string) {
                progressPanel.b_(string);
            }

            @Override
            public boolean isCancelled() {
                return progressPanel.n() == Progress.Status.e;
            }

            @Override
            public void finished() {
                progressPanel.b();
            }
        });
    }
}

