/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose;

import com.mimvista.dicom.util.RawDicomUtils;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.SimpleOrientationHelper;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ab;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.mui.ak;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.Point3f;
import com.mimvista.preferencesNew.DicomPrefs;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.swing.JOptionPane;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;

public class DoseOrientationCorrector {
    public static void correct(ImageVolumeShort imageVolumeShort, ViewController viewController, boolean bl2) {
        boolean bl3;
        ImageFrame imageFrame = viewController.aw();
        boolean bl4 = bl3 = DoseOrientationCorrector.checkForAndApplyAccurayShift(imageVolumeShort, imageFrame, bl2) || DoseOrientationCorrector.checkForAndApplyPinnacleShift(imageVolumeShort, imageFrame, bl2) || DoseOrientationCorrector.checkForAndApplyCMSFlip(imageVolumeShort, imageFrame, bl2);
        if (bl3) {
            ay.b((Object)("Dose orientation correction applied for " + imageVolumeShort.toString()), DoseOrientationCorrector.class);
        }
    }

    private static boolean checkForAndApplyCMSFlip(ImageVolumeShort imageVolumeShort, ImageFrame imageFrame, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = imageVolumeShort.getUncopiedMutableInfo().manufacturer.toLowerCase().contains("cms") && !imageVolumeShort.getUncopiedMutableInfo().manufacturer.toLowerCase().contains("mim software") && imageVolumeShort.getUncopiedMutableInfo().modality.equalsIgnoreCase("rtdose");
        if (bl3) {
            boolean bl5;
            boolean bl6 = !ab.a(imageVolumeShort.getUncopiedMutableInfo().origImageOrientation, imageFrame.getUncopiedMutableInfo().origImageOrientation, 0.001f);
            boolean bl7 = bl5 = !bl6 && ab.a(imageVolumeShort.getUncopiedMutableInfo().origImageOrientation, new float[]{-1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f}, 0.001f);
            if (bl6 || bl5) {
                Object object;
                boolean bl8 = false;
                if (bl2) {
                    bl8 = true;
                } else if (DicomPrefs.promptForCmsDoseFix.getValue().booleanValue()) {
                    object = Messages.a("Dicom");
                    boolean bl9 = bl8 = 0 == JOptionPane.showConfirmDialog(ak.b().O(), ((Messages)object).b("LOADTASK_RTDOSE_CMS_BAD_DOSE_FIX_WARNING"), ((Messages)object).b("LOADTASK_RTDOSE_ACCURAY_BAD_DOSE_FIX_TITLE"), 0, 3);
                }
                if (bl8) {
                    if (bl6) {
                        object = imageVolumeShort.getUncopiedMutableInfo().imageOrientation;
                        float[] fArray = imageFrame.getUncopiedMutableInfo().origImageOrientation;
                        imageVolumeShort.getUncopiedMutableInfo().imageOrientation = (float[])fArray.clone();
                        imageVolumeShort.getUncopiedMutableInfo().origImageOrientation = (float[])fArray.clone();
                        Matrix4f matrix4f = ab.a((float[])object, null, fArray, null);
                        Point3f point3f = new Point3f(imageVolumeShort.G());
                        Point3f point3f2 = new Point3f(imageFrame.G());
                        point3f.sub((Tuple3f)point3f2);
                        matrix4f.transform((javax.vecmath.Point3f)point3f);
                        point3f.add((Tuple3f)point3f2);
                        imageVolumeShort.b(point3f.f());
                    } else if (bl5) {
                        object = imageVolumeShort.G();
                        float[] fArray = imageVolumeShort.Y();
                        float[] fArray2 = imageVolumeShort.b();
                        Object object2 = object;
                        object2[0] = object2[0] + (fArray[0] - fArray2[0]);
                        Object object3 = object;
                        object3[1] = object3[1] + (fArray[1] - fArray2[1]);
                        imageVolumeShort.b((float[])object);
                        ((ImageCube.ImageCubeShort)imageVolumeShort.ad()).l();
                        ((ImageCube.ImageCubeShort)imageVolumeShort.ad()).m();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean checkForAndApplyAccurayShift(ImageVolumeShort imageVolumeShort, ImageFrame imageFrame, boolean bl2) {
        ImageVolumeShort imageVolumeShort2;
        if (imageVolumeShort.getUncopiedMutableInfo().manufacturer.toLowerCase().contains("accuray") && !imageVolumeShort.getUncopiedMutableInfo().manufacturer.toLowerCase().contains("mim software") && imageVolumeShort.getUncopiedMutableInfo().modality.equalsIgnoreCase("rtdose") && imageVolumeShort.getUncopiedMutableInfo().origPatientPosition == SimpleOrientationHelper.PatientPosition.d && ab.a(imageVolumeShort.getUncopiedMutableInfo().origImageOrientation, new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f}, 0.001f) && DoseOrientationCorrector.isDoseOutsideVolume(imageVolumeShort, imageVolumeShort2 = (ImageVolumeShort)imageFrame) && DoseOrientationCorrector.promptForCorrection(imageVolumeShort, imageVolumeShort2, bl2)) {
            float[] fArray = imageVolumeShort.G();
            float[] fArray2 = imageVolumeShort.Y();
            float[] fArray3 = imageVolumeShort.b();
            fArray[0] = fArray[0] - (fArray2[0] - fArray3[0]);
            fArray[2] = fArray[2] - (fArray2[2] - fArray3[2]);
            imageVolumeShort.b(fArray);
            return true;
        }
        return false;
    }

    private static boolean promptForCorrection(ImageVolumeShort imageVolumeShort, ImageVolumeShort imageVolumeShort2, boolean bl2) {
        boolean bl3 = false;
        if (bl2) {
            bl3 = true;
        } else if (DicomPrefs.promptForAccurayDoseFix.getValue().booleanValue() || DicomPrefs.promptForDoseFix.getValue().booleanValue()) {
            Messages messages = Messages.a("Dicom");
            bl3 = 0 == JOptionPane.showConfirmDialog(ak.b().O(), messages.b("LOADTASK_RTDOSE_ACCURAY_BAD_DOSE_FIX_WARNING"), messages.b("LOADTASK_RTDOSE_ACCURAY_BAD_DOSE_FIX_TITLE"), 0, 3);
        }
        return bl3;
    }

    private static boolean checkForAndApplyPinnacleShift(ImageVolumeShort imageVolumeShort, ImageFrame imageFrame, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = imageVolumeShort.getUncopiedMutableInfo().manufacturer.toLowerCase().contains("adac") && !imageVolumeShort.getUncopiedMutableInfo().manufacturer.toLowerCase().contains("mim software");
        if (bl3) {
            boolean bl5;
            boolean bl6 = bl5 = imageVolumeShort.getUncopiedMutableInfo().modality.equalsIgnoreCase("rtdose") && ab.a(imageVolumeShort.getUncopiedMutableInfo().origImageOrientation, new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f}, 0.001f);
            if (bl5) {
                Serializable serializable;
                boolean bl7;
                if (DicomPrefs.promptForNewerPinnacleVersions.getValue().booleanValue()) {
                    bl7 = true;
                } else {
                    serializable = RawDicomUtils.getMinimumSoftwareVersion(imageVolumeShort.getUncopiedMutableInfo().softwareVersions.toLowerCase());
                    BigDecimal bigDecimal = new BigDecimal("9.2");
                    boolean bl8 = bl7 = serializable == null || ((BigDecimal)serializable).compareTo(bigDecimal) < 0;
                }
                if (bl7) {
                    boolean bl9;
                    serializable = (ImageVolumeShort)imageFrame;
                    boolean bl10 = bl9 = DoseOrientationCorrector.isDoseOutsideVolume(imageVolumeShort, (ImageVolumeShort)serializable) && imageVolumeShort.getUncopiedMutableInfo().modelName.toLowerCase().contains("pinnacle3") && imageVolumeShort.getUncopiedMutableInfo().softwareVersions.toLowerCase().contains("8.0m");
                    if (bl9 || DoseOrientationCorrector.promptForCorrection(imageVolumeShort, (ImageVolumeShort)serializable, bl2)) {
                        float[] fArray = imageVolumeShort.G();
                        float[] fArray2 = imageVolumeShort.Y();
                        fArray[2] = fArray[2] + (fArray2[2] - imageVolumeShort.b()[2]);
                        imageVolumeShort.b(fArray);
                        ((ImageCube.ImageCubeShort)imageVolumeShort.ad()).f();
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean isDoseOutsideVolume(ImageVolumeShort imageVolumeShort, ImageVolumeShort imageVolumeShort2) {
        DicomPoint3f[] dicomPoint3fArray = imageVolumeShort2.E();
        DicomPoint3f[] dicomPoint3fArray2 = imageVolumeShort.E();
        return dicomPoint3fArray2[0].x < dicomPoint3fArray[0].x || dicomPoint3fArray2[1].x > dicomPoint3fArray[1].x || dicomPoint3fArray2[0].y < dicomPoint3fArray[0].y || dicomPoint3fArray2[1].y > dicomPoint3fArray[1].y || dicomPoint3fArray2[0].z < dicomPoint3fArray[0].z || dicomPoint3fArray2[1].z > dicomPoint3fArray[1].z;
    }
}

