/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.d;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.SeriesParameters;
import com.mimvista.dicom.gui.SelectSeriesByFORDialog;
import com.mimvista.dicom.reffinder.ReferencedSeriesFinder;
import com.mimvista.dicom.reffinder.SopReferenceFinder;
import com.mimvista.internals.DynamicVolumeRef;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.volumes.ImageVolume;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.mui.Session;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.progress.o;
import com.mimvista.viewer.SeriesInfo;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;

public class DoseRefFinder {
    private DoseRefFinder() {
    }

    public static DoseLoadTarget findRefVC(Session session, DicomObject dicomObject, SeriesInfo seriesInfo) {
        DynamicVolumeRef dynamicVolumeRef = DoseRefFinder.findVolBasedOnSopUID(session, dicomObject);
        String string = dicomObject.getString(0x200052, "");
        if (dynamicVolumeRef != null) {
            return new DoseLoadTarget(dynamicVolumeRef);
        }
        dynamicVolumeRef = DoseRefFinder.findVolUsingRefSeriesFinder(session, dicomObject);
        if (dynamicVolumeRef != null) {
            return new DoseLoadTarget(dynamicVolumeRef);
        }
        Messages messages = Messages.a("Dicom");
        SeriesInfo seriesInfo2 = seriesInfo;
        String string2 = seriesInfo2.seriesDesc;
        if (seriesInfo2.e() != null) {
            string2 = string2 + "\n" + DateFormat.getDateTimeInstance().format(seriesInfo2.e());
        }
        string2 = string2 + "\n" + seriesInfo2.studyDesc;
        String string3 = messages.getProperty("WARNING_RTDOSE_FOR_SEARCH");
        String string4 = messages.getProperty("WARNING_RTDOSE_FOR_SEARCH_TITLE");
        ViewController viewController = DoseRefFinder.findMatchingFORSeriesInSession(session, string, string4, string3, string2, Modality.RTDOSE.get(), false);
        if (viewController != null) {
            return new DoseLoadTarget(viewController, null);
        }
        if (string.isEmpty()) {
            String string5 = dicomObject.getString(0x20000D, "");
            for (ViewController viewController2 : session.ad()) {
                if (viewController2.U() || !string5.equals(viewController2.getUncopiedMutableInfo().studyUID)) continue;
                return new DoseLoadTarget(viewController2, null);
            }
        }
        return null;
    }

    public static ViewController findMatchingFORSeriesInSession(Session session, String string, String string2, String string3, String string4, String string5, boolean bl2) {
        ViewController viewController = null;
        if (string != null) {
            HashMap hashMap = Maps.newHashMap();
            for (ViewController viewController2 : session.af()) {
                if (viewController2.U() || !string.equals(viewController2.getUncopiedMutableInfo().frameOfRefUID)) continue;
                hashMap.put(viewController2.aw(), viewController2);
            }
            viewController = SelectSeriesByFORDialog.warnUserAndSelectVC(hashMap.values(), string2, string3, string4, string5, bl2);
        }
        return viewController;
    }

    public static DcmSeries findReferencedStructureSet(DicomObject dicomObject, SimpleImageVolume simpleImageVolume, ViewController viewController) {
        String string;
        DicomElement dicomElement = dicomObject.get(806092896);
        if (dicomElement != null && dicomElement.countItems() > 0 && (string = dicomElement.getDicomObject(0).getString(528725)) != null && !string.isEmpty()) {
            DcmSeries dcmSeries = null;
            try {
                SopReferenceFinder sopReferenceFinder = new SopReferenceFinder(simpleImageVolume.getUncopiedMutableInfo(), viewController.bG());
                dcmSeries = sopReferenceFinder.find(string, "RTST", new o());
            }
            catch (Throwable throwable) {
                ay.a((Object)"Error occured when searching for RTst referenced by RTdose", throwable, DoseRefFinder.class);
            }
            return dcmSeries;
        }
        return null;
    }

    public static DcmSeries findReferencedRTPlan(DicomObject dicomObject, SimpleImageVolume simpleImageVolume, ViewController viewController) {
        String string;
        DicomElement dicomElement = dicomObject.get(806092802);
        if (dicomElement != null && (string = dicomElement.getDicomObject().getString(528725)) != null && !string.isEmpty() && viewController.bG() != null) {
            SopReferenceFinder sopReferenceFinder = new SopReferenceFinder(simpleImageVolume.getUncopiedMutableInfo(), viewController.bG());
            try {
                return sopReferenceFinder.find(string, "RTPLAN", new o());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                ay.e("we're in MIMViewer, so we can't look for the RTPlan.");
            }
        }
        return null;
    }

    private static DynamicVolumeRef findVolBasedOnSopUID(Session session, DicomObject dicomObject) {
        DicomElement dicomElement = dicomObject.get(528704);
        if (dicomElement == null) {
            dicomElement = dicomObject.get(528656);
        }
        if (dicomElement != null) {
            HashSet hashSet = Sets.newHashSet();
            for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
                DicomObject dicomObject2 = dicomElement.getDicomObject(i2);
                hashSet.add(dicomObject2.getString(528725));
            }
            DynamicVolumeRef dynamicVolumeRef = DoseRefFinder.findVolBySopUid(session, hashSet);
            if (dynamicVolumeRef != null) {
                return dynamicVolumeRef;
            }
            return DoseRefFinder.findVolBySeriesUid(session, hashSet);
        }
        return null;
    }

    private static DynamicVolumeRef findVolUsingRefSeriesFinder(Session session, DicomObject dicomObject) {
        Serializable serializable;
        HashSet hashSet = Sets.newHashSet();
        HashSet hashSet2 = Sets.newHashSet();
        HashSet<SearchSource> hashSet3 = new HashSet<SearchSource>();
        for (ViewController object : session.af()) {
            if (!(object instanceof ViewController3D) || object.U() || (serializable = object.bG()) == null) continue;
            hashSet3.add((SearchSource)serializable);
        }
        for (SearchSource searchSource : hashSet3) {
            serializable = new SeriesParameters();
            ((SeriesParameters)serializable).searchType = 3;
            ((SeriesParameters)serializable).uidList = new ArrayList<String>();
            DcmSeries dcmSeries = new DcmSeries(dicomObject);
            ((SeriesParameters)serializable).uidList.add(dcmSeries.getOneOfMySOPInstanceUIDs());
            List<DcmSeries> list = searchSource.a((SeriesParameters)serializable);
            if (list == null || list.isEmpty()) continue;
            dcmSeries = list.get(0);
            try {
                ReferencedSeriesFinder referencedSeriesFinder;
                block10: {
                    referencedSeriesFinder = new ReferencedSeriesFinder(dcmSeries.getSearchSource(), dcmSeries);
                    referencedSeriesFinder.setThrowXcpIfNoResultsFound(false);
                    try {
                        boolean list2 = referencedSeriesFinder.findReferencedSeries();
                        if (!list2) {
                        }
                        break block10;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        ay.d((Object)"Couldn't find referenced series!", DoseRefFinder.class);
                    }
                    continue;
                }
                List<DcmSeries> list2 = referencedSeriesFinder.getSeriesFound();
                for (DcmSeries dcmSeries2 : list2) {
                    if (dcmSeries2.getTagValue(524312) != null) {
                        hashSet.add((String)dcmSeries2.getTagValue(524312));
                    }
                    if (dcmSeries2.getTagValue(0x20000E) == null) continue;
                    hashSet2.add((String)dcmSeries2.getTagValue(0x20000E));
                }
            }
            catch (Exception exception) {
                System.out.println("Probably failed to initialize the ReferencedSeriesFinder, just keep going");
            }
        }
        Object object = DoseRefFinder.findVolBySopUid(session, hashSet);
        if (object == null) {
            object = DoseRefFinder.findVolBySeriesUid(session, hashSet2);
        }
        return object;
    }

    private static DynamicVolumeRef findVolBySopUid(Session session, Set<String> set) {
        if (set.isEmpty()) {
            return null;
        }
        for (ViewController viewController : session.ad()) {
            if (viewController.U()) continue;
            for (ImageFrame imageFrame : viewController.au().l()) {
                SeriesInfo seriesInfo = imageFrame.getUncopiedMutableInfo();
                if (!cn.h(seriesInfo.sopInstanceUID) && set.contains(seriesInfo.sopInstanceUID)) {
                    return new DynamicVolumeRef(viewController, imageFrame);
                }
                if (!(imageFrame instanceof ImageVolume)) continue;
                List<SliceInfo> list = ((ImageVolume)imageFrame).as();
                for (SliceInfo sliceInfo : list) {
                    if (cn.h(sliceInfo.sopInstanceUID) || !set.contains(sliceInfo.sopInstanceUID)) continue;
                    return new DynamicVolumeRef(viewController, imageFrame);
                }
            }
        }
        return null;
    }

    public static DynamicVolumeRef findVolBySeriesUid(Session session, Set<String> set) {
        if (set.isEmpty()) {
            return null;
        }
        for (ViewController viewController : session.ad()) {
            if (viewController.U()) continue;
            for (ImageFrame imageFrame : viewController.au().l()) {
                SeriesInfo seriesInfo = imageFrame.getUncopiedMutableInfo();
                String string = seriesInfo.ag();
                if (cn.h(string) || !set.contains(string)) continue;
                return new DynamicVolumeRef(viewController, imageFrame);
            }
        }
        return null;
    }

    public static class DoseLoadTarget {
        public final ViewController tgtVc;
        @d
        public final ImageFrame tgtVol;

        public DoseLoadTarget(ViewController viewController, @d ImageFrame imageFrame) {
            this.tgtVc = viewController;
            this.tgtVol = imageFrame;
        }

        public DoseLoadTarget(DynamicVolumeRef dynamicVolumeRef) {
            this.tgtVc = dynamicVolumeRef.b();
            this.tgtVol = dynamicVolumeRef.c();
        }
    }
}

