/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mimvista.d;
import com.mimvista.dicom.rtdose.DoseToContourTransformationEdit;
import com.mimvista.dicom.rtdose.DoseValue;
import com.mimvista.dicom.util.RescaleConverter;
import com.mimvista.internals.Contour;
import com.mimvista.internals.ContourSlice;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.a.v;
import com.mimvista.internals.a.z;
import com.mimvista.internals.al;
import com.mimvista.internals.dose.IsodoseSetting;
import com.mimvista.internals.dose.IsodoseSettingData;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.mui.PresentationType;
import com.mimvista.mui.ba;
import com.mimvista.mui.overlays.IsodoseOverlay;
import com.mimvista.mui.overlays.OverlayColor;
import com.mimvista.mui.overlays.OverlayColorPool;
import com.mimvista.mui.overlays.VolumetricContourOverlay;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.mui.overlays.f;
import com.mimvista.numerics.ImageSlice;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.MultipliedVoxelPoint3f;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.VoxelPoint3f;
import com.mimvista.numerics.VoxelViewingPoint3f;
import com.mimvista.numerics.bk;
import com.mimvista.numerics.bm;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.NumberFormatFactory;
import com.mimvista.util.Pair;
import com.mimvista.util.bg;
import com.mimvista.util.ck;
import com.mimvista.util.extents.VolumeExtent;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.o;
import com.mimvista.util.work.m;
import com.mimvista.viewer.Interpolator;
import com.mimvista.viewer.RTDoseSeriesInfo;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import javax.swing.event.UndoableEditEvent;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;

public class DoseToContourTransformer {
    public static List<DoseToContourTransformationEdit> transform(Iterable<Pair<IsodoseOverlay, DoseToContourParams>> iterable, ViewController viewController, Progress progress) {
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        for (Pair<IsodoseOverlay, DoseToContourParams> object : iterable) {
            linkedHashSet.add(object.x);
            arrayListMultimap.put(object.x, object.y);
        }
        ArrayList arrayList = new ArrayList();
        for (IsodoseOverlay isodoseOverlay : linkedHashSet) {
            List list = arrayListMultimap.get((Object)isodoseOverlay);
            DoseToContourTransformationEdit doseToContourTransformationEdit = new DoseToContourTransformationEdit(viewController, isodoseOverlay, list, progress);
            viewController.g().r().undoableEditHappened(new UndoableEditEvent(viewController, doseToContourTransformationEdit));
            arrayList.add(doseToContourTransformationEdit);
        }
        return arrayList;
    }

    public static VolumetricContourOverlayish generateVCOFromIsodose(ViewController viewController, IsodoseOverlay isodoseOverlay, DoseToContourParams doseToContourParams, int n2) {
        return DoseToContourTransformer.generateVCOFromIsodose(viewController, isodoseOverlay, Lists.newArrayList((Object[])new DoseToContourParams[]{doseToContourParams}), n2, o.o()).get(0);
    }

    public static List<VolumetricContourOverlay> generateVCOFromIsodose(ViewController viewController, IsodoseOverlay isodoseOverlay, List<DoseToContourParams> list, int n2, Progress progress) {
        Object object;
        if (progress != null) {
            object = MIMFormat.a(Messages.a("Dose", "DOSE_TO_CONTOUR_TRANSFORMING"), isodoseOverlay.getName(), "");
            progress.b_((String)object);
        } else {
            progress = o.o();
        }
        object = DoseToContourTransformer.generateIsodoseContours(viewController.aE(), isodoseOverlay, list, progress, n2);
        OverlayColorPool overlayColorPool = viewController.ba().r();
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)object.size());
        for (int i2 = 0; i2 < object.size(); ++i2) {
            Object object2;
            VolumetricContourOverlay volumetricContourOverlay = f.a(viewController, (Contour)object.get(i2));
            DoseToContourParams doseToContourParams = list.get(i2);
            float f2 = doseToContourParams.level;
            if (!doseToContourParams.isPercent) {
                object2 = new DoseValue();
                ((DoseValue)object2).setValueInGy(f2);
                f2 = ((DoseValue)object2).getValueInCurrentUnit();
            }
            object2 = String.valueOf(f2) + " " + IsodoseOverlay.b(doseToContourParams.isPercent);
            if (doseToContourParams.isPercent) {
                object2 = (String)object2 + " (" + NumberFormatFactory.a().format(IsodoseSetting.b(f2 / 100.0f, isodoseOverlay)) + " " + DoseValue.doseUnit.name() + ")";
            }
            volumetricContourOverlay.c(object2);
            OverlayColor overlayColor = null;
            overlayColor = doseToContourParams.color != null ? new OverlayColor(Messages.a("Contour").getProperty("CONT_COLL_PANEL_COLOR"), doseToContourParams.color) : overlayColorPool.c();
            volumetricContourOverlay.a(overlayColor);
            volumetricContourOverlay.d(doseToContourParams.thickness);
            arrayList.add(volumetricContourOverlay);
        }
        return arrayList;
    }

    public static List<Contour> generateIsodoseContours(ImageFrame imageFrame, IsodoseOverlay isodoseOverlay, List<DoseToContourParams> list, Progress progress, int n2) {
        int[] nArray = imageFrame.C();
        nArray[2] = nArray[2] * n2;
        return DoseToContourTransformer.generateIsodoseContours(imageFrame, isodoseOverlay, list, nArray, progress);
    }

    public static List<Contour> generateIsodoseContours(ImageFrame imageFrame, IsodoseOverlay isodoseOverlay, List<DoseToContourParams> list, final int[] nArray, final Progress progress) {
        bg.b("isodose line interpolation");
        final ImageVolumeShort imageVolumeShort = isodoseOverlay.C();
        final Matrix4f matrix4f = isodoseOverlay.aD().q().d(imageFrame, imageVolumeShort).d();
        final Pair<Integer, Integer> pair = DoseToContourTransformer.getMinMaxMultipliedZForSampling(imageFrame, isodoseOverlay, matrix4f, nArray);
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)list.size());
        final ArrayList arrayList2 = Lists.newArrayListWithCapacity((int)list.size());
        ArrayList arrayList3 = Lists.newArrayListWithCapacity((int)list.size());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Contour contour = new Contour(imageFrame);
            contour.d(nArray);
            arrayList.add(contour);
            arrayList2.add(contour);
            arrayList3.add(Float.valueOf(DoseToContourTransformer.getRawValueForLevel(isodoseOverlay, list.get(i2))));
        }
        ck.a(arrayList3, arrayList2);
        final float[] fArray = new float[arrayList3.size()];
        for (int i3 = 0; i3 < arrayList3.size(); ++i3) {
            fArray[i3] = ((Float)arrayList3.get(i3)).floatValue();
        }
        final int[] nArray2 = imageFrame.a();
        final int[] nArray3 = MathUtils.c(imageFrame.a(), nArray);
        int n2 = (Integer)pair.y - (Integer)pair.x + 1;
        progress.a(n2);
        final short s2 = (short)imageVolumeShort.getUncopiedMutableInfo().rescale.removeWithBounds(0.0f);
        final int[] nArray4 = PresentationType.a.a();
        final Point3f.PointVolumeInfo pointVolumeInfo = new Point3f.PointVolumeInfo(imageFrame);
        final Point3f.PointVolumeInfo pointVolumeInfo2 = new Point3f.PointVolumeInfo(imageVolumeShort);
        FuncUtils.e e2 = new FuncUtils.e(){

            @Override
            public void f(int n2, int n3, int n4) throws FuncUtils.MIMInterruptedException {
                int n5 = (Integer)pair.x + n2;
                int n6 = (Integer)pair.x + n3;
                ContourWriteHelper[] contourWriteHelperArray = new ContourWriteHelper[arrayList2.size()];
                for (int i2 = 0; i2 < arrayList2.size(); ++i2) {
                    contourWriteHelperArray[i2] = new ContourWriteHelper((Contour)arrayList2.get(i2), n5);
                }
                ImageSlice.ImageSliceShort imageSliceShort = null;
                for (int i3 = n5; i3 < n6; ++i3) {
                    float f2 = ((float)i3 + 0.5f) / (float)nArray[2];
                    float f3 = ba.a(pointVolumeInfo, pointVolumeInfo2, f2, nArray4);
                    bk bk2 = new bk();
                    bk2.a(new bm(new VoxelViewingPoint3f(0.0f, 0.0f, f2, pointVolumeInfo), new Point(0, 0)));
                    bk2.c(new bm(new VoxelViewingPoint3f((float)nArray2[0], 0.0f, f2, pointVolumeInfo), new Point(nArray3[0], 0)));
                    bk2.b(new bm(new VoxelViewingPoint3f(0.0f, (float)nArray2[1], f2, pointVolumeInfo), new Point(0, nArray3[1])));
                    bk2.d(new bm(new VoxelViewingPoint3f((float)nArray2[0], (float)nArray2[1], f2, pointVolumeInfo), new Point(nArray3[0], nArray3[1])));
                    v v2 = imageVolumeShort.d(matrix4f, f3, nArray4, s2, ba.a(bk2, pointVolumeInfo2), Interpolator.InterpolationType.b);
                    v2.v = imageSliceShort;
                    v2.j = null;
                    v2.k = 1;
                    imageSliceShort = z.a(v2);
                    int n7 = 0;
                    for (int i4 = 0; i4 < nArray3[1]; ++i4) {
                        int n8;
                        int n9 = 0;
                        while (n9 < nArray3[0]) {
                            float f4 = ((short[])imageSliceShort.data)[n7];
                            for (n8 = 0; n8 < fArray.length && f4 >= fArray[n8]; ++n8) {
                                contourWriteHelperArray[n8].set(n9);
                            }
                            ++n9;
                            ++n7;
                        }
                        ContourWriteHelper[] contourWriteHelperArray2 = contourWriteHelperArray;
                        int n10 = contourWriteHelperArray2.length;
                        for (n8 = 0; n8 < n10; ++n8) {
                            ContourWriteHelper contourWriteHelper = contourWriteHelperArray2[n8];
                            contourWriteHelper.advanceY();
                        }
                    }
                    for (ContourWriteHelper contourWriteHelper : contourWriteHelperArray) {
                        contourWriteHelper.advanceZ();
                    }
                    progress.N_();
                }
            }
        };
        FuncUtils.a((ThreadPoolExecutor)m.c, n2, e2, "Isodose to Contour Conversion");
        bg.e("isodose line interpolation");
        return arrayList;
    }

    private static float getRawValueForLevel(IsodoseOverlay isodoseOverlay, DoseToContourParams doseToContourParams) {
        if (doseToContourParams.isPercent) {
            RescaleConverter rescaleConverter = isodoseOverlay.C().getUncopiedMutableInfo().rescale;
            float f2 = rescaleConverter.removeRaw(0.0f);
            float f3 = ((RTDoseSeriesInfo)isodoseOverlay.C().getUncopiedMutableInfo().modInfo).curDose.c().getValueInGy();
            float f4 = rescaleConverter.removeRaw(f3);
            return f2 + (f4 - f2) * doseToContourParams.level / 100.0f;
        }
        return isodoseOverlay.C().a(doseToContourParams.level);
    }

    private static Pair<Integer, Integer> getMinMaxMultipliedZForSampling(ImageFrame imageFrame, IsodoseOverlay isodoseOverlay, Matrix4f matrix4f, int[] nArray) {
        float f2 = Float.POSITIVE_INFINITY;
        float f3 = Float.NEGATIVE_INFINITY;
        Matrix4f matrix4f2 = new Matrix4f();
        matrix4f2.invert(matrix4f);
        ImageVolumeShort imageVolumeShort = isodoseOverlay.C();
        List<VoxelPoint3f> list = new VolumeExtent(imageVolumeShort).e(imageVolumeShort);
        for (VoxelPoint3f voxelPoint3f : list) {
            MetricPoint3f metricPoint3f = voxelPoint3f.b();
            MetricPoint3f metricPoint3f2 = new MetricPoint3f(imageFrame);
            matrix4f2.transform((Point3f)metricPoint3f, (Point3f)metricPoint3f2);
            MultipliedVoxelPoint3f multipliedVoxelPoint3f = new MultipliedVoxelPoint3f(metricPoint3f2.b(), nArray);
            if (multipliedVoxelPoint3f.z < f2) {
                f2 = multipliedVoxelPoint3f.z;
            }
            if (!(multipliedVoxelPoint3f.z > f3)) continue;
            f3 = multipliedVoxelPoint3f.z;
        }
        f2 -= 1.0f;
        f3 += 1.0f;
        f2 = Math.max(0.0f, f2);
        f3 = Math.min(f3, (float)(imageFrame.a()[2] * nArray[2] - 1));
        return Pair.get((int)Math.floor(f2), (int)Math.floor(f3));
    }

    private static class ContourWriteHelper {
        private Contour c;
        private int currZ;
        private ContourSlice currSlice = null;
        private int currY = 0;
        private List<Short> curInvPoints = Lists.newArrayListWithCapacity((int)2);
        private int lastX = -1;

        public ContourWriteHelper(Contour contour, int n2) {
            this.c = contour;
            this.currZ = n2;
        }

        public void set(int n2) {
            if (this.lastX == -1) {
                this.curInvPoints.add(al.a(n2));
            } else if (this.lastX != n2 - 1) {
                this.curInvPoints.add(al.a(this.lastX + 1));
                this.curInvPoints.add(al.a(n2));
            }
            this.lastX = n2;
        }

        public void advanceY() {
            if (this.lastX != -1) {
                this.curInvPoints.add(al.a(this.lastX + 1));
                this.lastX = -1;
                if (this.currSlice == null) {
                    this.currSlice = this.c.d(this.currZ);
                }
                this.currSlice.a(new ContourSlice.ScanLine((short)this.currY, new ArrayList<Short>(this.curInvPoints)));
                this.curInvPoints.clear();
            }
            ++this.currY;
        }

        public void advanceZ() {
            this.currSlice = null;
            ++this.currZ;
            this.currY = 0;
        }
    }

    public static class DoseToContourParams {
        public final float level;
        public final boolean isPercent;
        @d
        public final Color color;
        public final int thickness;

        public DoseToContourParams(IsodoseOverlay isodoseOverlay, IsodoseSettingData.SingleCurveSetting singleCurveSetting) {
            this(isodoseOverlay.q().c() ? singleCurveSetting.value : new DoseValue(singleCurveSetting.value).getValueInGy(), isodoseOverlay.q().c(), singleCurveSetting.color, singleCurveSetting.thickness);
        }

        public DoseToContourParams(float f2, boolean bl2) {
            this(f2, bl2, null, 1);
        }

        public DoseToContourParams(float f2, boolean bl2, @d Color color, int n2) {
            this.level = f2;
            this.isPercent = bl2;
            this.color = color;
            this.thickness = n2;
        }
    }
}

