/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose;

import com.mimvista.dicom.rtdose.Units;
import com.mimvista.preferencesNew.DosePrefs;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.NumberFormatFactory;
import java.io.Serializable;

public class DoseValue
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static Units doseUnit = DoseValue.getCurrentUnit();
    private float doseVal;

    public DoseValue() {
    }

    public DoseValue(float f2) {
        this.setValueInCurrentUnit(f2);
    }

    public DoseValue(float f2, boolean bl2) {
        if (bl2) {
            this.setValueInGy(f2);
        } else {
            this.setValueInCGy(f2);
        }
    }

    public void setValueInCurrentUnit(float f2) {
        if (doseUnit == Units.Gy) {
            this.setValueInGy(f2);
        } else {
            this.setValueInCGy(f2);
        }
    }

    public void setValueInGy(float f2) {
        this.doseVal = f2;
    }

    public void setValueInCGy(float f2) {
        this.doseVal = f2 / 100.0f;
    }

    public float getValueInCurrentUnit() {
        if (doseUnit == Units.cGy) {
            return this.getValueInCGy();
        }
        return this.getValueInGy();
    }

    public float getValueInGy() {
        return this.doseVal;
    }

    public float getValueInCGy() {
        return this.doseVal * 100.0f;
    }

    public DoseValue clone() {
        try {
            return (DoseValue)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getFormattedString() {
        return MIMFormat.a(Messages.a("Dose", "DOSE_AND_UNITS_FORMAT"), this.getValueString(), doseUnit.getExternalizedString());
    }

    public String getValueString() {
        return NumberFormatFactory.a().format(this.getValueInCurrentUnit());
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + Float.floatToIntBits(this.doseVal);
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DoseValue doseValue = (DoseValue)object;
        return Float.floatToIntBits(this.doseVal) == Float.floatToIntBits(doseValue.doseVal);
    }

    public String toString() {
        return this.getFormattedString();
    }

    private static Units getCurrentUnit() {
        return DosePrefs.doseUnit.getValue();
    }
}

