/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mimvista.dicom.rtdose.DvhInfo;
import com.mimvista.dicom.rtdose.ReferencedRoi;
import com.mimvista.dicom.rtdose.SimpleBEDInfo;
import com.mimvista.dicom.rtdose.gui.DvhDisplayInfo;
import com.mimvista.dicom.rtdose.gui.DvhPoint;
import com.mimvista.dicom.rtdose.stats.DvhStats;
import com.mimvista.dicom.rtdose.stats.DvhStatsSource;
import com.mimvista.mui.overlays.SimpleVolumetricContourOverlayishBase;
import com.mimvista.numerics.Interpolate;
import com.mimvista.util.cn;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class DoseVolumeHistogram
implements Serializable,
Iterable<DvhPoint> {
    private static final long serialVersionUID = -4112932656221648686L;
    private List<ReferencedRoi> rois = Lists.newArrayList();
    private final DvhInfo dvhInfo;
    private final DvhStats stats;
    private String name;
    private String nameForReporting;
    private ImmutableList<HistogramBin> bins;
    private final double doseOfFirstBin;
    private SimpleBEDInfo bedInfo = null;
    boolean mimGenerated = false;
    private transient WeakReference<SimpleVolumetricContourOverlayishBase> generatedFrom = null;
    private SimpleVolumetricContourOverlayishBase strongGeneratedFrom = null;

    public static List<HistogramBin> buildHistogramBins(double[] dArray, double[] dArray2) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            HistogramBin histogramBin = new HistogramBin(dArray[i2], dArray2[i2]);
            builder.add((Object)histogramBin);
        }
        return builder.build();
    }

    public DoseVolumeHistogram(DvhStatsSource dvhStatsSource, DvhInfo dvhInfo, double[] dArray, double[] dArray2, double d2, Collection<ReferencedRoi> collection) {
        this(dvhStatsSource, dvhInfo, DoseVolumeHistogram.buildHistogramBins(dArray, dArray2), d2, collection, null);
    }

    public DoseVolumeHistogram(DvhStatsSource dvhStatsSource, DvhInfo dvhInfo, List<HistogramBin> list, double d2, Collection<ReferencedRoi> collection, SimpleVolumetricContourOverlayishBase simpleVolumetricContourOverlayishBase) {
        this(new DvhStats(dvhStatsSource), dvhInfo, list, d2, collection, simpleVolumetricContourOverlayishBase);
    }

    private DoseVolumeHistogram(DvhStats dvhStats, DvhInfo dvhInfo, List<HistogramBin> list, double d2, Collection<ReferencedRoi> collection, SimpleVolumetricContourOverlayishBase simpleVolumetricContourOverlayishBase) {
        this.stats = dvhStats;
        this.dvhInfo = dvhInfo;
        this.bins = ImmutableList.copyOf(list);
        this.doseOfFirstBin = d2;
        this.rois = Lists.newArrayList(collection);
        if (simpleVolumetricContourOverlayishBase != null) {
            this.mimGenerated = true;
            this.generatedFrom = new WeakReference<SimpleVolumetricContourOverlayishBase>(simpleVolumetricContourOverlayishBase);
        }
        this.refreshNames();
    }

    public DoseVolumeHistogram copy() {
        return this.copyWithNewBins((List<HistogramBin>)this.bins);
    }

    public DoseVolumeHistogram copyWithNewBins(List<HistogramBin> list) {
        DoseVolumeHistogram doseVolumeHistogram = new DoseVolumeHistogram(this.stats.clone(), this.dvhInfo.clone(), list, this.doseOfFirstBin, (Collection<ReferencedRoi>)Lists.transform(this.rois, (Function)new Function<ReferencedRoi, ReferencedRoi>(){

            public ReferencedRoi apply(ReferencedRoi referencedRoi) {
                return referencedRoi.clone();
            }
        }), null);
        doseVolumeHistogram.mimGenerated = this.mimGenerated;
        if (this.generatedFrom != null) {
            doseVolumeHistogram.generatedFrom = new WeakReference(this.generatedFrom.get());
        }
        return doseVolumeHistogram;
    }

    public void updateRoiIfSingle(ReferencedRoi referencedRoi) {
        if (this.rois.size() == 1) {
            this.rois = Lists.newArrayList((Object[])new ReferencedRoi[]{referencedRoi});
            this.refreshNames();
        }
    }

    private void refreshNames() {
        this.name = DoseVolumeHistogram.getNameFromRois(this.rois);
        this.nameForReporting = DoseVolumeHistogram.getNameForReportingFromRois(this.rois);
    }

    public static String getNameFromRois(List<ReferencedRoi> list) {
        return cn.a(list, ", ");
    }

    public static String getNameForReportingFromRois(List<ReferencedRoi> list) {
        return cn.a(list, ", ", new Function<ReferencedRoi, String>(){

            public String apply(ReferencedRoi referencedRoi) {
                return referencedRoi.toStringForReport();
            }
        });
    }

    public DvhInfo getDvhInfo() {
        return this.dvhInfo;
    }

    public SimpleVolumetricContourOverlayishBase getGeneratedFrom() {
        if (this.generatedFrom == null) {
            return null;
        }
        return (SimpleVolumetricContourOverlayishBase)this.generatedFrom.get();
    }

    public boolean isMIMGenerated() {
        return this.mimGenerated;
    }

    public int getNumberOfBins() {
        return this.bins.size();
    }

    public int getNumberOfReferencedRois() {
        return this.rois.size();
    }

    public Iterable<ReferencedRoi> getRois() {
        return this.rois;
    }

    public String getName() {
        return this.name;
    }

    public String getNameForReporting() {
        return this.nameForReporting;
    }

    public double getDoseScaling() {
        return this.dvhInfo.dvhDoseScaling;
    }

    public double getDoseStdDev() {
        return this.stats.sdDose;
    }

    public double getMinDose() {
        return this.stats.minDose;
    }

    public double getMaxDose() {
        return this.stats.maxDose;
    }

    public double getMeanDose() {
        return this.stats.meanDose;
    }

    public double getMaxVolume() {
        return this.stats.maxVolume;
    }

    public double getDoseOfFirstBin() {
        return this.doseOfFirstBin;
    }

    public float[] getDvhDataFloatArray() {
        float[] fArray = new float[this.bins.size() * 2];
        for (int i2 = 0; i2 < this.bins.size(); ++i2) {
            fArray[i2 * 2] = (float)((HistogramBin)this.bins.get((int)i2)).width;
            fArray[i2 * 2 + 1] = (float)((HistogramBin)this.bins.get((int)i2)).value;
        }
        return fArray;
    }

    public ImmutableList<HistogramBin> getBins() {
        return this.bins;
    }

    public double[] getValues() {
        double[] dArray = new double[this.bins.size()];
        for (int i2 = 0; i2 < this.bins.size(); ++i2) {
            dArray[i2] = ((HistogramBin)this.bins.get((int)i2)).value;
        }
        return dArray;
    }

    public double[] getWidths() {
        double[] dArray = new double[this.bins.size()];
        for (int i2 = 0; i2 < this.bins.size(); ++i2) {
            dArray[i2] = ((HistogramBin)this.bins.get((int)i2)).width;
        }
        return dArray;
    }

    @Override
    public Iterator<DvhPoint> iterator() {
        return new Iterator<DvhPoint>(){
            private int i = 0;
            private double dose = DoseVolumeHistogram.access$000(DoseVolumeHistogram.this);

            @Override
            public void remove() {
                throw new RuntimeException("Cannot remove points from a DVH");
            }

            @Override
            public DvhPoint next() {
                DvhPoint dvhPoint = new DvhPoint();
                dvhPoint.x = this.dose;
                dvhPoint.y = ((HistogramBin)((DoseVolumeHistogram)DoseVolumeHistogram.this).bins.get((int)this.i)).value;
                this.dose += ((HistogramBin)((DoseVolumeHistogram)DoseVolumeHistogram.this).bins.get((int)this.i)).width;
                ++this.i;
                return dvhPoint;
            }

            @Override
            public boolean hasNext() {
                return this.i < DoseVolumeHistogram.this.getNumberOfBins();
            }
        };
    }

    public double getInterpolatedMLValue(double d2) {
        if (d2 <= this.getMinDose()) {
            return this.getMaxVolume();
        }
        if (d2 > this.getMaxDose()) {
            return 0.0;
        }
        double d3 = this.doseOfFirstBin + ((HistogramBin)this.bins.get((int)0)).width;
        for (int i2 = 1; i2 < this.getNumberOfBins(); ++i2) {
            HistogramBin histogramBin = (HistogramBin)this.bins.get(i2 - 1);
            HistogramBin histogramBin2 = (HistogramBin)this.bins.get(i2);
            if (d3 > d2) {
                double d4 = Math.max(this.getMinDose(), d3 - histogramBin.width);
                return Interpolate.a(d2, d4, d3, histogramBin.value, histogramBin2.value);
            }
            d3 += histogramBin2.width;
        }
        if (d2 > d3) {
            return 0.0;
        }
        HistogramBin histogramBin = (HistogramBin)this.bins.get(this.getNumberOfBins() - 1);
        return Interpolate.a(d2, d3 - histogramBin.width, d3, histogramBin.value, 0.0);
    }

    public double getInterpolatedGyValue(double d2) {
        HistogramBin histogramBin;
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Cannot have a negative ml value: " + d2);
        }
        if (d2 > ((HistogramBin)this.bins.get((int)0)).value) {
            throw new IllegalArgumentException("The value specified is larger than the max volume in the DVH");
        }
        double d3 = this.doseOfFirstBin + ((HistogramBin)this.bins.get((int)0)).width;
        for (int i2 = 1; i2 < this.getNumberOfBins(); ++i2) {
            HistogramBin histogramBin2 = (HistogramBin)this.bins.get(i2 - 1);
            histogramBin = (HistogramBin)this.bins.get(i2);
            if (d2 > ((HistogramBin)this.bins.get((int)i2)).value) {
                double d4 = Math.max(this.getMinDose(), d3 - histogramBin2.width);
                return Interpolate.a(d2, histogramBin2.value, ((HistogramBin)this.bins.get((int)i2)).value, d4, d3);
            }
            d3 += histogramBin.width;
        }
        double d5 = Math.min(this.getMaxDose(), d3);
        histogramBin = (HistogramBin)this.bins.get(this.getNumberOfBins() - 1);
        return Interpolate.a(d2, histogramBin.value, 0.0, d3 - histogramBin.width, d5);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.generatedFrom != null) {
            this.strongGeneratedFrom = (SimpleVolumetricContourOverlayishBase)this.generatedFrom.get();
            this.generatedFrom = null;
        }
        objectOutputStream.defaultWriteObject();
        this.strongGeneratedFrom = null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.strongGeneratedFrom != null) {
            this.generatedFrom = new WeakReference<SimpleVolumetricContourOverlayishBase>(this.strongGeneratedFrom);
            this.strongGeneratedFrom = null;
        }
    }

    public SimpleBEDInfo getBedInfo() {
        return this.bedInfo;
    }

    public void setBedInfo(SimpleBEDInfo simpleBEDInfo) {
        this.bedInfo = simpleBEDInfo;
    }

    public double calculateTCP() {
        if (this.bedInfo == null) {
            return Double.NaN;
        }
        return this.bedInfo.calculateTCP(this);
    }

    public boolean hasBedInfo() {
        return this.bedInfo != null;
    }

    static /* synthetic */ double access$000(DoseVolumeHistogram doseVolumeHistogram) {
        return doseVolumeHistogram.doseOfFirstBin;
    }

    public static class SimpleDVHState
    implements Serializable {
        private static final long serialVersionUID = -7241581319662317405L;
        public SimpleVolumetricContourOverlayishBase generatedFrom;
        public Collection<ReferencedRoi> rois;
        public DvhInfo dvhInfo;
        public DvhStatsSource stats;
        public String name;
        public double[] widths;
        public double[] values;
        public double doseOfFirstBin;
        public DvhDisplayInfo oldDisplayInfo;
    }

    public static enum DvhRoiContributionType {
        INCLUDED,
        EXCLUDED,
        UNKNOWN;

    }

    public static enum DoseUnits {
        GY,
        RELATIVE;

    }

    public static enum DoseType {
        PHYSICAL,
        EFFECTIVE,
        ERROR;

    }

    public static enum DVHType {
        CUMULATIVE,
        DIFFERENTIAL,
        NATURAL;

    }

    public static class HistogramBin
    implements Serializable {
        private static final long serialVersionUID = 6590713858765220937L;
        public final double width;
        public final double value;

        public HistogramBin(double d2, double d3) {
            this.width = d2;
            this.value = d3;
        }
    }
}

