/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.dicom.rtdose.gui.DVHChartPanel;
import com.mimvista.dicom.rtdose.gui.DVHDisplayParams;
import com.mimvista.dicom.rtdose.gui.DVHFrame;
import com.mimvista.dicom.rtdose.gui.DVHNote;
import com.mimvista.dicom.rtdose.gui.DvhAnnotationType;
import com.mimvista.dicom.rtdose.gui.DvhChartPointGenerator;
import com.mimvista.dicom.rtdose.gui.DvhDisplayInfo;

public class DVHAnnotation
implements DVHNote {
    private final DVHDisplayParams dvhParams;
    public final DvhDisplayInfo ddi;
    private final DvhChartPointGenerator pointGenerator;

    public static DVHAnnotation create(DVHDisplayParams dVHDisplayParams, DvhDisplayInfo dvhDisplayInfo, double d2, DvhAnnotationType dvhAnnotationType) {
        if (dvhDisplayInfo == null) {
            return null;
        }
        DvhChartPointGenerator dvhChartPointGenerator = dvhAnnotationType.getPointGenerator(dVHDisplayParams, dvhDisplayInfo, d2);
        dvhChartPointGenerator.generate();
        return new DVHAnnotation(dVHDisplayParams, dvhDisplayInfo, dvhChartPointGenerator);
    }

    public DVHAnnotation(DVHChartPanel dVHChartPanel, DvhDisplayInfo dvhDisplayInfo, DvhChartPointGenerator dvhChartPointGenerator) {
        this.dvhParams = dVHChartPanel.getChartWrapper().getParams();
        this.ddi = dvhDisplayInfo;
        this.pointGenerator = dvhChartPointGenerator;
    }

    public DVHAnnotation(DVHDisplayParams dVHDisplayParams, DvhDisplayInfo dvhDisplayInfo, DvhChartPointGenerator dvhChartPointGenerator) {
        this.dvhParams = dVHDisplayParams;
        this.ddi = dvhDisplayInfo;
        this.pointGenerator = dvhChartPointGenerator;
    }

    @Override
    public DoseVolumeHistogram getParentCurve() {
        return this.ddi.getDVH();
    }

    @Override
    public String getStructureName() {
        String string = DVHFrame.props.b("DVH_INCLUDED") + " " + this.ddi.getDVH().getName();
        return string;
    }

    @Override
    public double getDoseInCurrentUnit() {
        return this.pointGenerator.generate().getDoseInCurrentUnit();
    }

    @Override
    public double getNormalizedDose() {
        return this.dvhParams.normalizeDose(this.getDoseInCurrentUnit(), this.ddi.getDVH());
    }

    @Override
    public double getVolumeInCC() {
        return this.pointGenerator.generate().getVolumeInCC();
    }

    @Override
    public double getNormalizedVolume() {
        return DVHChartPanel.normalizeVolume(this.getVolumeInCC(), this.ddi.getDVH());
    }

    public DvhChartPointGenerator getGenerator() {
        return this.pointGenerator;
    }

    public DvhDisplayInfo getDvhDisplayInfo() {
        return this.ddi;
    }

    public DvhAnnotationType getAnnotationType() {
        if (this.pointGenerator instanceof DvhChartPointGenerator.PointGeneratorUsingDose) {
            return DvhAnnotationType.DOSE;
        }
        if (this.pointGenerator instanceof DvhChartPointGenerator.PointGeneratorUsingVolume) {
            return DvhAnnotationType.VOLUME;
        }
        return DvhAnnotationType.NONE;
    }

    public boolean annotates(DVHDisplayParams dVHDisplayParams) {
        return dVHDisplayParams == this.dvhParams;
    }
}

