/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.mimvista.d;
import com.mimvista.dicom.rtdose.DoseValue;
import com.mimvista.dicom.rtdose.gui.DVHAnnotation;
import com.mimvista.dicom.rtdose.gui.DVHChartPanel;
import com.mimvista.dicom.rtdose.gui.DVHDisplayParams;
import com.mimvista.dicom.rtdose.gui.DvhAnnotationType;
import com.mimvista.dicom.rtdose.gui.DvhDisplayInfo;
import com.mimvista.gui.util.c;
import com.mimvista.mui.MIMJDialog;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;

public class DVHAnnotationDialog
extends MIMJDialog {
    private static final long serialVersionUID = 1L;
    private DVHDisplayParams dvhParams;
    private DVHAnnotation annotation;
    private Pair<DvhDisplayInfo, Integer> selected;
    private Runnable onComplete;
    private final CountDownLatch latch = new CountDownLatch(1);
    private JRadioButton xValueButton;
    private JTextField xValueEntry;
    private JRadioButton yValueButton;
    private JTextField yValueEntry;

    public DVHAnnotationDialog(DVHChartPanel dVHChartPanel, String string, Pair<DvhDisplayInfo, Integer> pair, @d Runnable runnable) {
        this((Window)dVHChartPanel.getFrame(), string, dVHChartPanel.getChartWrapper().getParams(), pair, runnable);
    }

    public DVHAnnotationDialog(Window window, String string, DVHDisplayParams dVHDisplayParams, Pair<DvhDisplayInfo, Integer> pair, @d Runnable runnable) {
        super(window, string, false, null, true, false);
        this.dvhParams = dVHDisplayParams;
        this.selected = pair;
        this.onComplete = runnable;
        this.build();
    }

    private void build() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.xValueButton = new JRadioButton();
        this.xValueButton.setText(DvhAnnotationType.DOSE.getExternalizedString());
        jPanel.add((Component)this.xValueButton, gridBagConstraints);
        this.xValueEntry = new JTextField();
        this.xValueEntry.setText("0.0");
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.ipadx = 40;
        jPanel.add((Component)this.xValueEntry, gridBagConstraints);
        JLabel jLabel = new JLabel(this.dvhParams.getXAxisUnits());
        ++gridBagConstraints.gridx;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.yValueButton = new JRadioButton();
        this.yValueButton.setText(DvhAnnotationType.VOLUME.getExternalizedString());
        jPanel.add((Component)this.yValueButton, gridBagConstraints);
        this.yValueEntry = new JTextField();
        this.yValueEntry.setText("0.0");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.ipadx = 40;
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.yValueEntry, gridBagConstraints);
        JLabel jLabel2 = new JLabel(this.dvhParams.getYAxisUnits());
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridx;
        gridBagConstraints.ipadx = 0;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.xValueButton);
        buttonGroup.add(this.yValueButton);
        this.xValueButton.addChangeListener(this::updateValueFieldsFromRadioButtons);
        this.yValueButton.addChangeListener(this::updateValueFieldsFromRadioButtons);
        this.xValueEntry.addKeyListener(this.createValueKeyListener());
        this.yValueEntry.addKeyListener(this.createValueKeyListener());
        this.xValueButton.setSelected(true);
        JButton jButton = c.c(this::addAnnotation, null);
        jButton.setAlignmentX(0.5f);
        JButton jButton2 = c.a(this::cancelAnnotation, null);
        jButton2.setAlignmentX(0.5f);
        Box box = new Box(0);
        box.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        box.add(jButton);
        box.add(Box.createHorizontalStrut(10));
        box.add(jButton2);
        box.setAlignmentX(0.5f);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        this.getContentPane().add(jPanel);
        this.getContentPane().add(box);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DVHAnnotationDialog.this.cancelAnnotation(actionEvent);
            }
        };
        this.getRootPane().getInputMap(1).put(keyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
        this.xValueEntry.requestFocus();
    }

    private KeyListener createValueKeyListener() {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 10: {
                        DVHAnnotationDialog.this.addAnnotation(null);
                        break;
                    }
                    case 27: {
                        DVHAnnotationDialog.this.cancelAnnotation(null);
                    }
                }
            }
        };
    }

    private void updateValueFieldsFromRadioButtons(@d ChangeEvent changeEvent) {
        this.xValueEntry.setEnabled(this.xValueButton.isSelected());
        if (this.xValueButton.isSelected()) {
            this.xValueEntry.requestFocusInWindow();
        }
        this.yValueEntry.setEnabled(this.yValueButton.isSelected());
        if (this.yValueButton.isSelected()) {
            this.yValueEntry.requestFocusInWindow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAnnotation(@d ActionEvent actionEvent) {
        DvhDisplayInfo dvhDisplayInfo = (DvhDisplayInfo)this.selected.x;
        JTextField jTextField = this.xValueButton.isSelected() ? this.xValueEntry : this.yValueEntry;
        try {
            float f2 = Float.parseFloat(jTextField.getText());
            DvhAnnotationType dvhAnnotationType = DvhAnnotationType.VOLUME;
            if (this.xValueButton.isSelected()) {
                if (!this.dvhParams.getDoseNormType().isNormalized()) {
                    DoseValue doseValue = new DoseValue(f2);
                    f2 = doseValue.getValueInGy();
                }
                dvhAnnotationType = DvhAnnotationType.DOSE;
            }
            this.annotation = DVHAnnotation.create(this.dvhParams, dvhDisplayInfo, f2, dvhAnnotationType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            jTextField.setBackground(MIMLookAndFeel.p().darker());
            return;
        }
        finally {
            this.latch.countDown();
        }
        if (this.onComplete != null) {
            this.onComplete.run();
        }
        this.setVisible(false);
        this.dispose();
    }

    private void cancelAnnotation(@d ActionEvent actionEvent) {
        this.latch.countDown();
        this.setVisible(false);
        this.dispose();
    }

    public DVHAnnotation getAnnotation() {
        return this.getFuture().get();
    }

    public FuncUtils.k<DVHAnnotation> getFuture() {
        return new FuncUtils.k<DVHAnnotation>(){

            @Override
            public boolean cancel(boolean bl2) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return DVHAnnotationDialog.this.latch.getCount() == 0L;
            }

            @Override
            public DVHAnnotation get() {
                return this.get(Long.MAX_VALUE, TimeUnit.DAYS);
            }

            @Override
            public DVHAnnotation get(long l2, TimeUnit timeUnit) {
                try {
                    DVHAnnotationDialog.this.latch.await(l2, timeUnit);
                }
                catch (InterruptedException interruptedException) {
                    ay.c((Object)"failed to get annotation", (Throwable)interruptedException, DVHAnnotationDialog.class);
                    return null;
                }
                return DVHAnnotationDialog.this.annotation;
            }
        };
    }
}

