/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.mimvista.dicom.rtdose.gui.DVHAnnotation;
import com.mimvista.dicom.rtdose.gui.DVHChartMouseListenerCB;
import com.mimvista.dicom.rtdose.gui.DVHChartPanel;
import com.mimvista.dicom.rtdose.gui.DVHCurrentLocation;
import com.mimvista.dicom.rtdose.gui.DVHHoverComparisonNote;
import com.mimvista.dicom.rtdose.gui.DVHNoteDisplay;
import com.mimvista.dicom.rtdose.gui.DvhDisplayInfo;
import com.mimvista.util.Messages;
import com.mimvista.util.Pair;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;

public class DVHChartMouseListener
implements ChartMouseListener {
    final DVHChartMouseListenerCB cb;
    final DVHChartPanel chart;

    public DVHChartMouseListener(DVHChartPanel dVHChartPanel, DVHChartMouseListenerCB dVHChartMouseListenerCB) {
        this.chart = dVHChartPanel;
        this.cb = dVHChartMouseListenerCB;
    }

    public void chartMouseClicked(ChartMouseEvent chartMouseEvent) {
        DVHNoteDisplay dVHNoteDisplay = this.chart.getNoteUnderCurrentMouseLocation();
        if (chartMouseEvent.getTrigger().getButton() == 1) {
            if (dVHNoteDisplay != null && this.chart.getDraggedNote() == null) {
                this.chart.setDraggedNote(dVHNoteDisplay);
                this.chartMouseMoved(chartMouseEvent);
                return;
            }
            if (this.chart.getDraggedNote() != null) {
                this.chart.setDraggedNote(null);
            }
            if (chartMouseEvent.getEntity() instanceof XYItemEntity) {
                XYItemEntity xYItemEntity = (XYItemEntity)chartMouseEvent.getEntity();
                this.cb.setSelectedDVH(xYItemEntity.getSeriesIndex());
            }
            this.chartMouseMoved(chartMouseEvent);
        } else if (dVHNoteDisplay != null && dVHNoteDisplay.getNote() instanceof DVHAnnotation) {
            JMenuItem jMenuItem;
            this.chartMouseMoved(chartMouseEvent);
            JPopupMenu jPopupMenu = new JPopupMenu();
            final DVHNoteDisplay dVHNoteDisplay2 = dVHNoteDisplay;
            final DVHAnnotation dVHAnnotation = (DVHAnnotation)dVHNoteDisplay.getNote();
            Messages messages = Messages.a("DVH");
            if (dVHNoteDisplay2.isPinned()) {
                jMenuItem = new JMenuItem(messages.b("DVH_ANNOTATE_UNPIN"));
                jMenuItem.addActionListener(actionEvent -> {
                    dVHNoteDisplay2.setUnpinned();
                    this.chart.repaint();
                });
                jPopupMenu.add(jMenuItem);
            }
            jMenuItem = new JMenuItem(messages.b("DVH_ANNOTATE_DELETE"));
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DVHChartMouseListener.this.chart.removeAnnotation(dVHNoteDisplay2);
                    DVHChartMouseListener.this.chart.repaint();
                }
            });
            JMenuItem jMenuItem2 = new JMenuItem(messages.b("DVH_ANNOTATE_EDIT"));
            jMenuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DVHChartMouseListener.this.cb.setSelectedDVH(dVHAnnotation.ddi);
                    DVHChartMouseListener.this.chart.showAnnotationDialog(Messages.a("DVH", "DVH_ANNOTATE_EDIT_TITLE"), DVHChartMouseListener.this.cb.getSelectedDVH(), new Runnable(){

                        @Override
                        public void run() {
                            DVHChartMouseListener.this.chart.removeAnnotation(dVHNoteDisplay2);
                            DVHChartMouseListener.this.chart.repaint();
                        }
                    });
                }
            });
            jPopupMenu.add(jMenuItem);
            jPopupMenu.add(jMenuItem2);
            Point2D point2D = this.chart.getCurrentMouseLocation();
            jPopupMenu.show((Component)((Object)this.chart), (int)point2D.getX(), (int)point2D.getY());
        }
    }

    public void chartMouseMoved(ChartMouseEvent chartMouseEvent) {
        Point point = chartMouseEvent.getTrigger().getPoint();
        Point2D point2D = this.chart.translateScreenToJava2D(point);
        if (this.chart.getDraggedNote() != null) {
            this.chart.getDraggedNote().setPinnedPosition(point);
            this.chart.setCurrentMouseLocation(point2D);
            this.chart.clearAnnotationLinesAndPoints();
            this.chart.setCurrentLocationNote(null);
            this.chart.repaint();
            return;
        }
        this.chart.setCurrentMouseLocation(point2D);
        this.chart.clearAnnotationLinesAndPoints();
        this.chart.setCurrentLocationNote(null);
        Pair<DvhDisplayInfo, Integer> pair = this.cb.getSelectedDVH();
        int n2 = (Integer)pair.y;
        DvhDisplayInfo dvhDisplayInfo = (DvhDisplayInfo)pair.x;
        if (n2 == -1) {
            this.chart.repaint();
            return;
        }
        ValueAxis valueAxis = this.chart.getChart().getXYPlot().getRangeAxis();
        ValueAxis valueAxis2 = this.chart.getChart().getXYPlot().getDomainAxis();
        Rectangle2D rectangle2D = this.chart.getChartRenderingInfo().getPlotInfo().getDataArea();
        double d2 = valueAxis2.java2DToValue(point2D.getX(), rectangle2D, RectangleEdge.BOTTOM);
        XYDataset xYDataset = this.chart.getChart().getXYPlot().getDataset();
        Point2D.Double double_ = this.getChartPointForXPosition(xYDataset, n2, d2);
        Point point2 = this.convertToScreen(valueAxis, valueAxis2, rectangle2D, valueAxis2.getLowerBound(), 0.0);
        Point point3 = this.convertToScreen(valueAxis, valueAxis2, rectangle2D, double_.x, double_.y);
        this.chart.addAnnotationLine(new Line2D.Float(point3.x, point2.y, point3.x, point3.y));
        this.chart.addAnnotationLine(new Line2D.Float(point3.x, point3.y, point2.x, point3.y));
        this.chart.addAnnotationPoint(point3.x, point3.y);
        List<Pair<DvhDisplayInfo, Integer>> list = this.cb.getComparisonDVHs();
        if (list.size() != 1) {
            this.chart.setCurrentLocationNote(new DVHCurrentLocation(this.chart, point3, double_.x, double_.y, dvhDisplayInfo.getDVH()));
        } else {
            DVHHoverComparisonNote dVHHoverComparisonNote = new DVHHoverComparisonNote(this.chart, point3, double_.x, double_.y, dvhDisplayInfo.getDVH());
            for (Pair<DvhDisplayInfo, Integer> pair2 : list) {
                Point2D.Double double_2 = this.getChartPointForXPosition(xYDataset, (Integer)pair2.y, d2);
                if (double_2.x == 0.0) {
                    double_2.x = d2;
                }
                Point point4 = this.convertToScreen(valueAxis, valueAxis2, rectangle2D, double_2.x, double_2.y);
                this.chart.addAnnotationPoint(point4.x, point4.y);
                dVHHoverComparisonNote.setReferenceDVH(((DvhDisplayInfo)pair2.x).getDVH(), double_2.x, double_2.y);
            }
            this.chart.setCurrentLocationNote(dVHHoverComparisonNote);
        }
        this.chart.repaint();
    }

    private Point2D.Double getChartPointForXPosition(XYDataset xYDataset, int n2, double d2) {
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i2 = 0; i2 < xYDataset.getItemCount(n2); ++i2) {
            d3 = xYDataset.getXValue(n2, i2);
            if (!(d3 >= d2)) continue;
            d4 = xYDataset.getYValue(n2, i2);
            double_ = new Point2D.Double(d3, d4);
            break;
        }
        return double_;
    }

    private Point convertToScreen(ValueAxis valueAxis, ValueAxis valueAxis2, Rectangle2D rectangle2D, double d2, double d3) {
        double d4 = valueAxis2.valueToJava2D(d2, rectangle2D, RectangleEdge.BOTTOM);
        double d5 = valueAxis.valueToJava2D(d3, rectangle2D, RectangleEdge.LEFT);
        Point2D.Double double_ = new Point2D.Double(d4, d5);
        Point point = this.chart.translateJava2DToScreen(double_);
        return point;
    }
}

