/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.google.common.collect.Lists;
import com.mimvista.d;
import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.dicom.rtdose.gui.DVHAnnotation;
import com.mimvista.dicom.rtdose.gui.DVHAnnotationDialog;
import com.mimvista.dicom.rtdose.gui.DVHChartWrapper;
import com.mimvista.dicom.rtdose.gui.DVHCurrentLocation;
import com.mimvista.dicom.rtdose.gui.DVHDisplayParams;
import com.mimvista.dicom.rtdose.gui.DVHNoteDisplay;
import com.mimvista.dicom.rtdose.gui.DvhAnnotationType;
import com.mimvista.dicom.rtdose.gui.DvhDisplayInfo;
import com.mimvista.dose.constraints.AppliedDoseContourConstraint;
import com.mimvista.dose.constraints.DoseConstraintSet;
import com.mimvista.dose.constraints.units.DoseUnit;
import com.mimvista.dose.constraints.units.VolumeUnit;
import com.mimvista.util.Pair;
import com.mimvista.util.work.m;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;

public class DVHChartPanel
extends ChartPanel {
    private static final long serialVersionUID = 1L;
    private DVHChartWrapper chartWrapper;
    private List<Line2D> annotationLines = Lists.newArrayList();
    private List<Point> annotationPoints = Lists.newArrayList();
    private DVHCurrentLocation currLoc = null;
    private Point2D curMouseLoc = null;
    private List<DVHAnnotation> specialAnnotations = new CopyOnWriteArrayList<DVHAnnotation>();
    private List<DVHNoteDisplay> displayAnnotations = new ArrayList<DVHNoteDisplay>();
    private List<DVHAnnotation> removedAnnotations = new ArrayList<DVHAnnotation>();
    private DVHNoteDisplay curMouseNote;
    private DVHNoteDisplay draggedNote;
    private JFrame frame;

    public static double normalizeVolume(double d2, DoseVolumeHistogram doseVolumeHistogram) {
        return d2 / doseVolumeHistogram.getMaxVolume() * 100.0;
    }

    static double unnormalizeVolume(double d2, DoseVolumeHistogram doseVolumeHistogram) {
        return doseVolumeHistogram.getMaxVolume() * d2 / 100.0;
    }

    public DVHChartPanel(DVHChartWrapper dVHChartWrapper, @d JFrame jFrame) {
        this(dVHChartWrapper, true, jFrame);
    }

    public DVHChartPanel(DVHChartWrapper dVHChartWrapper, boolean bl2, @d JFrame jFrame) {
        super(dVHChartWrapper.getAsAJFreeChart(), bl2);
        this.chartWrapper = dVHChartWrapper;
        this.frame = jFrame;
        this.setDoubleBuffered(true);
        this.setMaximumDrawWidth(4000);
        this.setMaximumDrawHeight(4000);
        this.setLayout(new BorderLayout());
        this.setMouseZoomable(false, false);
        this.setPopupMenu(null);
        this.setRefreshBuffer(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                DVHChartPanel.this.clearAnnotationLinesAndPoints();
                DVHChartPanel.this.currLoc = null;
                DVHChartPanel.this.repaint();
            }
        });
    }

    public void setChart(DVHChartWrapper dVHChartWrapper) {
        super.setChart(dVHChartWrapper.getAsAJFreeChart());
        this.chartWrapper = dVHChartWrapper;
    }

    public DVHChartWrapper getChartWrapper() {
        return this.chartWrapper;
    }

    @Deprecated
    public void setChart(JFreeChart jFreeChart) {
        super.setChart(jFreeChart);
    }

    public void showAnnotationDialog(String string, Pair<DvhDisplayInfo, Integer> pair, Runnable runnable) {
        final DVHAnnotationDialog dVHAnnotationDialog = new DVHAnnotationDialog(this, string, pair, runnable);
        dVHAnnotationDialog.pack();
        dVHAnnotationDialog.setLocationRelativeTo((Component)((Object)this));
        dVHAnnotationDialog.setVisibleNoLoadBounds(true);
        m.e.submit(new Runnable(){

            @Override
            public void run() {
                DVHChartPanel.this.addAnnotation(dVHAnnotationDialog.getAnnotation());
                DVHChartPanel.this.repaint();
            }
        });
    }

    public void setSpecialAnnotations(List<DVHAnnotation> list) {
        this.clearSpecialAnnotations();
        this.specialAnnotations.addAll(list);
        for (DVHAnnotation dVHAnnotation : this.specialAnnotations) {
            this.displayAnnotations.add(new DVHNoteDisplay(dVHAnnotation, this));
        }
    }

    public void clearSpecialAnnotations() {
        this.specialAnnotations.clear();
        this.displayAnnotations.clear();
    }

    public void removeAnnotation(DVHNoteDisplay dVHNoteDisplay) {
        this.specialAnnotations.remove(dVHNoteDisplay.getNote());
        this.displayAnnotations.remove(dVHNoteDisplay);
        this.removedAnnotations.add((DVHAnnotation)dVHNoteDisplay.getNote());
    }

    public List<DVHAnnotation> getSpecialAnnotations() {
        return this.specialAnnotations;
    }

    public List<DVHAnnotation> getRemovedAnnotations() {
        return this.removedAnnotations;
    }

    public void clearRemovedAnnotations() {
        this.removedAnnotations.clear();
    }

    public Point2D getCurrentMouseLocation() {
        return this.curMouseLoc;
    }

    public void setCurrentMouseLocation(Point2D point2D) {
        this.curMouseLoc = point2D;
    }

    public DVHNoteDisplay getNoteUnderCurrentMouseLocation() {
        return this.curMouseNote;
    }

    public DVHNoteDisplay getDraggedNote() {
        return this.draggedNote;
    }

    public void setDraggedNote(DVHNoteDisplay dVHNoteDisplay) {
        this.draggedNote = dVHNoteDisplay;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void setCurrentLocationNote(DVHCurrentLocation dVHCurrentLocation) {
        this.currLoc = dVHCurrentLocation;
    }

    public void clearAnnotationLinesAndPoints() {
        this.annotationLines.clear();
        this.annotationPoints.clear();
    }

    public void addAnnotationLine(Line2D line2D) {
        this.annotationLines.add(line2D);
    }

    public void addAnnotationPoint(int n2, int n3) {
        this.annotationPoints.add(new Point(n2, n3));
    }

    public void addSpecialMarkAtXValue(DvhDisplayInfo dvhDisplayInfo, double d2) {
        this.addAnnotation(dvhDisplayInfo, d2, DvhAnnotationType.DOSE);
    }

    public void addSpecialMarkAtYValue(DvhDisplayInfo dvhDisplayInfo, double d2) {
        this.addAnnotation(dvhDisplayInfo, d2, DvhAnnotationType.VOLUME);
    }

    public void addAnnotation(DvhDisplayInfo dvhDisplayInfo, double d2, DvhAnnotationType dvhAnnotationType) {
        DVHAnnotation dVHAnnotation = DVHAnnotation.create(this.chartWrapper.getParams(), dvhDisplayInfo, d2, dvhAnnotationType);
        this.addAnnotation(dVHAnnotation);
    }

    protected void addAnnotation(DVHAnnotation dVHAnnotation) {
        if (dVHAnnotation != null) {
            if (!dVHAnnotation.annotates(this.chartWrapper.getParams())) {
                throw new IllegalArgumentException("Invalid annotation");
            }
            this.displayAnnotations.add(new DVHNoteDisplay(dVHAnnotation, this));
            this.specialAnnotations.add(dVHAnnotation);
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(this.getChartWrapper().getParams().getLookAndFeel().getBlack());
        graphics2D.setFont(Font.decode("Monospaced"));
        this.paintOverlays(graphics2D);
    }

    public void paintOverlays(Graphics2D graphics2D) {
        this.drawCurrLoc(graphics2D);
        this.drawAnnotations(graphics2D, this.specialAnnotations);
    }

    public void loadAnnotationsFromConstraints(DoseConstraintSet doseConstraintSet, Collection<DvhDisplayInfo> collection) {
        DVHDisplayParams dVHDisplayParams = this.getChartWrapper().getParams();
        for (DvhDisplayInfo dvhDisplayInfo : collection) {
            block5: for (AppliedDoseContourConstraint appliedDoseContourConstraint : doseConstraintSet.constraints) {
                if (!appliedDoseContourConstraint.matches(dvhDisplayInfo.getDVH().getGeneratedFrom())) continue;
                switch (appliedDoseContourConstraint.constraint.getType()) {
                    case a: {
                        double d2;
                        Double d3 = appliedDoseContourConstraint.constraint.getTargetValue();
                        if (d3 == null) continue block5;
                        if (!dVHDisplayParams.getDoseNormType().isNormalized()) {
                            if (appliedDoseContourConstraint.constraint.getUnits() != DoseUnit.a) {
                                d3 = appliedDoseContourConstraint.constraint.getUnits() == DoseUnit.b ? Double.valueOf(d3 / 100.0) : (appliedDoseContourConstraint.constraint.getUnits() == DoseUnit.c ? Double.valueOf((double)dVHDisplayParams.getMaxDose().getValueInGy() * d3 / 100.0) : Double.valueOf((double)dVHDisplayParams.getRxDose().getValueInGy() * d3 / 100.0));
                            }
                        } else if (appliedDoseContourConstraint.constraint.getUnits() == DoseUnit.a || appliedDoseContourConstraint.constraint.getUnits() == DoseUnit.b) {
                            if (appliedDoseContourConstraint.constraint.getUnits() == DoseUnit.b) {
                                d3 = d3 / 100.0;
                            }
                            d3 = dVHDisplayParams.normalizeDose(d3, dvhDisplayInfo.getDVH());
                        } else if (appliedDoseContourConstraint.constraint.getUnits() == DoseUnit.d) {
                            d2 = (double)dVHDisplayParams.getRxDose().getValueInGy() * d3 / 100.0;
                            d3 = dVHDisplayParams.normalizeDose(d2, dvhDisplayInfo.getDVH());
                        } else {
                            double d4 = (double)dVHDisplayParams.getMaxDose().getValueInGy() * d3 / 100.0;
                            d3 = dVHDisplayParams.normalizeDose(d4, dvhDisplayInfo.getDVH());
                        }
                        d2 = d3;
                        this.addSpecialMarkAtXValue(dvhDisplayInfo, d2);
                        break;
                    }
                    case b: {
                        Double d3 = appliedDoseContourConstraint.constraint.getTargetValue();
                        if (d3 == null) break;
                        VolumeUnit volumeUnit = dVHDisplayParams.isNormalizedVolume() ? VolumeUnit.b : VolumeUnit.a;
                        this.addSpecialMarkAtYValue(dvhDisplayInfo, volumeUnit.a(d3, appliedDoseContourConstraint.constraint.getUnits(), dVHDisplayParams::getRxDose, dvhDisplayInfo.getDVH()));
                    }
                }
            }
        }
        this.repaint();
    }

    private void drawCurrLoc(Graphics2D graphics2D) {
        for (Line2D object : this.annotationLines) {
            graphics2D.draw(object);
        }
        for (Point point : this.annotationPoints) {
            Color color = graphics2D.getBackground();
            graphics2D.setBackground(Color.white);
            int n2 = 4;
            graphics2D.fillOval(point.x - n2, point.y - n2, n2 * 2 + 1, n2 * 2 + 1);
            graphics2D.setBackground(color);
        }
        DVHCurrentLocation dVHCurrentLocation = this.currLoc;
        if (dVHCurrentLocation != null) {
            DVHNoteDisplay dVHNoteDisplay = new DVHNoteDisplay(dVHCurrentLocation, this);
            dVHNoteDisplay.draw(graphics2D, dVHCurrentLocation.getScreenLocation());
        }
    }

    private void drawAnnotations(Graphics2D graphics2D, List<DVHAnnotation> list2) {
        this.curMouseNote = null;
        Collections.sort(this.displayAnnotations, new AnnotationsStartXComparator());
        Rectangle2D rectangle2D = this.getChartRenderingInfo().getPlotInfo().getDataArea();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        int n3 = (int)(rectangle2D.getMaxY() - rectangle2D.getMinY()) / (n2 * 4);
        int[] nArray = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[i2] = (int)rectangle2D.getMinX();
        }
        Set set = this.chartWrapper.getParams().getFilteredDVHs().values().stream().flatMap(list -> list.stream()).collect(Collectors.toSet());
        for (int i3 = 0; i3 < this.displayAnnotations.size(); ++i3) {
            int n4;
            DVHNoteDisplay dVHNoteDisplay = this.displayAnnotations.get(i3);
            if (!dVHNoteDisplay.isVisible() || dVHNoteDisplay.getNote() instanceof DVHAnnotation && !set.contains(((DVHAnnotation)dVHNoteDisplay.getNote()).ddi)) continue;
            Point2D point2D = dVHNoteDisplay.getNominalPosition();
            int n5 = (int)point2D.getY();
            int n6 = (int)point2D.getX();
            int n7 = dVHNoteDisplay.getWidth(graphics2D);
            int n8 = Math.min(n3 - 1, (int)((double)n5 - rectangle2D.getMinY()) / (n2 * 4));
            int n9 = Math.max(nArray[n8], n8 > 0 ? nArray[n8 - 1] : 0);
            int n10 = n4 = Math.max(n9, n6 - n7);
            int n11 = n8;
            int n12 = n9;
            if (n8 < n3 - 1) {
                n11 = n8 + 1;
                n12 = nArray[n11];
                n10 = Math.max(n12, n6 - n7);
            }
            int n13 = n4;
            if (n4 <= n10 && (double)(n5 - dVHNoteDisplay.getHeight(graphics2D)) > rectangle2D.getMinY()) {
                nArray[n8] = n9 = n4 + n7;
                if (n8 > 0) {
                    nArray[n8 - 1] = Math.max(n9, nArray[n8 - 1]);
                }
            } else {
                nArray[n11] = n12 = n10 + n7;
                n13 = n10;
                if (n11 < n3 - 1) {
                    nArray[n11 + 1] = Math.max(n12, nArray[n11 + 1]);
                }
                n5 += dVHNoteDisplay.getHeight(graphics2D);
            }
            Point point = new Point(n13, n5);
            Rectangle rectangle = dVHNoteDisplay.draw(graphics2D, point);
            if (this.getDraggedNote() != null) {
                if (!dVHNoteDisplay.equals(this.getDraggedNote())) continue;
                graphics2D.drawRect(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
                continue;
            }
            if (this.curMouseLoc == null || !rectangle.contains(this.curMouseLoc)) continue;
            graphics2D.drawRect(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
            this.curMouseNote = dVHNoteDisplay;
        }
    }

    private class AnnotationsStartXComparator
    implements Comparator<DVHNoteDisplay> {
        private AnnotationsStartXComparator() {
        }

        @Override
        public int compare(DVHNoteDisplay dVHNoteDisplay, DVHNoteDisplay dVHNoteDisplay2) {
            return (int)Math.signum(dVHNoteDisplay.getNominalPosition().getX() - dVHNoteDisplay2.getNominalPosition().getX());
        }
    }
}

