/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.mimvista.dicom.rtdose.DVHCollection;
import com.mimvista.dicom.rtdose.DoseValue;
import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.dicom.rtdose.gui.DVHDisplayParams;
import com.mimvista.dicom.rtdose.gui.DoseNormType;
import com.mimvista.dicom.rtdose.gui.DvhDisplayInfo;
import com.mimvista.dicom.rtdose.gui.DvhPoint;
import com.mimvista.internals.statistics.OverlayStatistician;
import com.mimvista.mui.graph.MIMChartFactory;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.List;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class DVHChartWrapper {
    private static final double EPSILON = 1.0E-7;
    public static final int ONE_HUNDRED_PERCENT_PLUS_BUFFER = 105;
    private JFreeChart chart;
    private final DVHDisplayParams params;

    public DVHChartWrapper(DVHDisplayParams dVHDisplayParams) {
        this.params = dVHDisplayParams;
        this.build();
    }

    public DVHDisplayParams getParams() {
        return this.params;
    }

    private void build() {
        String string = this.getYAxisLabel();
        String string2 = this.getXAxisLabel();
        this.chart = MIMChartFactory.a("", string2, string, (XYDataset)this.buildDataset(this.params), this.params.isShowLegend(), this.params.isShowGridLines(), this.params.getLookAndFeel());
        this.updateColors();
        this.updateStrokes();
        this.updateVisibleBounds();
        this.enforceDoseCap();
    }

    private XYSeriesCollection buildDataset(DVHDisplayParams dVHDisplayParams) {
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        float f2 = 0.0f;
        if (dVHDisplayParams.getDoseNormType() == DoseNormType.DOSEMAX) {
            f2 = dVHDisplayParams.getMaxDose().getValueInCurrentUnit();
        } else if (dVHDisplayParams.getDoseNormType() == DoseNormType.PRESCRIPTION) {
            f2 = dVHDisplayParams.getRxDose().getValueInCurrentUnit();
        }
        for (Iterable iterable : dVHDisplayParams.getFilteredDVHs().values()) {
            for (DvhDisplayInfo dvhDisplayInfo : iterable) {
                String string = dVHDisplayParams.isUseNamesForReporting() ? dvhDisplayInfo.getDVHProducer().getNameForReporting() : dvhDisplayInfo.getDVHProducer().getName();
                XYSeries xYSeries = new XYSeries((Comparable)((Object)string));
                if (dvhDisplayInfo.isVisible()) {
                    DoseVolumeHistogram doseVolumeHistogram = dvhDisplayInfo.getDVH();
                    DvhPoint dvhPoint = null;
                    for (DvhPoint dvhPoint2 : doseVolumeHistogram) {
                        if (dvhPoint2.getVolumeInCC() <= 1.0E-7) {
                            if (!(dvhPoint2.getDoseInCurrentUnit() < 0.0)) break;
                            continue;
                        }
                        if (!this.addSeries(dVHDisplayParams.isNormalizedVolume(), dVHDisplayParams.getDoseNormType(), f2, doseVolumeHistogram, xYSeries, dvhPoint2.getDoseInCurrentUnit(), dvhPoint2.getVolumeInCC())) continue;
                        dvhPoint = dvhPoint2;
                    }
                    if (dvhPoint != null && dvhPoint.getVolumeInCC() > 0.0) {
                        this.addSeries(dVHDisplayParams.isNormalizedVolume(), dVHDisplayParams.getDoseNormType(), f2, doseVolumeHistogram, xYSeries, dvhPoint.getDoseInCurrentUnit(), 0.0);
                    }
                }
                xYSeriesCollection.addSeries(xYSeries);
            }
        }
        return xYSeriesCollection;
    }

    public String getXAxisLabel() {
        String string = Messages.a("DVH").b("DVH_DOSE");
        string = string + " (";
        string = string + this.params.getXAxisUnits();
        string = string + ")";
        return string;
    }

    public String getXAxisUnits() {
        return this.params.getXAxisUnits();
    }

    private String getYAxisLabel() {
        String string = Messages.a("DVH").b("DVH_VOLUME");
        string = this.params.isNormalizedVolume() ? Messages.a("DVH").b("DVH_PER_COV") : string + " " + MIMFormat.a(Messages.a("DVH").b("DVH_UNIT_CM3"), OverlayStatistician.t());
        return string;
    }

    public String getYAxisUnits() {
        return this.params.getYAxisUnits();
    }

    boolean addSeries(boolean bl2, DoseNormType doseNormType, float f2, DoseVolumeHistogram doseVolumeHistogram, XYSeries xYSeries, double d2, double d3) {
        double d4;
        double d5 = bl2 ? d3 / doseVolumeHistogram.getMaxVolume() * 100.0 : d3;
        if (doseNormType.isNormalized()) {
            if (f2 <= 0.0f) {
                DoseValue doseValue = new DoseValue();
                doseValue.setValueInGy((float)doseVolumeHistogram.getMaxDose());
                f2 = doseValue.getValueInCurrentUnit();
            }
            d4 = d2 * doseVolumeHistogram.getDoseScaling() * 100.0 / (double)f2;
        } else {
            d4 = d2 * doseVolumeHistogram.getDoseScaling();
        }
        if (!Double.isNaN(d5)) {
            xYSeries.add(d4, d5);
            return true;
        }
        return false;
    }

    void updateStrokes() {
        int n2 = 0;
        for (Map.Entry<DVHCollection, List<DvhDisplayInfo>> entry : this.params.getFilteredDVHs().entrySet()) {
            List<DvhDisplayInfo> list = entry.getValue();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                this.chart.getXYPlot().getRenderer().setSeriesStroke(n2, (Stroke)list.get(i2).getLineStyle().getStroke());
                ++n2;
            }
        }
    }

    void updateVisibleBounds() {
        double d2 = 0.0;
        for (List<DvhDisplayInfo> valueAxis2 : this.params.getFilteredDVHs().values()) {
            for (DvhDisplayInfo d3 : valueAxis2) {
                if (!d3.isVisible()) continue;
                d2 = Math.max(d2, d3.getDVH().getMaxVolume());
            }
        }
        Float f2 = Float.valueOf(this.params.getMaxVisibleDoseOrUserDefined().getValueInCurrentUnit());
        ValueAxis valueAxis = this.chart.getXYPlot().getRangeAxis();
        ValueAxis valueAxis2 = this.chart.getXYPlot().getDomainAxis();
        if (this.params.isNormalizedVolume()) {
            valueAxis.setRange(0.0, 105.0);
        } else {
            valueAxis.setRange(0.0, 1.1 * d2);
        }
        double d3 = valueAxis2.getLowerBound();
        if (this.params.getDoseNormType() == DoseNormType.DOSEMAX) {
            valueAxis2.setRange(d3, 105.0);
        } else if (f2.floatValue() > 0.0f) {
            if (this.params.getDoseNormType() == DoseNormType.ABSOLUTE) {
                valueAxis2.setRange(d3, (double)(1.0f * f2.floatValue()));
            } else if (this.params.getDoseNormType() == DoseNormType.PRESCRIPTION) {
                float f3 = this.params.getRxDose().getValueInCurrentUnit();
                double d4 = f3 > 0.0f ? (double)(105.0f * f2.floatValue() / f3) : 105.0;
                valueAxis2.setRange(d3, Math.max(100.0, d4));
            }
        }
    }

    void updateColors() {
        int n2 = 0;
        for (Map.Entry<DVHCollection, List<DvhDisplayInfo>> entry : this.params.getFilteredDVHs().entrySet()) {
            List<DvhDisplayInfo> list = entry.getValue();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                XYItemRenderer xYItemRenderer = this.chart.getXYPlot().getRenderer();
                if (list.get(i2).isVisible()) {
                    xYItemRenderer.setSeriesVisible(n2, Boolean.valueOf(true));
                    xYItemRenderer.setSeriesPaint(n2, (Paint)list.get(i2).getColor());
                } else {
                    xYItemRenderer.setSeriesVisible(n2, Boolean.valueOf(false));
                    xYItemRenderer.setSeriesVisibleInLegend(n2, Boolean.valueOf(false));
                    xYItemRenderer.setSeriesPaint(n2, (Paint)new Color(0, 0, 0, 0));
                }
                ++n2;
            }
        }
    }

    void enforceDoseCap() {
        if (this.params.isUseDoseCap()) {
            double d2;
            ValueAxis valueAxis = this.chart.getXYPlot().getDomainAxis();
            double d3 = valueAxis.getLowerBound();
            if (d3 > 0.0) {
                d3 = 0.0;
            }
            if ((d2 = valueAxis.getUpperBound()) < 0.0) {
                d2 = 0.0;
            }
            Float f2 = this.params.getRelativeDoseCap();
            d2 = Math.min(d2, (double)f2.floatValue());
            d3 = Math.min(d3, d2 - (double)0.001f);
            valueAxis.setRange(d3, d2);
        }
    }

    public JFreeChart getAsAJFreeChart() {
        return this.chart;
    }
}

