/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.dicom.rtdose.gui.DVHChartPanel;
import com.mimvista.dicom.rtdose.gui.DVHFrame;
import com.mimvista.dicom.rtdose.gui.DVHNote;
import com.mimvista.dicom.rtdose.gui.DoseNormType;
import java.awt.Point;

public class DVHCurrentLocation
implements DVHNote {
    private DVHChartPanel chart;
    private Point screenPoint;
    double xLocation;
    double yLocation;
    DoseVolumeHistogram selectedDVH;

    public DVHCurrentLocation(DVHChartPanel dVHChartPanel, Point point, double d2, double d3, DoseVolumeHistogram doseVolumeHistogram) {
        this.chart = dVHChartPanel;
        this.screenPoint = point;
        this.xLocation = d2;
        this.yLocation = d3;
        this.selectedDVH = doseVolumeHistogram;
    }

    public Point getScreenLocation() {
        return this.screenPoint;
    }

    @Override
    public DoseVolumeHistogram getParentCurve() {
        return this.selectedDVH;
    }

    @Override
    public double getDoseInCurrentUnit() {
        double d2 = this.xLocation;
        DoseVolumeHistogram doseVolumeHistogram = this.selectedDVH;
        return this.getGrayTypeDose(d2, doseVolumeHistogram);
    }

    double getGrayTypeDose(double d2, DoseVolumeHistogram doseVolumeHistogram) {
        DoseNormType doseNormType = this.chart.getChartWrapper().getParams().getDoseNormType();
        if (doseNormType.isNormalized()) {
            return this.chart.getChartWrapper().getParams().unnormalizeDose(d2, doseVolumeHistogram);
        }
        return d2;
    }

    @Override
    public double getNormalizedDose() {
        return this.xLocation;
    }

    @Override
    public double getVolumeInCC() {
        double d2 = this.yLocation;
        DoseVolumeHistogram doseVolumeHistogram = this.selectedDVH;
        return this.getVolInCC(d2, doseVolumeHistogram);
    }

    double getVolInCC(double d2, DoseVolumeHistogram doseVolumeHistogram) {
        if (this.chart.getChartWrapper().getParams().isNormalizedVolume()) {
            return d2 * doseVolumeHistogram.getMaxVolume() / 100.0;
        }
        return d2;
    }

    @Override
    public double getNormalizedVolume() {
        return this.yLocation;
    }

    @Override
    public String getStructureName() {
        String string = DVHFrame.props.b("DVH_INCLUDED") + " " + this.selectedDVH.getName();
        return string;
    }
}

