/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mimvista.d;
import com.mimvista.dicom.rtdose.DVHCollection;
import com.mimvista.dicom.rtdose.DoseCSVFactory;
import com.mimvista.dicom.rtdose.gui.DVHAnnotation;
import com.mimvista.dicom.rtdose.gui.DVHChartMouseListener;
import com.mimvista.dicom.rtdose.gui.DVHChartMouseListenerCB;
import com.mimvista.dicom.rtdose.gui.DVHChartPanel;
import com.mimvista.dicom.rtdose.gui.DVHChartWrapper;
import com.mimvista.dicom.rtdose.gui.DVHDisplayOptionsPanel;
import com.mimvista.dicom.rtdose.gui.DVHDisplayParams;
import com.mimvista.dicom.rtdose.gui.DVHDisplayState;
import com.mimvista.dicom.rtdose.gui.DVHFrame;
import com.mimvista.dicom.rtdose.gui.DVHPrinter;
import com.mimvista.dicom.rtdose.gui.DVHUpdateListener;
import com.mimvista.dicom.rtdose.gui.DvhCaptureMaker;
import com.mimvista.dicom.rtdose.gui.DvhDisplayInfo;
import com.mimvista.dicom.rtdose.gui.DvhDisplayUpdateHandler;
import com.mimvista.dicom.rtdose.gui.DvhLineStyle;
import com.mimvista.dose.constraints.DoseConstraintSet;
import com.mimvista.mui.MIMFileDialog;
import com.mimvista.mui.captures.Capture;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.report.gui.content.common.filter.DvhDisplayInfoFilter;
import com.mimvista.util.Messages;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.bu;
import com.mimvista.util.cn;
import com.mimvista.util.work.m;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import net.tomahawk.ExtensionsFilter;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeEventType;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeriesCollection;

public class DVHDisplay
extends JPanel
implements DVHDisplayState,
Iterable<DVHCollection> {
    private static final long serialVersionUID = 1L;
    private DVHFrame dvhFrame;
    private DVHChartWrapper chart;
    private DVHChartPanel chartPanel;
    private final DVHDisplayParams params;
    private DVHDisplayOptionsPanel displayOptionsPanel;
    private DvhDisplayUpdateHandler dvhUpdateListener;
    private List<ChartChangeListener> chartChangeListeners = new ArrayList<ChartChangeListener>();
    private boolean lockDoseLineStyles = false;

    public DVHDisplay(@d DVHDisplayParams dVHDisplayParams) {
        this(dVHDisplayParams, null, null);
    }

    public DVHDisplay(@d DVHDisplayParams dVHDisplayParams, @d DvhDisplayUpdateHandler dvhDisplayUpdateHandler) {
        this(dVHDisplayParams, dvhDisplayUpdateHandler, null);
    }

    public DVHDisplay(@d DVHDisplayParams dVHDisplayParams, @d DvhDisplayUpdateHandler dvhDisplayUpdateHandler, @d DVHFrame dVHFrame) {
        this.dvhFrame = dVHFrame;
        this.params = dVHDisplayParams;
        this.dvhUpdateListener = dvhDisplayUpdateHandler == null ? DVHDisplay.getDvhUpdateListener(this, this.params) : dvhDisplayUpdateHandler;
        this.build();
        this.params.addListener(new ParamListener(this, this.dvhUpdateListener, this.displayOptionsPanel));
    }

    private static DvhDisplayUpdateHandler getDvhUpdateListener(final DVHDisplay dVHDisplay, DVHDisplayParams dVHDisplayParams) {
        return new DVHUpdateListener(dVHDisplayParams){

            @Override
            public void dvhMetadataChanged() {
                dVHDisplay.updateUI();
            }
        };
    }

    private void build() {
        this.displayOptionsPanel = new DVHDisplayOptionsPanel(this, 400);
        this.displayOptionsPanel.setMinimumSize(new Dimension(this.displayOptionsPanel.getPreferredSize().width, 0));
        this.rebuildChart();
        this.buildChartPanel();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setPreferredSize(new Dimension(500, 0));
        jPanel.add((Component)((Object)this.chartPanel), "Center");
        this.setLayout(new BorderLayout());
        JSplitPane jSplitPane = new JSplitPane(1, jPanel, this.displayOptionsPanel);
        jSplitPane.setResizeWeight(1.0);
        this.add((Component)jSplitPane, "Center");
    }

    private void buildChartPanel() {
        this.chartPanel = new DVHChartPanel(this.chart, this.dvhFrame);
        DVHChartMouseListenerCB dVHChartMouseListenerCB = new DVHChartMouseListenerCB(){

            @Override
            public void setSelectedDVH(int n2) {
                DVHDisplay.this.selectDVH(n2);
            }

            @Override
            public void setSelectedDVH(DvhDisplayInfo dvhDisplayInfo) {
                DVHDisplay.this.selectDVH(dvhDisplayInfo);
            }

            @Override
            public Pair<DvhDisplayInfo, Integer> getSelectedDVH() {
                return DVHDisplay.this.getSelectedCurve();
            }

            @Override
            public List<Pair<DvhDisplayInfo, Integer>> getComparisonDVHs() {
                Pair<DvhDisplayInfo, Integer> pair2 = DVHDisplay.this.getSelectedCurve();
                if ((Integer)pair2.y < 0) {
                    return DVHChartMouseListenerCB.super.getComparisonDVHs();
                }
                String string = ((DvhDisplayInfo)pair2.x).getName();
                Integer n2 = (Integer)pair2.y;
                return StreamSupport.stream(DVHDisplay.this.filteredDVHCurves().spliterator(), false).filter(pair -> ((DvhDisplayInfo)pair.x).isVisible() && pair.y != n2 && ((DvhDisplayInfo)pair.x).getName().equals(string)).collect(Collectors.toList());
            }
        };
        this.chartPanel.addChartMouseListener(new DVHChartMouseListener(this.chartPanel, dVHChartMouseListenerCB));
    }

    @Override
    public void refreshUI() {
        this.displayOptionsPanel.refresh();
        this.revalidate();
        this.rebuildChart();
    }

    public void finish() {
        if (this.chartPanel != null) {
            this.chartPanel.getChartRenderingInfo().clear();
            this.chartPanel = null;
        }
        if (this.chart != null) {
            this.chart.getAsAJFreeChart().getXYPlot().setDataset((XYDataset)new XYSeriesCollection());
            this.chart = null;
        }
        if (this.dvhUpdateListener != null) {
            this.dvhUpdateListener.cleanup();
            this.dvhUpdateListener = null;
        }
        this.chartChangeListeners.clear();
    }

    public void rebuildChart() {
        this.chart = new DVHChartWrapper(this.params);
        if (this.chartPanel != null) {
            this.chartPanel.setChart(this.chart);
            this.chartPanel.setMouseZoomable(false);
        }
        this.fireChartChangedListener(new ChartChangeEvent((Object)this, this.chart.getAsAJFreeChart(), ChartChangeEventType.NEW_DATASET));
        this.repaint();
    }

    public void addChartChangeListener(ChartChangeListener chartChangeListener) {
        this.chartChangeListeners.add(chartChangeListener);
    }

    private void fireChartChangedListener(ChartChangeEvent chartChangeEvent) {
        for (ChartChangeListener chartChangeListener : this.chartChangeListeners) {
            chartChangeListener.chartChanged(chartChangeEvent);
        }
    }

    @Override
    public void selectDVH(DvhDisplayInfo dvhDisplayInfo) {
        this.displayOptionsPanel.dvhPanel.selectDVH(dvhDisplayInfo);
        this.refreshUI();
    }

    public void selectDVH(int n2) {
        this.displayOptionsPanel.dvhPanel.selectDVH(n2);
        this.refreshUI();
    }

    @Override
    public void showAll() {
        DVHCollection dVHCollection = this.getSelectedCollection();
        this.params.showAll(dVHCollection);
        this.refreshUI();
    }

    @Override
    public void hideAll() {
        DVHCollection dVHCollection = this.getSelectedCollection();
        this.params.hideAll(dVHCollection);
        this.refreshUI();
    }

    public List<DVHAnnotation> getAnnotations() {
        if (this.chartPanel.getSpecialAnnotations() != null) {
            return Lists.newArrayList(this.chartPanel.getSpecialAnnotations());
        }
        return null;
    }

    public Capture makeCapture() {
        DvhCaptureMaker dvhCaptureMaker = new DvhCaptureMaker(this.chartPanel, this.params);
        return dvhCaptureMaker.makeCapture();
    }

    public void printDVH() {
        bu.a(new DVHPrinter(this), OrientationRequested.LANDSCAPE, null);
    }

    public void outputCSVDoses() {
        Window window = SwingUtilities.getWindowAncestor(this);
        MIMFileDialog mIMFileDialog = MIMFileDialog.a(window, Messages.a("DVH").getProperty("DVH_OUTPUT_CSV"), MIMFileDialog.FileDialogType.b, true);
        mIMFileDialog.a(ExtensionsFilter.getNoDescSingleExt("csv"));
        mIMFileDialog.a(true);
        final String string = mIMFileDialog.a();
        if (cn.g(string)) {
            return;
        }
        m.b.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    DoseCSVFactory.writeDVHtoCSV(string, DVHDisplay.this, DVHDisplay.this.getDVHParams());
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(DVHDisplay.this, "Unable to export the dose value histograms to CSV.", "CSV Output Error", 0);
                    ay.d((Object)"Error while exporting DVH to CSV.", (Throwable)exception, this);
                }
            }
        });
    }

    Pair<DvhDisplayInfo, Integer> getSelectedCurve() {
        DvhDisplayInfo dvhDisplayInfo;
        for (Pair<DvhDisplayInfo, Integer> pair : this.filteredDVHCurves()) {
            dvhDisplayInfo = (DvhDisplayInfo)pair.x;
            if (!dvhDisplayInfo.isSelected()) continue;
            if (!dvhDisplayInfo.isVisible()) {
                dvhDisplayInfo.setSelected(false);
                break;
            }
            return pair;
        }
        for (Pair<DvhDisplayInfo, Integer> pair : this.filteredDVHCurves()) {
            dvhDisplayInfo = (DvhDisplayInfo)pair.x;
            if (!dvhDisplayInfo.isVisible()) continue;
            dvhDisplayInfo.setSelected(true);
            this.selectDVH(dvhDisplayInfo);
            return pair;
        }
        return Pair.get(null, -1);
    }

    private Iterable<Pair<DvhDisplayInfo, Integer>> filteredDVHCurves() {
        return new Iterable<Pair<DvhDisplayInfo, Integer>>(){

            @Override
            public Iterator<Pair<DvhDisplayInfo, Integer>> iterator() {
                Map<DVHCollection, List<DvhDisplayInfo>> map = DVHDisplay.this.params.getFilteredDVHs();
                int[] nArray = new int[]{0};
                return map.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).map(dvhDisplayInfo -> {
                    int n2 = nArray[0];
                    nArray[0] = n2 + 1;
                    return Pair.get(dvhDisplayInfo, n2);
                }).iterator();
            }
        };
    }

    public void showAnnotationDialog() {
        this.chartPanel.showAnnotationDialog(Messages.a("DVH").b("DVH_ANNOTATE_ADD"), this.getSelectedCurve(), null);
    }

    public void loadAnnotationsFromConstraints(DoseConstraintSet doseConstraintSet) {
        Collection<List<DvhDisplayInfo>> collection = this.params.getFilteredDVHs().values();
        HashSet hashSet = Sets.newHashSet();
        for (List<DvhDisplayInfo> list : collection) {
            hashSet.addAll(list);
        }
        this.chartPanel.loadAnnotationsFromConstraints(doseConstraintSet, hashSet);
    }

    public void clearSpecialNotes() {
        this.chartPanel.clearSpecialAnnotations();
        this.chartPanel.repaint();
    }

    public DVHChartPanel getChartPanel() {
        return this.chartPanel;
    }

    @Override
    public Iterator<DVHCollection> iterator() {
        return this.params.iterator();
    }

    public DvhDisplayUpdateHandler getDvhUpdateListener() {
        return this.dvhUpdateListener;
    }

    public void updateColors() {
        this.chart.updateColors();
        this.displayOptionsPanel.repaint();
        this.fireChartChangedListener(new ChartChangeEvent((Object)this, this.chart.getAsAJFreeChart(), ChartChangeEventType.DATASET_UPDATED));
    }

    public void updateStrokes() {
        this.chart.updateStrokes();
        this.displayOptionsPanel.repaint();
        this.fireChartChangedListener(new ChartChangeEvent((Object)this, this.chart.getAsAJFreeChart(), ChartChangeEventType.DATASET_UPDATED));
    }

    @Override
    public boolean isInDvhViewer() {
        return this.dvhFrame != null;
    }

    @Override
    public DVHDisplayParams getDVHParams() {
        return this.params;
    }

    @Override
    public void updateColor(DvhDisplayInfo dvhDisplayInfo, Color color) {
        if (this.params.contains(dvhDisplayInfo)) {
            dvhDisplayInfo.setColor(color, true);
            if (this.lockDoseLineStyles) {
                DVHDisplayState.syncLineColors(dvhDisplayInfo, this.params);
            }
            this.updateColors();
        }
    }

    @Override
    public void updateStroke(DvhDisplayInfo dvhDisplayInfo, DvhLineStyle dvhLineStyle) {
        if (this.params.contains(dvhDisplayInfo)) {
            dvhDisplayInfo.setLineStyle(dvhLineStyle);
            this.updateStrokes();
        }
    }

    @Override
    public void updateLockDoseLineStyles(boolean bl2) {
        this.lockDoseLineStyles = bl2;
        DVHDisplayState.updateLockDoseLineStyles(bl2, this.params);
        this.updateColors();
        this.updateStrokes();
    }

    @Override
    public boolean getLockDoseLineStyles() {
        return this.lockDoseLineStyles;
    }

    @Override
    public void setVisible(DvhDisplayInfo dvhDisplayInfo, boolean bl2) {
        DvhDisplayInfoFilter dvhDisplayInfoFilter;
        if (this.params.contains(dvhDisplayInfo)) {
            dvhDisplayInfo.setVisible(bl2);
        }
        if ((dvhDisplayInfoFilter = this.params.getDDIFilter()).g().contains(dvhDisplayInfo)) {
            if (bl2) {
                dvhDisplayInfoFilter.b(dvhDisplayInfo);
            } else {
                dvhDisplayInfoFilter.c(dvhDisplayInfo);
            }
        }
        this.rebuildChart();
    }

    @Override
    public void unselectDVH(DvhDisplayInfo dvhDisplayInfo) {
        if (this.params.contains(dvhDisplayInfo)) {
            dvhDisplayInfo.setSelected(false);
        }
        this.rebuildChart();
    }

    private static class ParamListener
    implements FuncUtils.m<DVHDisplayParams> {
        private DVHDisplay display;
        private DvhDisplayUpdateHandler handler;
        private DVHDisplayOptionsPanel optionsPanel;

        public ParamListener(DVHDisplay dVHDisplay, DvhDisplayUpdateHandler dvhDisplayUpdateHandler, DVHDisplayOptionsPanel dVHDisplayOptionsPanel) {
            this.display = dVHDisplay;
            this.handler = dvhDisplayUpdateHandler;
            this.optionsPanel = dVHDisplayOptionsPanel;
        }

        @Override
        public void doIt(DVHDisplayParams dVHDisplayParams) {
            this.display.rebuildChart();
            this.optionsPanel.optionsPanel.updateFields();
            if (this.handler != null) {
                this.handler.attachToDoseAndContours();
            }
            this.display.refreshUI();
        }
    }
}

