/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.mimvista.dicom.rtdose.gui.DVHDisplayParams;
import com.mimvista.dicom.rtdose.gui.DVHDisplayState;
import com.mimvista.dicom.rtdose.gui.DVHOptionsPanel;
import com.mimvista.dicom.rtdose.gui.DVHSearchPanel;
import com.mimvista.dicom.rtdose.gui.controls.DVHCollectionDisplayControls;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.report.gui.content.common.filter.DvhDisplayInfoFilter;
import com.mimvista.report.gui.content.common.filter.SearchFilterUI;
import com.mimvista.util.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DVHDisplayOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final DVHDisplayParams dvhParams;
    private final DVHDisplayState dvhDisplay;
    private JScrollPane curveScroller;
    protected final SearchFilterUI filterPanel;
    protected final DVHCollectionDisplayControls dvhPanel;
    protected final DVHOptionsPanel optionsPanel;
    protected final DVHSearchPanel searchPanel;

    public DVHDisplayOptionsPanel(DVHDisplayState dVHDisplayState, int n2) {
        super(new BorderLayout());
        this.dvhDisplay = dVHDisplayState;
        this.dvhParams = dVHDisplayState.getDVHParams();
        DvhDisplayInfoFilter dvhDisplayInfoFilter = this.dvhParams.getDDIFilter();
        if (this.dvhDisplay.isInDvhViewer()) {
            if (dvhDisplayInfoFilter.a().i().isEmpty()) {
                dvhDisplayInfoFilter.a().a("*");
            }
            this.searchPanel = new DVHSearchPanel(this.dvhParams);
        } else {
            this.searchPanel = null;
        }
        this.dvhParams.updateDDIFilter();
        this.filterPanel = new SearchFilterUI(dvhDisplayInfoFilter, new DefaultListCellRenderer());
        this.filterPanel.setBorder(BorderFactory.createTitledBorder(Messages.a("DVH", "DVH_SEARCH")));
        this.filterPanel.setPreferredSize(new Dimension(0, 250));
        this.dvhPanel = new DVHCollectionDisplayControls(dVHDisplayState, n2);
        this.optionsPanel = new DVHOptionsPanel(dVHDisplayState);
        this.build();
    }

    private void build() {
        this.curveScroller = new JScrollPane(this.dvhPanel);
        this.curveScroller.setBorder(BorderFactory.createLineBorder(MIMLookAndFeel.e(), 1));
        if (this.dvhDisplay.isInDvhViewer()) {
            this.add((Component)this.searchPanel, "North");
        } else {
            this.add((Component)this.filterPanel, "North");
        }
        this.add((Component)this.curveScroller, "Center");
        this.add((Component)this.optionsPanel, "South");
    }

    public void refresh() {
        this.dvhPanel.refresh();
        this.curveScroller.revalidate();
        this.optionsPanel.updateFields();
    }
}

