/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mimvista.dicom.rtdose.DVHCollection;
import com.mimvista.dicom.rtdose.DoseValue;
import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.dicom.rtdose.ReferencedRoi;
import com.mimvista.dicom.rtdose.gui.BlackWhiteLookAndFeel;
import com.mimvista.dicom.rtdose.gui.DoseNormType;
import com.mimvista.dicom.rtdose.gui.DvhDisplayInfo;
import com.mimvista.internals.statistics.OverlayStatistician;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.preferencesNew.DosePrefs;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.report.gui.content.common.filter.DvhDisplayInfoFilter;
import com.mimvista.report.gui.content.common.filter.SearchFieldFilter;
import com.mimvista.swing.DelayedActionRunner;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.cn;
import com.mimvista.viewer.ModalitySeriesInfo;
import com.mimvista.viewer.RTDoseSeriesInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DVHDisplayParams
implements Cloneable,
Iterable<DVHCollection> {
    private static final int DAR_DELAY = 100;
    private static final float EPSILON = 1.0E-6f;
    private DoseValue userDefinedMaxDose = null;
    private DoseValue userDefinedRxDose = null;
    private DoseNormType doseNormType = DoseNormType.ABSOLUTE;
    private boolean isNormalizedVolume = true;
    private boolean showGridLines = DosePrefs.dvhShowGridDefault.getValue();
    private boolean showLegend = false;
    private boolean useNamesForReporting = false;
    private DvhDisplayInfoFilter ddiFilter;
    private boolean reportMode = false;
    private BlackWhiteLookAndFeel lookAndFeel = new BlackWhiteLookAndFeel(MIMLookAndFeel.i(), MIMLookAndFeel.j());
    private final Map<DVHCollection, List<DvhDisplayInfo>> filteredDVHs;
    private boolean useDoseCap = true;
    private DoseValue userDefinedDoseCap = null;
    private final List<FuncUtils.m<DVHDisplayParams>> listeners = new ArrayList<FuncUtils.m<DVHDisplayParams>>();
    private String searchString = null;
    private boolean lockDoseLineStyles = false;
    private DelayedActionRunner updater = new DelayedActionRunner(100, new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList arrayList;
            List list = DVHDisplayParams.this.listeners;
            synchronized (list) {
                arrayList = new ArrayList(DVHDisplayParams.this.listeners);
            }
            for (FuncUtils.m m2 : arrayList) {
                m2.doIt(DVHDisplayParams.this);
            }
        }
    });

    public DVHDisplayParams() {
        this.filteredDVHs = new ConcurrentHashMap<DVHCollection, List<DvhDisplayInfo>>();
        this.initDDIFilter();
        this.setReportMode(false);
    }

    public DVHDisplayParams(DVHCollection dVHCollection, Float f2, Float f3) {
        this.filteredDVHs = new ConcurrentHashMap<DVHCollection, List<DvhDisplayInfo>>();
        this.filteredDVHs.put(dVHCollection, dVHCollection.getDvhDisplayInfo());
        if (f2 != null) {
            this.userDefinedMaxDose = new DoseValue();
            this.userDefinedMaxDose.setValueInGy(f2.floatValue());
        }
        if (f3 != null) {
            this.userDefinedRxDose = new DoseValue();
            this.userDefinedRxDose.setValueInGy(f3.floatValue());
        }
        this.initDDIFilter();
        this.setReportMode(false);
    }

    public DVHDisplayParams(Map<DVHCollection, List<DvhDisplayInfo>> map, DoseValue doseValue, DoseValue doseValue2) {
        this.filteredDVHs = map;
        this.userDefinedMaxDose = doseValue;
        this.userDefinedRxDose = doseValue2;
        this.initDDIFilter();
        this.setReportMode(false);
    }

    public DoseValue getMaxDose() {
        if (this.userDefinedMaxDose == null) {
            DoseValue doseValue = new DoseValue();
            doseValue.setValueInGy(this.calcMaxDose());
            return doseValue;
        }
        return this.userDefinedMaxDose;
    }

    public DoseValue getMaxVisibleDoseOrUserDefined() {
        if (this.userDefinedMaxDose == null) {
            DoseValue doseValue = new DoseValue();
            doseValue.setValueInGy(this.calcMaxVisibleDose());
            return doseValue;
        }
        return this.userDefinedMaxDose;
    }

    public boolean hasUserDefinedRxDose() {
        return this.userDefinedRxDose != null;
    }

    public DoseValue getRxDose() {
        if (this.userDefinedRxDose == null) {
            DoseValue doseValue = new DoseValue();
            doseValue.setValueInGy(this.calcMaxPrescriptionDose());
            return doseValue;
        }
        return this.userDefinedRxDose;
    }

    public DvhDisplayInfoFilter getDDIFilter() {
        return this.ddiFilter;
    }

    protected DVHDisplayParams clone() {
        try {
            return (DVHDisplayParams)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public int numberOfCollections() {
        return this.filteredDVHs.keySet().size();
    }

    public List<DVHCollection> getDVHCollections() {
        return Lists.newArrayList(this.filteredDVHs.keySet());
    }

    @Override
    public Iterator<DVHCollection> iterator() {
        return Iterables.unmodifiableIterable(this.filteredDVHs.keySet()).iterator();
    }

    void filterDVHsBasedOnSearch(String string) {
        this.searchString = string;
        this.updateFilteredDVHs();
    }

    private boolean DVHcontainsName(DoseVolumeHistogram doseVolumeHistogram, String string) {
        if (doseVolumeHistogram.getName().toLowerCase().contains(string)) {
            return true;
        }
        for (ReferencedRoi referencedRoi : doseVolumeHistogram.getRois()) {
            if (!referencedRoi.name.toLowerCase().contains(string)) continue;
            return true;
        }
        return false;
    }

    private void initDDIFilter() {
        this.ddiFilter = new DvhDisplayInfoFilter(new ArrayList<String>());
        this.ddiFilter.a(new SearchFieldFilter.a(){

            @Override
            public void filterChanged() {
                DVHDisplayParams.this.updateFilteredDVHs();
            }
        });
    }

    public void updateFilteredDVHs() {
        Object object;
        ArrayList arrayList = Lists.newArrayList();
        if (!cn.h(this.searchString)) {
            object = this.searchString.split(",");
            for (int i2 = 0; i2 < ((String[])object).length; ++i2) {
                if (cn.h(object[i2])) continue;
                arrayList.add(object[i2].toLowerCase().trim());
            }
        }
        object = Sets.newHashSet(this.ddiFilter.g());
        List list = this.ddiFilter.h();
        for (DVHCollection dVHCollection : this.filteredDVHs.keySet()) {
            ArrayList arrayList2 = Lists.newArrayList();
            block2: for (DvhDisplayInfo dvhDisplayInfo : dVHCollection.getDvhDisplayInfo()) {
                if (!object.contains(dvhDisplayInfo)) continue;
                if (arrayList.isEmpty()) {
                    arrayList2.add(dvhDisplayInfo);
                    if (!list.contains(dvhDisplayInfo)) continue;
                    dvhDisplayInfo.setVisible(true);
                    continue;
                }
                for (String string : arrayList) {
                    if (!this.DVHcontainsName(dvhDisplayInfo.getDVH(), string)) continue;
                    arrayList2.add(dvhDisplayInfo);
                    if (!list.contains(dvhDisplayInfo)) continue block2;
                    dvhDisplayInfo.setVisible(true);
                    continue block2;
                }
            }
            this.filteredDVHs.put(dVHCollection, arrayList2);
        }
        this.updateDDIFilter(false);
        this.fireZeListeners();
    }

    public Map<DVHCollection, List<DvhDisplayInfo>> getFilteredDVHs() {
        return this.filteredDVHs;
    }

    public void addDVHCollection(DVHCollection dVHCollection) {
        this.filteredDVHs.put(dVHCollection, dVHCollection.getDvhDisplayInfo());
        this.updateDDIFilter(false);
        this.fireZeListeners();
    }

    public void addDVHCollection(List<DVHCollection> list) {
        for (DVHCollection dVHCollection : list) {
            this.filteredDVHs.put(dVHCollection, dVHCollection.getDvhDisplayInfo());
        }
        this.updateDDIFilter(false);
        this.fireZeListeners();
    }

    public boolean isNormalizedVolume() {
        return this.isNormalizedVolume;
    }

    public void setNormalizedVolume(boolean bl2) {
        this.isNormalizedVolume = bl2;
        this.fireZeListeners();
    }

    public DoseNormType getDoseNormType() {
        return this.doseNormType;
    }

    public void setDoseNormType(DoseNormType doseNormType) {
        this.doseNormType = doseNormType;
        this.fireZeListeners();
    }

    public boolean isShowLegend() {
        return this.showLegend;
    }

    public void setShowLegend(boolean bl2) {
        this.showLegend = bl2;
    }

    public boolean isShowGridLines() {
        return this.showGridLines;
    }

    public void setShowGridLines(boolean bl2) {
        this.showGridLines = bl2;
    }

    public boolean isUseNamesForReporting() {
        return this.useNamesForReporting;
    }

    public void setUseNamesForReporting(boolean bl2) {
        this.useNamesForReporting = bl2;
    }

    public boolean isUseDoseCap() {
        return this.useDoseCap;
    }

    public void setUseDoseCap(boolean bl2) {
        if (bl2 ^ this.useDoseCap) {
            this.useDoseCap = bl2;
            this.fireZeListeners();
        }
    }

    public DoseValue getDoseCap() {
        if (this.userDefinedDoseCap == null) {
            DoseValue doseValue = new DoseValue();
            doseValue.setValueInGy(this.calcDefaultDoseCap().floatValue());
            return doseValue;
        }
        return this.userDefinedDoseCap;
    }

    public void setDoseCap(DoseValue doseValue) {
        if (doseValue == null || !MathUtils.a(doseValue.getValueInGy(), this.getDoseCap().getValueInGy(), 1.0E-6f)) {
            this.userDefinedDoseCap = doseValue;
            this.fireZeListeners();
        }
    }

    public void setMaxDose(DoseValue doseValue) {
        if (doseValue == null || !MathUtils.a(doseValue.getValueInGy(), this.getMaxDose().getValueInGy(), 1.0E-6f)) {
            this.userDefinedMaxDose = doseValue;
            this.fireZeListeners();
        }
    }

    public void setRxDose(DoseValue doseValue) {
        if (doseValue == null || !MathUtils.a(doseValue.getValueInGy(), this.getRxDose().getValueInGy(), 1.0E-6f)) {
            this.userDefinedRxDose = doseValue;
            this.fireZeListeners();
        }
    }

    public BlackWhiteLookAndFeel getLookAndFeel() {
        return this.lookAndFeel;
    }

    public void setReportMode(boolean bl2) {
        this.reportMode = bl2;
        if (this.reportMode) {
            this.lookAndFeel = new BlackWhiteLookAndFeel(DosePrefs.dvhReportGridColor.getValue(), DosePrefs.dvhReportBackground.getValue());
            return;
        }
        this.lookAndFeel = new BlackWhiteLookAndFeel(DosePrefs.dvhViewerGridColor.getValue(), DosePrefs.dvhViewerBackground.getValue());
    }

    public boolean getLockDoseLineStyles() {
        return this.lockDoseLineStyles;
    }

    public void setLockDoseLineStyles(boolean bl2) {
        this.lockDoseLineStyles = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(FuncUtils.m<DVHDisplayParams> m2) {
        List<FuncUtils.m<DVHDisplayParams>> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(m2)) {
                this.listeners.add(m2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(FuncUtils.m<DVHDisplayParams> m2) {
        List<FuncUtils.m<DVHDisplayParams>> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(m2);
        }
    }

    private float calcMaxPrescriptionDose() {
        float f2 = 0.0f;
        for (DVHCollection dVHCollection : this.filteredDVHs.keySet()) {
            ModalitySeriesInfo modalitySeriesInfo = dVHCollection.getDoseInfo().modInfo;
            if (modalitySeriesInfo == null || !(modalitySeriesInfo instanceof RTDoseSeriesInfo)) continue;
            RTDoseSeriesInfo rTDoseSeriesInfo = (RTDoseSeriesInfo)modalitySeriesInfo;
            if (rTDoseSeriesInfo.curDose == null) continue;
            f2 = Math.max(f2, rTDoseSeriesInfo.curDose.c().getValueInGy());
        }
        return f2;
    }

    private float calcMaxDose() {
        float f2 = -3.4028235E38f;
        for (DVHCollection dVHCollection : this.filteredDVHs.keySet()) {
            for (DoseVolumeHistogram doseVolumeHistogram : dVHCollection.getDVHs()) {
                if (!((double)f2 < doseVolumeHistogram.getMaxDose())) continue;
                f2 = (float)doseVolumeHistogram.getMaxDose();
            }
        }
        return f2;
    }

    private float calcMaxVisibleDose() {
        float f2 = -3.4028235E38f;
        for (DVHCollection dVHCollection : this.filteredDVHs.keySet()) {
            for (DvhDisplayInfo dvhDisplayInfo : dVHCollection.getDvhDisplayInfo()) {
                if (!dvhDisplayInfo.isVisible() || !((double)f2 < dvhDisplayInfo.getDVH().getMaxDose())) continue;
                f2 = (float)dvhDisplayInfo.getDVH().getMaxDose();
            }
        }
        return f2;
    }

    private Float calcDefaultDoseCap() {
        return Float.valueOf(this.getRxDose().getValueInGy() * DosePrefs.getDvhDoseCapAsProperRawPercent().floatValue());
    }

    public Float getRelativeDoseCap() {
        switch (this.doseNormType) {
            case ABSOLUTE: {
                return Float.valueOf(this.getDoseCap().getValueInCurrentUnit());
            }
            case PRESCRIPTION: {
                return Float.valueOf(this.getDoseCap().getValueInCurrentUnit() / this.getRxDose().getValueInCurrentUnit() * 100.0f);
            }
        }
        return Float.valueOf(105.0f);
    }

    private void fireZeListeners() {
        this.updater.b();
    }

    public void updateDDIFilter() {
        this.updateDDIFilter(true);
    }

    private void updateDDIFilter(boolean bl2) {
        ArrayList arrayList = Lists.newArrayList();
        for (DVHCollection dVHCollection : this.filteredDVHs.keySet()) {
            arrayList.addAll(dVHCollection.getDvhDisplayInfo());
        }
        this.ddiFilter.a(arrayList, bl2, new Predicate<DvhDisplayInfo>(){

            public boolean apply(DvhDisplayInfo dvhDisplayInfo) {
                return dvhDisplayInfo.isVisible();
            }
        });
    }

    public void updateDVHCollections(List<DVHCollection> list) {
        this.filteredDVHs.clear();
        for (DVHCollection dVHCollection : list) {
            this.filteredDVHs.put(dVHCollection, dVHCollection.getDvhDisplayInfo());
        }
        this.updateFilteredDVHs();
    }

    public void removeDVHCollections(List<DVHCollection> list) {
        for (DVHCollection dVHCollection : list) {
            this.filteredDVHs.remove(dVHCollection);
        }
        this.updateDDIFilter(false);
        this.fireZeListeners();
    }

    public void removeDVHCollection(DVHCollection dVHCollection) {
        this.filteredDVHs.remove(dVHCollection);
        this.updateDDIFilter(false);
        this.fireZeListeners();
    }

    public double normalizeDose(double d2, DoseVolumeHistogram doseVolumeHistogram) {
        DoseValue doseValue = new DoseValue((float)d2);
        d2 = doseValue.getValueInGy();
        double d3 = this.getDoseInGyForNormalizationUse(doseVolumeHistogram);
        if (d3 == 0.0) {
            return 0.0;
        }
        return d2 / d3 * 100.0;
    }

    public double unnormalizeDose(double d2, DoseVolumeHistogram doseVolumeHistogram) {
        DoseValue doseValue = new DoseValue();
        doseValue.setValueInGy((float)this.unnormalizeDoseInGy(d2, doseVolumeHistogram));
        return doseValue.getValueInCurrentUnit();
    }

    public double unnormalizeDoseInGy(double d2, DoseVolumeHistogram doseVolumeHistogram) {
        return d2 * this.getDoseInGyForNormalizationUse(doseVolumeHistogram) / 100.0;
    }

    public boolean isNormalizationDoseZero(DoseVolumeHistogram doseVolumeHistogram) {
        return this.getDoseNormType() != DoseNormType.ABSOLUTE && this.getDoseInGyForNormalizationUse(doseVolumeHistogram) <= (double)1.0E-6f;
    }

    public String getDescriptionHeaderForCSV() {
        switch (this.getDoseNormType()) {
            case PRESCRIPTION: {
                float f2 = this.getRxDose().getValueInGy();
                if (f2 > 0.0f) {
                    return String.format(Messages.a("DVH").b("DVH_DOSE_SCRIP_MAX"), Float.valueOf(f2));
                }
                return Messages.a("DVH").b("DVH_DOSE_SCRIP_CON_MAX");
            }
            case DOSEMAX: {
                return Messages.a("DVH").b("DVH_DOSE_PER_MAX") + "(" + String.format("%.2f", Float.valueOf(this.getMaxDose().getValueInGy())) + ")";
            }
            case CONTOURMAX: {
                return Messages.a("DVH").b("DVH_DOSE_PER_CON_MAX");
            }
        }
        return "";
    }

    public String getInfoDescForDVHInCSV(DoseVolumeHistogram doseVolumeHistogram) {
        boolean bl2 = this.getDoseNormType() == DoseNormType.CONTOURMAX || this.getDoseNormType() == DoseNormType.PRESCRIPTION && this.getRxDose().getValueInGy() <= 0.0f;
        boolean bl3 = this.isNormalizedVolume();
        String string = new String();
        if (bl3 && bl2) {
            string = String.format("(" + Messages.a("DVH", "DVH_MAX_DOSE") + ": %.2f, " + Messages.a("Contour", "VOLUME_FULL_STAT") + ": %.2f)", this.getDoseInGyForNormalizationUse(doseVolumeHistogram), doseVolumeHistogram.getMaxVolume());
        } else if (bl3) {
            string = String.format("(" + Messages.a("Contour", "VOLUME_FULL_STAT") + ": %.2f)", doseVolumeHistogram.getMaxVolume());
        } else if (bl2) {
            string = String.format("(" + Messages.a("DVH", "DVH_MAX_DOSE") + ": %.2f)", this.getDoseInGyForNormalizationUse(doseVolumeHistogram));
        }
        return string;
    }

    private double getDoseInGyForNormalizationUse(DoseVolumeHistogram doseVolumeHistogram) {
        switch (this.getDoseNormType()) {
            case PRESCRIPTION: {
                float f2 = this.getRxDose().getValueInGy();
                if (f2 > 0.0f) {
                    return f2;
                }
                return doseVolumeHistogram.getMaxDose();
            }
            case DOSEMAX: {
                return this.getMaxDose().getValueInGy();
            }
            case CONTOURMAX: {
                return doseVolumeHistogram.getMaxDose();
            }
        }
        return 0.0;
    }

    public String getXAxisUnits() {
        float f2;
        String string = this.getDoseNormType() == DoseNormType.DOSEMAX ? Messages.a("DVH").getProperty("DVH_DOSE_PER_MAX") : (this.getDoseNormType() == DoseNormType.CONTOURMAX ? Messages.a("DVH").getProperty("DVH_DOSE_PER_CON_MAX") : (this.getDoseNormType() == DoseNormType.PRESCRIPTION ? ((f2 = this.getRxDose().getValueInCurrentUnit()) > 0.0f ? String.format(Messages.a("DVH").b("DVH_DOSE_SCRIP_MAX") + " " + DoseValue.doseUnit.name(), Float.valueOf(f2)) : Messages.a("DVH").getProperty("DVH_DOSE_SCRIP_CON_MAX")) : DoseValue.doseUnit.name()));
        return string;
    }

    public String getYAxisUnits() {
        String string = this.isNormalizedVolume() ? Messages.a("DVH").b("DVH_PER_COV") : MIMFormat.a(Messages.a("DVH").b("DVH_UNIT_CM3"), OverlayStatistician.t());
        return string;
    }

    public boolean contains(DvhDisplayInfo dvhDisplayInfo) {
        for (List<DvhDisplayInfo> list : this.filteredDVHs.values()) {
            for (DvhDisplayInfo dvhDisplayInfo2 : list) {
                if (dvhDisplayInfo2 != dvhDisplayInfo) continue;
                return true;
            }
        }
        return false;
    }

    public void showAll() {
        for (List<DvhDisplayInfo> list : this.getFilteredDVHs().values()) {
            for (DvhDisplayInfo dvhDisplayInfo : list) {
                dvhDisplayInfo.setVisible(true);
            }
        }
        this.ddiFilter.k();
    }

    public void hideAll() {
        for (List<DvhDisplayInfo> list : this.getFilteredDVHs().values()) {
            for (DvhDisplayInfo dvhDisplayInfo : list) {
                dvhDisplayInfo.setVisible(false);
            }
        }
        this.ddiFilter.j();
    }

    public void showAll(DVHCollection dVHCollection) {
        for (DvhDisplayInfo dvhDisplayInfo : dVHCollection.getDvhDisplayInfo()) {
            dvhDisplayInfo.setVisible(true);
            this.ddiFilter.b(dvhDisplayInfo);
        }
    }

    public void hideAll(DVHCollection dVHCollection) {
        for (DvhDisplayInfo dvhDisplayInfo : dVHCollection.getDvhDisplayInfo()) {
            dvhDisplayInfo.setVisible(false);
            this.ddiFilter.c(dvhDisplayInfo);
        }
    }

    public void selectDVH(DvhDisplayInfo dvhDisplayInfo) {
        for (DVHCollection dVHCollection : this) {
            for (DvhDisplayInfo dvhDisplayInfo2 : dVHCollection.getDvhDisplayInfo()) {
                if (dvhDisplayInfo == dvhDisplayInfo2) {
                    dvhDisplayInfo2.setSelected(true);
                    continue;
                }
                dvhDisplayInfo2.setSelected(false);
            }
        }
    }
}

