/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.google.common.collect.Lists;
import com.mimvista.dicom.rtdose.DVHCollection;
import com.mimvista.dicom.rtdose.gui.DVHDisplayParams;
import com.mimvista.dicom.rtdose.gui.DvhDisplayInfo;
import com.mimvista.dicom.rtdose.gui.DvhLineStyle;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public interface DVHDisplayState {
    public boolean isInDvhViewer();

    public DVHDisplayParams getDVHParams();

    public void selectDVH(DvhDisplayInfo var1);

    public void updateColor(DvhDisplayInfo var1, Color var2);

    public void updateStroke(DvhDisplayInfo var1, DvhLineStyle var2);

    public boolean getLockDoseLineStyles();

    public void setVisible(DvhDisplayInfo var1, boolean var2);

    public void unselectDVH(DvhDisplayInfo var1);

    public void showAll();

    public void hideAll();

    public void refreshUI();

    default public List<DVHCollection> getSortedDvhCollections() {
        ArrayList arrayList = Lists.newArrayList(this.getDVHParams().getFilteredDVHs().keySet());
        Collections.sort(arrayList, DVHCollection.getDVHComparator());
        return arrayList;
    }

    default public DVHCollection getSelectedCollection() {
        List<DVHCollection> list = this.getSortedDvhCollections();
        DVHCollection dVHCollection = list.isEmpty() ? null : list.get(0);
        for (DVHCollection dVHCollection2 : list) {
            for (DvhDisplayInfo dvhDisplayInfo : this.getDVHParams().getFilteredDVHs().get(dVHCollection2)) {
                if (!dvhDisplayInfo.isSelected()) continue;
                return dVHCollection2;
            }
        }
        for (DVHCollection dVHCollection2 : list) {
            for (DvhDisplayInfo dvhDisplayInfo : dVHCollection2.getDvhDisplayInfo()) {
                if (!dvhDisplayInfo.isSelected()) continue;
                return dVHCollection2;
            }
        }
        return dVHCollection;
    }

    public void updateLockDoseLineStyles(boolean var1);

    public static void updateLockDoseLineStyles(boolean bl2, DVHDisplayParams dVHDisplayParams) {
        dVHDisplayParams.setLockDoseLineStyles(bl2);
        if (bl2) {
            ArrayList<DvhLineStyle> arrayList = new ArrayList<DvhLineStyle>(Arrays.asList(DvhLineStyle.values()));
            for (Map.Entry<DVHCollection, List<DvhDisplayInfo>> entry : dVHDisplayParams.getFilteredDVHs().entrySet()) {
                DvhLineStyle dvhLineStyle;
                if (arrayList.isEmpty()) {
                    arrayList.addAll(Arrays.asList(DvhLineStyle.values()));
                }
                if (!arrayList.contains(dvhLineStyle = entry.getKey().getLineStyle())) {
                    dvhLineStyle = (DvhLineStyle)arrayList.get(0);
                    entry.getKey().setLineStyle(dvhLineStyle);
                }
                arrayList.remove(dvhLineStyle);
                for (DvhDisplayInfo dvhDisplayInfo : entry.getValue()) {
                    dvhDisplayInfo.setLineStyle(dvhLineStyle);
                    DVHDisplayState.syncLineColors(dvhDisplayInfo, dVHDisplayParams);
                }
            }
        }
    }

    public static void syncLineColors(DvhDisplayInfo dvhDisplayInfo, DVHDisplayParams dVHDisplayParams) {
        block0: for (List<DvhDisplayInfo> list : dVHDisplayParams.getFilteredDVHs().values()) {
            for (DvhDisplayInfo dvhDisplayInfo2 : list) {
                if (!dvhDisplayInfo2.getName().equals(dvhDisplayInfo.getName())) continue;
                if (dvhDisplayInfo2.getColor().equals(dvhDisplayInfo.getColor())) continue block0;
                dvhDisplayInfo2.setColor(dvhDisplayInfo.getColor(), true);
                continue block0;
            }
        }
    }
}

