/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.google.common.collect.Lists;
import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.archive.gui.SendToDestinationUIFactory;
import com.mimvista.dicom.rtdose.DVHCollection;
import com.mimvista.dicom.rtdose.DoseValue;
import com.mimvista.dicom.rtdose.gui.DVHDisplay;
import com.mimvista.dicom.rtdose.gui.DVHDisplayParams;
import com.mimvista.dicom.rtdose.gui.DvhDisplayUpdateHandler;
import com.mimvista.dicom.rtdose.gui.constraint.DoseStatisticsPage;
import com.mimvista.dicom.write.DcmSecondaryCaptureWriter;
import com.mimvista.dose.constraints.DoseConstraintSet;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.statistics.IsodoseStatistician;
import com.mimvista.mui.Session;
import com.mimvista.mui.SessionKey;
import com.mimvista.mui.SessionableWindows;
import com.mimvista.mui.captures.Capture;
import com.mimvista.mui.captures.CaptureStorage;
import com.mimvista.mui.overlays.IsodoseOverlay;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.response.gui.TherapyResponseWindow;
import com.mimvista.swing.widgets.popup.JPopupContent;
import com.mimvista.util.Messages;
import com.mimvista.viewer.RTDoseSeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.viewer.f;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class DVHFrame
extends SessionableWindows.MIMSessionableJFrame {
    private static final long serialVersionUID = 1L;
    static Messages props = Messages.a("DVH");
    public static Map<Session, DVHFrame> DVHFrameMap = new HashMap<Session, DVHFrame>();
    private DVHDisplay dvhDisp;
    private DoseStatisticsPage statsPage;
    private SessionKey s;
    private DVHDisplayParams params;

    public static synchronized DVHFrame getCurrentFrameForSession(Session session) {
        return DVHFrameMap.get(session);
    }

    public static synchronized void setDVHFrameForSession(Session session, DVHFrame dVHFrame) {
        DVHFrameMap.put(session, dVHFrame);
    }

    public static synchronized void deregisterDVHFrame(DVHFrame dVHFrame) {
        ArrayList arrayList = Lists.newArrayList();
        for (Map.Entry<Session, DVHFrame> entry : DVHFrameMap.entrySet()) {
            if (entry.getValue() != dVHFrame) continue;
            arrayList.add(entry.getKey());
        }
        DvhDisplayUpdateHandler dvhDisplayUpdateHandler = dVHFrame.getDisplay().getDvhUpdateListener();
        for (Session session : arrayList) {
            for (ViewController viewController : session.af()) {
                for (IsodoseOverlay isodoseOverlay : viewController.ba().L()) {
                    IsodoseStatistician isodoseStatistician = isodoseOverlay.h();
                    isodoseStatistician.b(dvhDisplayUpdateHandler);
                    isodoseStatistician.a((Object)dvhDisplayUpdateHandler);
                }
            }
            DVHFrameMap.remove(session);
        }
    }

    public DVHDisplay getDisplay() {
        return this.dvhDisp;
    }

    public DVHFrame(Session session, DVHCollection dVHCollection) {
        super(props.b("DVH_TITLE"));
        this.params = new DVHDisplayParams();
        this.params.addDVHCollection(dVHCollection);
        this.setup(session);
    }

    public DVHFrame(Session session, DVHDisplayParams dVHDisplayParams) {
        super(props.b("DVH_TITLE"));
        this.params = dVHDisplayParams;
        this.setup(session);
    }

    private void setup(Session session) {
        this.s = session.H();
        DVHFrame.setDVHFrameForSession(session, this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                DVHFrame.deregisterDVHFrame(DVHFrame.this);
            }
        });
        this.buildWindow();
        this.setDefaultCloseOperation(2);
        SessionableWindows.a(session, this);
    }

    public List<DVHCollection> getCollections() {
        return this.params.getDVHCollections();
    }

    @Override
    public void dispose() {
        this.dvhDisp.finish();
        if (this.statsPage != null) {
            this.statsPage.cleanup();
        }
        MIMSwingUtils.b(new Runnable(){

            @Override
            public void run() {
                DVHFrame.this.setVisible(false);
            }
        });
        super.dispose();
    }

    private void buildWindow() {
        this.setIconImage(ImageManipulator.d("dvh", 64, 64));
        this.setMinimumSize(new Dimension(600, 400));
        this.getContentPane().setLayout(new BorderLayout());
        this.setTitle(props.b("DVH_TITLE"));
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.add((Component)jTabbedPane, "Center");
        JPanel jPanel = this.buildDVHTab();
        jTabbedPane.addTab(Messages.a("GeneralPreferencesCollectionFactory", "GENERALPREF_DVH_TITLE"), jPanel);
        JPanel jPanel2 = this.buildStatsTab();
        jTabbedPane.addTab(Messages.a("Contour", "STATISTICS"), jPanel2);
        MIMSwingUtils.b(new Runnable(){

            @Override
            public void run() {
                DVHFrame.this.setVisible(true);
            }
        });
    }

    private JPanel buildStatsTab() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JButton jButton = new JButton();
        jButton.setText(props.b("DVH_VIEWER_DONE"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DVHFrame.this.dispose();
            }
        });
        jPanel2.add((Component)jButton, "East");
        jPanel.add((Component)jPanel2, "South");
        this.statsPage = new DoseStatisticsPage(this.s.b());
        List<DVHCollection> list = this.params.getDVHCollections();
        if (list != null && !list.isEmpty()) {
            this.statsPage.setSelectdDoseFromDoseVol(list.get(0).getDoseVolume());
        }
        jPanel.add((Component)this.statsPage, "Center");
        this.params.addListener(new FuncUtils.m<DVHDisplayParams>(){
            private DoseValue dv = null;

            @Override
            public void doIt(DVHDisplayParams dVHDisplayParams) {
                if (!dVHDisplayParams.getDVHCollections().isEmpty() && !DVHFrame.this.params.getRxDose().equals(this.dv)) {
                    this.dv = DVHFrame.this.params.getRxDose();
                    IsodoseOverlay isodoseOverlay = DVHFrame.this.statsPage.getSelectedDose();
                    if (isodoseOverlay != null && !this.dv.equals(isodoseOverlay.getRxDose())) {
                        isodoseOverlay.a(new RTDoseSeriesInfo.RxDose(this.dv, RTDoseSeriesInfo.RxType.USER));
                    }
                }
            }
        });
        return jPanel;
    }

    private JPanel buildDVHTab() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.dvhDisp = new DVHDisplay(this.params, null, this);
        this.params.addListener(new FuncUtils.m<DVHDisplayParams>(){

            @Override
            public void doIt(DVHDisplayParams dVHDisplayParams) {
                if (dVHDisplayParams.getDVHCollections().isEmpty()) {
                    DVHFrame.this.dispose();
                }
            }
        });
        jPanel.add((Component)this.dvhDisp, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JButton jButton = new JButton();
        jButton.setText(props.b("DVH_VIEWER_DONE"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DVHFrame.this.dispose();
            }
        });
        jPanel2.add((Component)jButton, "East");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        final JButton jButton2 = new JButton();
        jButton2.setText(props.b("DVH_OUTPUT_SAVE"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenuItem jMenuItem = new JMenuItem(props.b("DVH_OUTPUT_CSV"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DVHFrame.this.dvhDisp.outputCSVDoses();
                            }
                        });
                    }
                });
                jPopupMenu.add(jMenuItem);
                JMenu jMenu = null;
                HashSet<SeriesInfo> hashSet = new HashSet<SeriesInfo>();
                for (DVHCollection dVHCollection : DVHFrame.this.dvhDisp) {
                    hashSet.add(dVHCollection.getDoseInfo());
                }
                if (hashSet.size() > 1) {
                    jMenu = new JMenu();
                    for (DVHCollection dVHCollection : DVHFrame.this.dvhDisp) {
                        SeriesInfo seriesInfo = dVHCollection.getDoseInfo();
                        if (!hashSet.contains(seriesInfo)) continue;
                        hashSet.remove(seriesInfo);
                        JMenu jMenu2 = DVHFrame.this.createCaptureMenu(dVHCollection);
                        jMenu2.setText(f.f(dVHCollection.getAnonDoseInfoIfNeeded()));
                        jMenu.add(jMenu2);
                    }
                } else {
                    jMenu = DVHFrame.this.createCaptureMenu(DVHFrame.this.dvhDisp.iterator().next());
                }
                jMenu.setText(TherapyResponseWindow.a.getProperty("SECONDARY_CAPTURE"));
                jPopupMenu.add(jMenu);
                JMenuItem jMenuItem2 = new JMenuItem(Messages.a("mui", "CAPTURE_GALLERY"));
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MIMSwingUtils.a(new Runnable(){

                            @Override
                            public void run() {
                                CaptureStorage.a(DVHFrame.this.s.b(), DVHFrame.this.dvhDisp.makeCapture());
                            }
                        });
                    }
                });
                jPopupMenu.add(jMenuItem2);
                jPopupMenu.show(jButton2, jButton2.getWidth() / 2 - jPopupMenu.getWidth() / 2, jButton2.getHeight());
            }
        });
        JButton jButton3 = new JButton();
        jButton3.setText(Messages.a("mui").b("MIMMAIN_PRINT"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DVHFrame.this.dvhDisp.printDVH();
            }
        });
        JButton jButton4 = new JButton();
        jButton4.setText(props.b("DVH_ANNOTATE_ADD") + "...");
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DVHFrame.this.dvhDisp.showAnnotationDialog();
            }
        });
        JButton jButton5 = new JButton();
        jButton5.setText(props.b("DVH_CLEAR_ANNOTATIONS"));
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DVHFrame.this.dvhDisp.clearSpecialNotes();
            }
        });
        final JButton jButton6 = new JButton();
        jButton6.setText(props.b("DVH_LOAD_ANNOTATIONS"));
        jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Collection<DoseConstraintSet> collection = DoseConstraintSet.getUserPreferencedPersonas();
                JPopupContent jPopupContent = new JPopupContent();
                for (final DoseConstraintSet doseConstraintSet : collection) {
                    JMenuItem jMenuItem = new JMenuItem(doseConstraintSet.getName());
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            DVHFrame.this.dvhDisp.loadAnnotationsFromConstraints(doseConstraintSet);
                        }
                    });
                    jPopupContent.add(jMenuItem);
                }
                jPopupContent.show(jButton6, 0, 0);
            }
        });
        Dimension dimension = new Dimension(3, 0);
        jPanel3.add(jButton2);
        jPanel3.add(Box.createRigidArea(dimension));
        jPanel3.add(jButton3);
        jPanel3.add(Box.createRigidArea(dimension));
        jPanel3.add(jButton4);
        jPanel3.add(Box.createRigidArea(dimension));
        jPanel3.add(jButton6);
        jPanel3.add(Box.createRigidArea(dimension));
        jPanel3.add(jButton5);
        jPanel2.add((Component)jPanel3, "West");
        jPanel.add((Component)jPanel2, "South");
        jPanel2.setMinimumSize(new Dimension(0, 100));
        return jPanel;
    }

    public JMenu createCaptureMenu(final DVHCollection dVHCollection) {
        return SendToDestinationUIFactory.a(new SendToDestinationUIFactory.a(){

            @Override
            public void destinationSelected(SendToDestination sendToDestination) {
                Capture capture = DVHFrame.this.dvhDisp.makeCapture();
                DcmSecondaryCaptureWriter dcmSecondaryCaptureWriter = new DcmSecondaryCaptureWriter(Lists.newArrayList((Object[])new BufferedImage[]{capture.e()}), dVHCollection.getViewController(), sendToDestination, dVHCollection.getDoseInfo(), false);
                dcmSecondaryCaptureWriter.writeFiles();
            }
        });
    }

    public void addDVH(DVHCollection dVHCollection) {
        this.params.addDVHCollection(dVHCollection);
    }

    public void addDVHs(List<DVHCollection> list) {
        this.params.addDVHCollection(list);
    }

    public void refresh() {
        MIMSwingUtils.a(new Runnable(){

            @Override
            public void run() {
                DVHFrame.this.dvhDisp.refreshUI();
                DVHFrame.this.statsPage.refresh();
            }
        });
    }

    @Override
    public void onSessionActivated(Session session) {
        DVHFrame dVHFrame = DVHFrameMap.get(session);
        if (dVHFrame != null) {
            dVHFrame.refresh();
        }
    }

    @Override
    public void onSessionRemoved(Session session) {
        DVHFrameMap.remove(session);
    }
}

