/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.google.common.collect.Lists;
import com.mimvista.dicom.rtdose.DoseValue;
import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.dicom.rtdose.gui.DVHChartPanel;
import com.mimvista.dicom.rtdose.gui.DVHCurrentLocation;
import com.mimvista.dicom.rtdose.gui.DVHDisplayParams;
import com.mimvista.dicom.rtdose.gui.DVHFrame;
import com.mimvista.internals.statistics.OverlayStatistician;
import com.mimvista.numerics.MathUtils;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.NumberFormatFactory;
import java.awt.Point;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class DVHHoverComparisonNote
extends DVHCurrentLocation {
    private final String normDoseNormVol = "{0} ({1}), {2} ({3})";
    private final String normDoseUnnormedVol = "{0} ({1}), {2}";
    private final String unnormedDoseUnnormedVol = "{0}, {2}";
    private final String unnormedDoseNormVol = "{0}, {2} ({3})";
    private double referenceXVal;
    private double referenceYVal;
    private DoseVolumeHistogram referenceDVH;
    private boolean isNormalizedDose;
    private boolean isNormalizedVol;
    private String activeName;
    private String referenceName;

    public DVHHoverComparisonNote(DVHChartPanel dVHChartPanel, Point point, double d2, double d3, DoseVolumeHistogram doseVolumeHistogram) {
        super(dVHChartPanel, point, d2, d3, doseVolumeHistogram);
    }

    @Override
    public List<String> getNoteText(DVHDisplayParams dVHDisplayParams) {
        String string;
        this.isNormalizedDose = dVHDisplayParams.getDoseNormType().isNormalized();
        this.isNormalizedVol = dVHDisplayParams.isNormalizedVolume();
        ArrayList arrayList = Lists.newArrayList();
        String string2 = this.pickFormatString(dVHDisplayParams);
        double d2 = this.getDoseInCurrentUnit();
        double d3 = this.getVolumeInCC();
        double d4 = this.getNormalizedDose();
        double d5 = this.getNormalizedVolume();
        this.activeName = DVHFrame.props.getProperty("DVH_ACTIVE");
        String string3 = DoseValue.doseUnit.name();
        String string4 = OverlayStatistician.t();
        NumberFormat numberFormat = NumberFormatFactory.a();
        String string5 = this.activeName + ":\t" + MIMFormat.a(string2, numberFormat.format(d2) + string3, numberFormat.format(d4) + "%", numberFormat.format(d3) + string4, numberFormat.format(d5) + "%");
        arrayList.add(string5);
        double d6 = this.getGrayTypeDose(this.referenceXVal, this.referenceDVH);
        double d7 = this.getVolInCC(this.referenceYVal, this.referenceDVH);
        double d8 = this.referenceXVal;
        double d9 = this.referenceYVal;
        this.referenceName = DVHFrame.props.getProperty("DVH_REFERENCE");
        String string6 = this.referenceName + ":\t" + MIMFormat.a(string2, numberFormat.format(d6) + string3, numberFormat.format(d8) + "%", numberFormat.format(d7) + string4, numberFormat.format(d9) + "%");
        arrayList.add(string6);
        String string7 = this.makeComparisonEntry(d2, d6, string3);
        if (string7 != null) {
            if (this.isNormalizedDose && !MathUtils.b(d4, d8, 0.01)) {
                string7 = string7 + "(" + numberFormat.format(Math.abs(d4 - d8)) + "%)";
            }
            arrayList.add(string7);
        }
        if ((string = this.makeComparisonEntry(d3, d7, string4)) != null) {
            if (this.isNormalizedVol && !MathUtils.b(d5, d9, 0.01)) {
                string = string + "(" + numberFormat.format(Math.abs(d5 - d9)) + "%)";
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    private String makeComparisonEntry(double d2, double d3, String string) {
        if (MathUtils.b(d2, d3, 0.1)) {
            return null;
        }
        String string2 = d2 > d3 ? this.activeName + " - " + this.referenceName : this.referenceName + " - " + this.activeName;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(":");
        stringBuilder.append(NumberFormatFactory.a().format(Math.abs(d2 - d3)));
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private String pickFormatString(DVHDisplayParams dVHDisplayParams) {
        String string = "{0}, {2}";
        if (this.isNormalizedDose && this.isNormalizedVol) {
            string = "{0} ({1}), {2} ({3})";
        } else if (this.isNormalizedDose && !this.isNormalizedVol) {
            string = "{0} ({1}), {2}";
        } else if (!this.isNormalizedDose && this.isNormalizedVol) {
            string = "{0}, {2} ({3})";
        }
        return string;
    }

    public void setReferenceDVH(DoseVolumeHistogram doseVolumeHistogram, double d2, double d3) {
        this.referenceDVH = doseVolumeHistogram;
        this.referenceXVal = d2;
        this.referenceYVal = d3;
    }
}

