/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.mimvista.dicom.rtdose.gui.DvhLineStyle;
import com.mimvista.dicom.rtdose.gui.controls.style.DvhColorAndStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class DVHLineStyleRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 1L;
    private DvhColorAndStyle colorAndStyle = new DvhColorAndStyle();

    public DVHLineStyleRenderer() {
    }

    public DVHLineStyleRenderer(Color color) {
        this();
        this.colorAndStyle.setColor(color);
    }

    public void setColorAndStyle(DvhColorAndStyle dvhColorAndStyle) {
        this.colorAndStyle = dvhColorAndStyle;
    }

    @Override
    public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
        super.getListCellRendererComponent((JList<?>)jList, object, n2, bl2, bl3);
        this.setText(null);
        if (object instanceof DvhLineStyle) {
            this.colorAndStyle.setStyle((DvhLineStyle)object);
        } else if (object instanceof DvhColorAndStyle) {
            this.colorAndStyle = (DvhColorAndStyle)object;
        }
        return this;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(128, 16);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.colorAndStyle == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = this.colorAndStyle.getColor();
        if (color != null) {
            graphics2D.setColor(color);
        } else {
            graphics2D.setColor(Color.GRAY);
        }
        DvhLineStyle dvhLineStyle = this.colorAndStyle.getStyle();
        if (dvhLineStyle != null) {
            graphics2D.setStroke(dvhLineStyle.getStroke());
            graphics2D.drawLine(0, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2);
        }
        graphics2D.dispose();
    }

    public Color getColor() {
        return this.colorAndStyle.getColor();
    }
}

