/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.google.common.collect.Lists;
import com.mimvista.dicom.rtdose.DoseValue;
import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.dicom.rtdose.gui.DVHDisplayParams;
import com.mimvista.dicom.rtdose.gui.DVHFrame;
import com.mimvista.dicom.rtdose.gui.DoseNormType;
import com.mimvista.internals.statistics.OverlayStatistician;
import java.util.ArrayList;
import java.util.List;

public interface DVHNote {
    public double getDoseInCurrentUnit();

    public double getNormalizedDose();

    public double getVolumeInCC();

    public double getNormalizedVolume();

    public String getStructureName();

    public DoseVolumeHistogram getParentCurve();

    default public int getMaxIntegerPlaces(DVHDisplayParams dVHDisplayParams) {
        DoseNormType doseNormType;
        double d2 = Math.max(this.getDoseInCurrentUnit(), this.getVolumeInCC());
        if (dVHDisplayParams.isNormalizedVolume()) {
            d2 = Math.max(d2, this.getNormalizedVolume());
        }
        if ((doseNormType = dVHDisplayParams.getDoseNormType()) != null && doseNormType.isNormalized()) {
            d2 = Math.max(d2, this.getNormalizedDose());
        }
        return Double.toString(d2).indexOf(46);
    }

    default public List<String> getNoteText(DVHDisplayParams dVHDisplayParams) {
        DVHNote dVHNote = this;
        ArrayList arrayList = Lists.newArrayList();
        int n2 = 3 + this.getMaxIntegerPlaces(dVHDisplayParams);
        arrayList.add(dVHNote.getStructureName());
        if (dVHDisplayParams.isNormalizedVolume()) {
            arrayList.addAll(DVHNote.getNormalizedVolumeText(dVHNote, n2));
        } else {
            arrayList.add(DVHNote.getVolumeText(dVHNote, n2));
        }
        DoseNormType doseNormType = dVHDisplayParams.getDoseNormType();
        if (doseNormType != null && doseNormType.isNormalized()) {
            arrayList.addAll(DVHNote.getNormalizedDoseText(dVHNote, n2));
        } else {
            arrayList.add(DVHNote.getDoseText(dVHNote, n2));
        }
        return arrayList;
    }

    public static String formatFirstLine(String string, double d2, int n2, String string2) {
        return String.format(string + ": %" + n2 + ".2f %s", d2, string2);
    }

    public static String formatSecondLine(double d2, int n2, String string) {
        return String.format("   %" + n2 + ".2f %s", d2, string);
    }

    public static List<String> getNormalizedVolumeText(DVHNote dVHNote, int n2) {
        double d2 = dVHNote.getNormalizedVolume();
        double d3 = dVHNote.getVolumeInCC();
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add(DVHNote.formatFirstLine(DVHFrame.props.b("DVH_VOL_LABEL"), d2, n2, "%"));
        arrayList.add(DVHNote.formatSecondLine(d3, n2, OverlayStatistician.t()));
        return arrayList;
    }

    public static String getVolumeText(DVHNote dVHNote, int n2) {
        double d2 = dVHNote.getVolumeInCC();
        return DVHNote.formatFirstLine(DVHFrame.props.b("DVH_VOL_LABEL"), d2, n2, OverlayStatistician.t());
    }

    public static List<String> getNormalizedDoseText(DVHNote dVHNote, int n2) {
        double d2 = dVHNote.getNormalizedDose();
        double d3 = dVHNote.getDoseInCurrentUnit();
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add(DVHNote.formatFirstLine(DVHFrame.props.b("DVH_DOSE_LABEL"), d2, n2, "%"));
        arrayList.add(DVHNote.formatSecondLine(d3, n2, DoseValue.doseUnit.name()));
        return arrayList;
    }

    public static String getDoseText(DVHNote dVHNote, int n2) {
        double d2 = dVHNote.getDoseInCurrentUnit();
        return DVHNote.formatFirstLine(DVHFrame.props.b("DVH_DOSE_LABEL"), d2, n2, DoseValue.doseUnit.name());
    }
}

