/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.mimvista.dicom.rtdose.gui.DVHAnnotation;
import com.mimvista.dicom.rtdose.gui.DVHChartPanel;
import com.mimvista.dicom.rtdose.gui.DVHNote;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.ui.RectangleEdge;

public class DVHNoteDisplay {
    DVHNote note;
    DVHChartPanel chartpanel;
    boolean pinned = false;
    double pinX;
    double pinY;

    public DVHNoteDisplay(DVHNote dVHNote, DVHChartPanel dVHChartPanel) {
        this.note = dVHNote;
        this.chartpanel = dVHChartPanel;
    }

    public DVHNote getNote() {
        return this.note;
    }

    public boolean isVisible() {
        if (this.getNote() instanceof DVHAnnotation) {
            return ((DVHAnnotation)this.getNote()).ddi.isVisible();
        }
        return true;
    }

    public Point2D getCurvePosition() {
        int n2;
        int n3;
        double d2;
        ValueAxis valueAxis = this.chartpanel.getChart().getXYPlot().getDomainAxis();
        ValueAxis valueAxis2 = this.chartpanel.getChart().getXYPlot().getRangeAxis();
        Rectangle2D rectangle2D = this.chartpanel.getChartRenderingInfo().getPlotInfo().getDataArea();
        if (this.chartpanel.getChartWrapper().getParams().getDoseNormType().isNormalized()) {
            d2 = this.chartpanel.getChartWrapper().getParams().normalizeDose(this.note.getDoseInCurrentUnit(), this.note.getParentCurve());
            n3 = (int)Math.round(valueAxis.valueToJava2D(d2, rectangle2D, RectangleEdge.BOTTOM));
        } else {
            n3 = (int)Math.round(valueAxis.valueToJava2D(this.note.getDoseInCurrentUnit(), rectangle2D, RectangleEdge.BOTTOM));
        }
        if (this.chartpanel.getChartWrapper().getParams().isNormalizedVolume()) {
            d2 = DVHChartPanel.normalizeVolume(this.note.getVolumeInCC(), this.note.getParentCurve());
            n2 = (int)valueAxis2.valueToJava2D(d2, rectangle2D, RectangleEdge.LEFT);
        } else {
            n2 = (int)valueAxis2.valueToJava2D(this.note.getVolumeInCC(), rectangle2D, RectangleEdge.LEFT);
        }
        return new Point(n3, n2);
    }

    public Point2D getNominalPosition() {
        if (this.pinned) {
            Rectangle2D rectangle2D = this.chartpanel.getChartRenderingInfo().getPlotInfo().getDataArea().getBounds2D();
            return new Point((int)(this.pinX * rectangle2D.getWidth()), (int)(this.pinY * rectangle2D.getHeight()));
        }
        return this.getCurvePosition();
    }

    public void setUnpinned() {
        this.pinned = false;
    }

    public void setPinnedPosition(Point2D point2D) {
        Rectangle2D rectangle2D = this.chartpanel.getChartRenderingInfo().getPlotInfo().getDataArea().getBounds2D();
        this.pinX = point2D.getX() / rectangle2D.getWidth();
        this.pinY = point2D.getY() / rectangle2D.getHeight();
        this.pinned = true;
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public int getWidth(Graphics2D graphics2D) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n2 = 0;
        List<String> list = this.getText();
        for (String string : list) {
            int n3 = fontMetrics.stringWidth(string);
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public int getHeight(Graphics2D graphics2D) {
        return this.getText().size() * graphics2D.getFontMetrics().getHeight();
    }

    public List<String> getText() {
        return this.note.getNoteText(this.chartpanel.getChartWrapper().getParams());
    }

    private Rectangle drawNoteText(Graphics2D graphics2D, Point point) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n2 = point.x;
        int n3 = point.y;
        List<String> list = this.getText();
        int n4 = fontMetrics.getHeight();
        int n5 = n4 * list.size();
        int n6 = this.getWidth(graphics2D);
        Rectangle2D rectangle2D = this.chartpanel.getChartRenderingInfo().getPlotInfo().getDataArea().getBounds2D();
        Point2D.Double double_ = new Point2D.Double(rectangle2D.getX(), rectangle2D.getY());
        Point point2 = this.chartpanel.translateJava2DToScreen(double_);
        Point2D.Double double_2 = new Point2D.Double(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight());
        Point point3 = this.chartpanel.translateJava2DToScreen(double_2);
        if (point.x + n6 + 3 > point3.x) {
            n3 = point.y - n5 - 3 < point2.y ? (n3 += n5 + 3) : (n3 -= 3);
            n2 -= n6 + 3;
        } else if (point.y - n5 - 3 < point2.y) {
            n3 += n5 + 3;
            n2 = point.x - n6 - 3 > point2.x ? (n2 -= n6 + 3) : (n2 += 13);
        } else {
            n3 -= 3;
            n2 += 3;
        }
        int n7 = Integer.MAX_VALUE;
        int n8 = Integer.MIN_VALUE;
        int n9 = Integer.MAX_VALUE;
        int n10 = Integer.MIN_VALUE;
        int n11 = -(list.size() - 1) * n4;
        for (String string : list) {
            int n12 = n3 + n11;
            graphics2D.drawString(string, n2, n12);
            n11 += n4;
            Rectangle2D rectangle2D2 = fontMetrics.getStringBounds(string, graphics2D);
            if (n2 < n7) {
                n7 = n2;
            }
            if ((double)n2 + rectangle2D2.getWidth() > (double)n8) {
                n8 = (int)((double)n2 + rectangle2D2.getWidth());
            }
            if (n12 < n9) {
                n9 = n12;
            }
            if (!((double)n12 + rectangle2D2.getHeight() > (double)n10)) continue;
            n10 = (int)((double)n12 + rectangle2D2.getHeight());
        }
        return new Rectangle(n7, n9 - n11 + 2, n8 - n7, n10 - n9);
    }

    private void drawIndicatorLine(Graphics2D graphics2D, Point point, Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.grow(3, 3);
        Point point2 = null;
        int n2 = rectangle2.outcode(point);
        if ((n2 & 1) != 0) {
            point2 = new Point(rectangle2.x, rectangle2.y + rectangle2.height / 2);
        }
        if ((n2 & 4) != 0) {
            point2 = new Point(rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height / 2);
        }
        if ((n2 & 2) != 0) {
            point2 = new Point(rectangle2.x + rectangle2.width / 2, rectangle2.y);
        }
        if ((n2 & 8) != 0) {
            point2 = new Point(rectangle2.x + rectangle2.width / 2, rectangle2.y + rectangle2.height);
        }
        if (point2 != null) {
            graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
        }
    }

    public Rectangle draw(Graphics2D graphics2D, Point point) {
        Point2D point2D = this.getCurvePosition();
        Point point2 = this.chartpanel.translateJava2DToScreen(point2D);
        graphics2D.drawLine(point2.x - 2, point2.y, point2.x + 2, point2.y);
        graphics2D.drawLine(point2.x, point2.y - 2, point2.x, point2.y + 2);
        Point point3 = this.chartpanel.translateJava2DToScreen(point);
        Rectangle rectangle = this.drawNoteText(graphics2D, point);
        this.drawIndicatorLine(graphics2D, point2, rectangle);
        return rectangle;
    }
}

