/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mimvista.archive.o;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.read.LoadTaskRtStruct;
import com.mimvista.dicom.read.LoaderDataProvider;
import com.mimvista.dicom.reffinder.ReferencedSeriesFinder;
import com.mimvista.dicom.reffinder.SopReferenceFinder;
import com.mimvista.dicom.rtdose.BasicDVHLoader;
import com.mimvista.dicom.rtdose.DVHCollection;
import com.mimvista.dicom.rtdose.DVHGeneratorFactory;
import com.mimvista.dicom.rtdose.DoseLoader;
import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.dicom.rtdose.gui.DVHFrame;
import com.mimvista.dicom.rtdose.gui.DvhDisplayInfo;
import com.mimvista.dicom.rtdose.gui.DvhLineStyle;
import com.mimvista.dose.bed.ui.BEDIsodoseOverlay;
import com.mimvista.gui.TransformContoursDialog;
import com.mimvista.gui.util.InputNotification;
import com.mimvista.gui.util.JCheckboxList;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.internals.DynamicVolumeRef3D;
import com.mimvista.internals.FrameNumber;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.mui.Session;
import com.mimvista.mui.ao;
import com.mimvista.mui.overlays.AbstractContourOverlayish;
import com.mimvista.mui.overlays.ChrontourOverlay;
import com.mimvista.mui.overlays.IsodoseOverlay;
import com.mimvista.mui.overlays.OverlayCollection;
import com.mimvista.mui.overlays.SimpleVolumetricContourOverlayishBase;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.preferencesNew.ContourPrefs;
import com.mimvista.preferencesNew.DosePrefs;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.ProgressQueueNotification;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.i.b;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.ProgressPanel;
import com.mimvista.util.progress.g;
import com.mimvista.viewer.ModalitySeriesInfo;
import com.mimvista.viewer.RTDoseSeriesInfo;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.dcm4che2.data.DicomElement;

public class DVHNotification
extends InputNotification {
    static Messages props = DVHFrame.props;
    private DynamicVolumeRef3D volRef;
    private IsodoseOverlay dose;
    private JRadioButton storeDVH;
    private JCheckBox loadContours;
    private JCheckBox generate4DDVH;
    private JRadioButton genDVH;
    private JCheckboxList<TransformContoursDialog.a> cbl;
    private JButton btnSelectAll;
    private JButton btnDeselectAll;

    public DVHNotification(ViewController3D viewController3D, IsodoseOverlay isodoseOverlay) {
        super(new Notification.a(viewController3D), Messages.a("Dose", "SETTING_DIALOG_DVHBUTTON_TEXT"), "dvh");
        this.volRef = new DynamicVolumeRef3D(viewController3D);
        this.dose = isodoseOverlay;
        this.build();
    }

    private void build() {
        boolean bl2;
        DicomElement dicomElement = null;
        ModalitySeriesInfo modalitySeriesInfo = this.dose.C().getUncopiedMutableInfo().modInfo;
        if (modalitySeriesInfo instanceof RTDoseSeriesInfo) {
            dicomElement = ((RTDoseSeriesInfo)modalitySeriesInfo).dvhSequence;
        }
        boolean bl3 = bl2 = dicomElement != null && dicomElement.countItems() > 0;
        if (DoseLoader.isBadAccurayDVH(this.dose.getUncopiedMutableInfo())) {
            bl2 = false;
        }
        boolean bl4 = false;
        OverlayCollection overlayCollection = this.volRef.f().n();
        Iterable<AbstractContourOverlayish> iterable = overlayCollection.D();
        if (iterable != null) {
            iterable = Iterables.filter(iterable, (Predicate)new Predicate<AbstractContourOverlayish>(){

                public boolean apply(AbstractContourOverlayish abstractContourOverlayish) {
                    boolean bl2 = true;
                    if (DVHNotification.this.dose instanceof BEDIsodoseOverlay) {
                        BEDIsodoseOverlay bEDIsodoseOverlay = (BEDIsodoseOverlay)DVHNotification.this.dose;
                        bl2 = bEDIsodoseOverlay.b().contourParams.containsKey(abstractContourOverlayish.getName());
                    }
                    return !abstractContourOverlayish.x() && abstractContourOverlayish.bO_() && bl2;
                }
            });
            bl4 = iterable.iterator().hasNext();
        }
        if (!bl2 && !bl4) {
            String string = props.b("DVH_NO_CONTOURS_ERROR");
            DVHNotification.handleError(string);
            return;
        }
        ArrayList arrayList = Lists.newArrayList();
        if (iterable != null) {
            for (AbstractContourOverlayish abstractContourOverlayish : iterable) {
                arrayList.add(abstractContourOverlayish.G());
            }
            if (ContourPrefs.alphabetizeContours.getValue().booleanValue()) {
                Collections.sort(arrayList, new b());
            }
        }
        this.setShowReset(false);
        this.addLabel(props.b("DVH_SELECT"));
        this.addOptions(bl2, bl4);
        this.addCheckList(arrayList);
        this.addDisclaimerText();
        this.setupOKListener();
        this.addToGrandNotifier();
    }

    private void addOptions(boolean bl2, boolean bl3) {
        ButtonGroup buttonGroup = new ButtonGroup();
        this.storeDVH = new JRadioButton(props.b("DVH_SAVED_RTDOSE"));
        buttonGroup.add(this.storeDVH);
        this.storeDVH.setEnabled(bl2);
        this.loadContours = new JCheckBox(props.b("DVH_LOAD_SAVED_CONTOURS"));
        this.loadContours.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.loadContours.setSelected(!bl3);
        this.genDVH = new JRadioButton(props.b("DVH_MIM_GENERATED"));
        buttonGroup.add(this.genDVH);
        this.genDVH.setEnabled(bl3);
        if (this.genDVH.isEnabled()) {
            this.genDVH.setSelected(true);
        } else {
            this.storeDVH.setSelected(true);
        }
        this.loadContours.setEnabled(this.storeDVH.isSelected());
        this.addComponent("", this.storeDVH);
        this.addComponent("", this.loadContours);
        this.addSeparator();
        this.addComponent("", this.genDVH);
        this.storeDVH.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                DVHNotification.this.loadContours.setEnabled(DVHNotification.this.storeDVH.isSelected());
            }
        });
    }

    private void addCheckList(Iterable<VolumetricContourOverlayish> iterable) {
        String[] stringArray = DosePrefs.contourExclusionList.getValue();
        this.cbl = new JCheckboxList(true);
        this.cbl.b(false);
        this.cbl.a(false);
        if (iterable != null) {
            int n2 = 0;
            for (VolumetricContourOverlayish volumetricContourOverlayish : iterable) {
                if (!volumetricContourOverlayish.bO_()) continue;
                boolean bl2 = true;
                if (stringArray != null) {
                    for (String string : stringArray) {
                        if (!volumetricContourOverlayish.getName().toUpperCase().contains(string.toUpperCase())) continue;
                        bl2 = false;
                        break;
                    }
                }
                this.cbl.b(new TransformContoursDialog.a(volumetricContourOverlayish, false));
                this.cbl.a(n2++, bl2);
            }
        }
        this.cbl.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.cbl.setEnabled(!this.storeDVH.isSelected());
        Box box = Box.createHorizontalBox();
        box.add(this.cbl);
        box.add(Box.createHorizontalGlue());
        this.addComponent("", box);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        this.btnSelectAll = new JButton(props.b("DVH_SELECT_ALL"));
        this.btnSelectAll.setEnabled(!this.storeDVH.isSelected());
        this.btnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DVHNotification.this.cbl.c(true);
            }
        });
        this.btnDeselectAll = new JButton(props.b("DVH_DESELECT_ALL"));
        this.btnDeselectAll.setEnabled(!this.storeDVH.isSelected());
        this.btnDeselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DVHNotification.this.cbl.c(false);
            }
        });
        this.generate4DDVH = new JCheckBox(props.b("DVH_GENERATE_4D_DVH"), false);
        this.generate4DDVH.setEnabled(!this.storeDVH.isSelected());
        this.generate4DDVH.setBorder(BorderFactory.createEmptyBorder(5, 15, 5, 10));
        jPanel.add(Box.createHorizontalStrut(10));
        jPanel.add(this.btnSelectAll);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(this.btnDeselectAll);
        jPanel.add(Box.createHorizontalStrut(10));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.addComponent("", jPanel);
        if (this.volRef.e().bl()) {
            this.addComponent("", this.generate4DDVH);
        }
        this.genDVH.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                DVHNotification.this.cbl.setEnabled(DVHNotification.this.genDVH.isSelected());
                DVHNotification.this.btnSelectAll.setEnabled(DVHNotification.this.genDVH.isSelected());
                DVHNotification.this.btnDeselectAll.setEnabled(DVHNotification.this.genDVH.isSelected());
                DVHNotification.this.generate4DDVH.setEnabled(DVHNotification.this.genDVH.isSelected());
            }
        });
    }

    private void addDisclaimerText() {
        String string = props.b("DVH_PAST_EDGES_WARNING_TEXT");
        JLabel jLabel = new JLabel(string);
        jLabel.setHorizontalAlignment(0);
        jLabel.setPreferredSize(new Dimension(400, 65));
        this.addComponent("", jLabel);
        if (this.dose instanceof BEDIsodoseOverlay) {
            String string2 = props.b("DVH_BED_WARNING_TEXT");
            JLabel jLabel2 = new JLabel(string2);
            jLabel2.setHorizontalAlignment(0);
            jLabel2.setPreferredSize(new Dimension(400, 65));
            this.addComponent("", jLabel2);
        }
    }

    private void setupOKListener() {
        this.addOkListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!DVHNotification.this.storeDVH.isSelected()) {
                    boolean bl2;
                    boolean bl3 = bl2 = !DVHNotification.this.cbl.h().isEmpty();
                    if (!bl2) {
                        String string = props.b("DVH_SELECT_ERROR");
                        DVHNotification.handleError(string);
                        return;
                    }
                }
                u.b().d(DVHNotification.this);
                new Thread("DVH Loader"){

                    @Override
                    public void run() {
                        boolean bl2 = DVHNotification.this.storeDVH.isSelected();
                        if (bl2) {
                            DVHNotification.loadStoredDVH(DVHNotification.this.volRef.e(), DVHNotification.this.dose.C(), DVHNotification.this.loadContours.isSelected(), false);
                        } else {
                            ArrayList arrayList = Lists.newArrayList();
                            for (Iterator iterator : DVHNotification.this.cbl.h()) {
                                arrayList.add(((TransformContoursDialog.a)((Object)iterator)).b().G());
                            }
                            if (DVHNotification.this.generate4DDVH.isSelected()) {
                                ArrayList arrayList2;
                                HashMultimap hashMultimap = HashMultimap.create();
                                for (Serializable serializable : arrayList) {
                                    if (!(serializable instanceof ChrontourOverlay)) continue;
                                    arrayList2 = ((ChrontourOverlay)serializable).bT_();
                                    for (ChrontourOverlay chrontourOverlay : arrayList2) {
                                        if (!DVHNotification.this.isDosebro(chrontourOverlay, DVHNotification.this.dose) || !chrontourOverlay.bO_()) continue;
                                        hashMultimap.put((Object)chrontourOverlay.aH(), (Object)chrontourOverlay);
                                    }
                                }
                                for (Serializable serializable : hashMultimap.keySet()) {
                                    arrayList2 = Lists.newArrayList();
                                    for (ChrontourOverlay chrontourOverlay : hashMultimap.get((Object)serializable)) {
                                        arrayList2.add(chrontourOverlay);
                                    }
                                    if (arrayList2.isEmpty()) continue;
                                    DynamicVolumeRef3D dynamicVolumeRef3D = new DynamicVolumeRef3D((ViewController3D)((VolumetricContourOverlayish)arrayList2.get(0)).au(), (FrameNumber)serializable);
                                    DVHNotification.generateDVHs(dynamicVolumeRef3D, DVHNotification.this.dose, arrayList2);
                                }
                            } else {
                                DVHNotification.generateDVHs(DVHNotification.this.volRef, DVHNotification.this.dose, arrayList);
                            }
                        }
                    }
                }.start();
            }
        });
    }

    private boolean isDosebro(ChrontourOverlay chrontourOverlay, IsodoseOverlay isodoseOverlay) {
        for (IsodoseOverlay isodoseOverlay2 : chrontourOverlay.aL().L()) {
            if (isodoseOverlay2.C() != isodoseOverlay.C()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void okActionPerformed(ActionEvent actionEvent) {
        this.inputContentPanel.e();
        if (this.okActionListener != null) {
            this.okActionListener.actionPerformed(actionEvent);
        }
    }

    public static DVHCollection loadStoredDVH(final ViewController3D viewController3D, ImageVolumeShort imageVolumeShort, boolean bl2, boolean bl3) {
        LoaderDataProvider loaderDataProvider = null;
        try {
            boolean bl4;
            Object object;
            Object object2;
            Object object3;
            ReferencedSeriesFinder referencedSeriesFinder = new ReferencedSeriesFinder(viewController3D.bG(), imageVolumeShort.getUncopiedMutableInfo());
            referencedSeriesFinder.dontFind(viewController3D.g().f(false));
            referencedSeriesFinder.setThrowXcpIfNoResultsFound(false);
            boolean bl5 = referencedSeriesFinder.findReferencedSeries();
            boolean bl6 = false;
            List<DcmSeries> list = referencedSeriesFinder.getSeriesFound();
            DcmSeries dcmSeries = null;
            if (bl5 && list.size() > 0) {
                dcmSeries = list.get(0);
                object3 = dcmSeries.getDataProvider();
                object2 = ((LoaderDataProvider)object3).getFirstDicomObj().getString(524384, "");
                if (((String)object2).toLowerCase().contains("rtplan")) {
                    bl6 = true;
                }
            } else {
                bl6 = true;
            }
            if (bl6) {
                object3 = new SopReferenceFinder(viewController3D.getUncopiedMutableInfo(), viewController3D.bG());
                object2 = (RTDoseSeriesInfo)imageVolumeShort.getUncopiedMutableInfo().modInfo;
                object = new ProgressPanel();
                ProgressQueueNotification.a((g)object);
                ((ProgressPanel)object).a(Messages.a("Archive").getProperty("QUERYCLIENT_SEARCH"));
                dcmSeries = ((SopReferenceFinder)object3).find(((RTDoseSeriesInfo)object2).referencedRtStructUID, "RTST", (Progress)object);
            }
            if (!(dcmSeries != null && (loaderDataProvider = dcmSeries.getDataProvider()) != null || bl3)) {
                object3 = props.b("DVH_RTST_MISSING");
                DVHNotification.handleError((String)object3);
                return null;
            }
            if (bl2) {
                object3 = new FuncUtils.f();
                object2 = loaderDataProvider;
                ProgressQueueNotification.a(new ProgressQueueNotification.b((LoaderDataProvider)object2, (FuncUtils.f)object3){
                    final /* synthetic */ LoaderDataProvider val$provider_;
                    final /* synthetic */ FuncUtils.f val$rtLoad;
                    {
                        this.val$provider_ = loaderDataProvider;
                        this.val$rtLoad = f2;
                    }

                    @Override
                    public void run(g g2) {
                        LoadTaskRtStruct loadTaskRtStruct = new LoadTaskRtStruct(viewController3D.g(), this.val$provider_, g2, new o());
                        loadTaskRtStruct.run();
                        this.val$rtLoad.b();
                    }
                });
                try {
                    ((FuncUtils.f)object3).a();
                }
                catch (Exception exception) {
                    ay.d((Object)"Error loading RTST for DVH", (Throwable)exception, DVHNotification.class);
                    String string = props.b("DVH_LOAD_ERROR");
                    DVHNotification.handleError(string);
                    return null;
                }
            }
            if ((bl4 = ((BasicDVHLoader)(object3 = new DoseLoader())).load(imageVolumeShort.getUncopiedMutableInfo(), loaderDataProvider.getFirstDicomObj(2145386512))) && ((BasicDVHLoader)object3).getCurves().size() > 0) {
                object = new DVHCollection(new DynamicVolumeRef3D(viewController3D, null), imageVolumeShort, ((BasicDVHLoader)object3).getCurves(), imageVolumeShort.getUncopiedMutableInfo());
                if (!(GraphicsEnvironment.isHeadless() || viewController3D.g().T() || bl3)) {
                    DVHNotification.addToDVHViewer(viewController3D.g(), (DVHCollection)object);
                }
                return object;
            }
            object = props.b("DVH_LOAD_ERROR");
            DVHNotification.handleError((String)object);
            return null;
        }
        catch (Exception exception) {
            ay.d((Object)"Error loading stored DVH", (Throwable)exception, DVHNotification.class);
            String string = props.b("DVH_LOAD_ERROR");
            DVHNotification.handleError(string);
            return null;
        }
    }

    public static void generateDVHs(DynamicVolumeRef3D dynamicVolumeRef3D, IsodoseOverlay isodoseOverlay, List<VolumetricContourOverlayish> list) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        DVHNotification.generateDVHs(dynamicVolumeRef3D, isodoseOverlay, list, countDownLatch);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void generateDVHs(final DynamicVolumeRef3D dynamicVolumeRef3D, final IsodoseOverlay isodoseOverlay, final List<VolumetricContourOverlayish> list, final CountDownLatch countDownLatch) {
        if (list.size() < 1) {
            return;
        }
        final DVHCollection dVHCollection = new DVHCollection(dynamicVolumeRef3D, isodoseOverlay.C(), isodoseOverlay.C().getUncopiedMutableInfo(), list.size());
        final ArrayList arrayList = Lists.newArrayList();
        ProgressQueueNotification.a(new ProgressQueueNotification.b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(g g2) {
                Object object = new Object();
                try {
                    g2.a(props.b("DVH_GENERATING_DVH"));
                    int n2 = 0;
                    for (Object object2 : list) {
                        n2 += object2.aq().w();
                    }
                    g2.a(n2);
                    g2.c(true);
                    g2.a();
                    for (Object object2 : list) {
                        try {
                            g2.b_(props.b("DVH_GENERATING_FOR") + " " + object2.getName());
                            Object object3 = DVHGeneratorFactory.generate((SimpleVolumetricContourOverlayishBase)object2, isodoseOverlay, (Progress)g2);
                            if (g2.n() == Progress.Status.e) break;
                            if (object3 != null) {
                                dVHCollection.add((DoseVolumeHistogram)object3);
                                continue;
                            }
                            arrayList.add(object2.getName());
                        }
                        catch (Exception exception) {
                            ay.d((Object)("Error generating DVH for " + object2.getName()), (Throwable)exception, DVHNotification.class);
                            arrayList.add(object2.getName());
                        }
                    }
                    isodoseOverlay.h().a(object, dVHCollection.getDVHs());
                }
                finally {
                    if (g2.n() != Progress.Status.e) {
                        if (dVHCollection.size() > 0) {
                            DVHNotification.addToDVHViewer(dynamicVolumeRef3D.a(), dVHCollection);
                            isodoseOverlay.h().a(object);
                            if (arrayList.size() > 0) {
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.append(props.b("DVH_PARTIAL_ERROR"));
                                stringBuilder.append(": ");
                                boolean bl2 = true;
                                for (Object object3 : arrayList) {
                                    if (!bl2) {
                                        stringBuilder.append(", ");
                                    } else {
                                        bl2 = true;
                                    }
                                    stringBuilder.append((String)object3);
                                }
                                DVHNotification.handleError(stringBuilder.toString());
                            }
                        } else {
                            String string = props.b("DVH_GEN_ERROR");
                            DVHNotification.handleError(string);
                        }
                    }
                    countDownLatch.countDown();
                    g2.b();
                }
            }
        });
    }

    public static void addToDVHViewer(final Session session, final DVHCollection dVHCollection) {
        MIMSwingUtils.b(new Runnable(){

            @Override
            public void run() {
                DVHFrame dVHFrame = DVHFrame.getCurrentFrameForSession(session);
                if (dVHFrame != null) {
                    dVHFrame.addDVH(dVHCollection);
                    DvhLineStyle dvhLineStyle = DvhLineStyle.values()[(dVHFrame.getCollections().size() - 1) % DvhLineStyle.values().length];
                    dVHCollection.setLineStyle(dvhLineStyle);
                    for (DvhDisplayInfo dvhDisplayInfo : dVHCollection.getDvhDisplayInfo()) {
                        dvhDisplayInfo.setLineStyle(dvhLineStyle);
                    }
                    dVHFrame.getDisplay().updateStrokes();
                } else {
                    dVHFrame = new DVHFrame(session, dVHCollection);
                }
                DVHNotification.addToDVHViewer(dVHFrame);
            }
        });
    }

    public static void addToDVHViewer(final DVHFrame dVHFrame) {
        MIMSwingUtils.b(new Runnable(){

            @Override
            public void run() {
                int n2 = dVHFrame.getExtendedState();
                if ((n2 & 1) > 0) {
                    dVHFrame.setExtendedState(n2 & 0xFFFFFFFE);
                }
                dVHFrame.setVisible(true);
                dVHFrame.requestFocus();
            }
        });
    }

    private static void handleError(String string) {
        ay.d((Object)string, DVHNotification.class);
        JOptionPane.showMessageDialog(ao.Q().O(), string, props.b("DVH_DISPLAY_ERROR"), 0);
    }
}

