/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.mimvista.dicom.rtdose.DoseValue;
import com.mimvista.dicom.rtdose.gui.DVHDisplayParams;
import com.mimvista.dicom.rtdose.gui.DVHDisplayState;
import com.mimvista.dicom.rtdose.gui.DVHFrame;
import com.mimvista.dicom.rtdose.gui.DoseNormType;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.swing.DelayedActionRunner;
import com.mimvista.swing.c;
import com.mimvista.util.Messages;
import com.mimvista.util.NumberFormatFactory;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DVHOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    DVHDisplayParams params;
    DVHDisplayState dvhDisp;
    JCheckBox normalizeVolume;
    JCheckBox showGrid;
    JComboBox<DoseNormType> normalizationType;
    JTextField doseEntry;
    JTextField doseCap;
    float defaultCutOff;
    private JCheckBox maxDisplayDoseCheckBox;
    private DelayedActionRunner rxDar = new DelayedActionRunner(500, () -> this.params.setRxDose(new DoseValue(this.getDoseFieldValue(this.doseEntry))));
    private DelayedActionRunner rxCapDar = new DelayedActionRunner(500, () -> this.params.setDoseCap(new DoseValue(this.getDoseFieldValue(this.doseCap))));

    public DVHOptionsPanel(DVHDisplayState dVHDisplayState) {
        this.dvhDisp = dVHDisplayState;
        this.params = dVHDisplayState.getDVHParams();
        this.build();
    }

    private void build() {
        Object object;
        this.removeAll();
        this.setLayout(new BoxLayout(this, 3));
        if (this.dvhDisp.isInDvhViewer()) {
            object = new JButton(DVHFrame.props.b("DVH_SELECT_ALL"));
            ((AbstractButton)object).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DVHOptionsPanel.this.dvhDisp.showAll();
                }
            });
            JButton jButton = new JButton(DVHFrame.props.b("DVH_DESELECT_ALL"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DVHOptionsPanel.this.dvhDisp.hideAll();
                }
            });
            this.add(c.b(new Component[]{object, Box.createHorizontalStrut(10), jButton}));
            this.add(Box.createVerticalStrut(10));
        }
        this.showGrid = new JCheckBox(DVHFrame.props.b("DVH_SHOW_GRID"));
        this.add(c.d(this.showGrid));
        this.showGrid.addActionListener(actionEvent -> {
            this.params.setShowGridLines(this.showGrid.isSelected());
            this.dvhDisp.refreshUI();
        });
        this.normalizationType = new JComboBox();
        this.normalizationType.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
                return super.getListCellRendererComponent((JList<?>)jList, ((DoseNormType)object).getExternalizedString(), n2, bl2, bl3);
            }
        });
        for (DoseNormType doseNormType : DoseNormType.values()) {
            this.normalizationType.addItem(doseNormType);
        }
        this.add(c.d(new JLabel(Messages.a("DVH", "DVH_DOSE_NORM_TYPE"))));
        this.add(Box.createVerticalStrut(5));
        object = Box.createHorizontalBox();
        this.doseEntry = new JTextField();
        this.doseEntry.setPreferredSize(new Dimension(70, 18));
        this.doseEntry.setMaximumSize(new Dimension(70, 18));
        this.doseEntry.setSize(new Dimension(70, 18));
        this.doseEntry.setActionCommand(DoseNormType.PRESCRIPTION.name());
        ((Container)object).add(Box.createHorizontalStrut(30));
        ((Container)object).add(this.normalizationType);
        ((Container)object).add(Box.createHorizontalStrut(10));
        ((Container)object).add(this.doseEntry);
        this.add((Component)object);
        this.normalizeVolume = new JCheckBox(DVHFrame.props.b("DVH_NORM_VOL"));
        this.add(c.d(this.normalizeVolume));
        this.maxDisplayDoseCheckBox = new JCheckBox(DVHFrame.props.b("DVH_DOSE_DISPLAY_CAP") + " (" + DoseValue.doseUnit.name() + ")");
        this.doseCap = new JTextField();
        this.doseCap.setPreferredSize(new Dimension(70, 18));
        this.doseCap.setMaximumSize(new Dimension(70, 18));
        this.doseCap.setSize(new Dimension(70, 18));
        this.add(c.d(this.maxDisplayDoseCheckBox, Box.createHorizontalStrut(10), this.doseCap));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DoseNormType doseNormType = null;
                try {
                    doseNormType = (DoseNormType)DVHOptionsPanel.this.normalizationType.getSelectedItem();
                }
                catch (Exception exception) {
                    ay.d((Object)("Error getting norm type: " + actionEvent.getActionCommand()), this);
                    return;
                }
                if (doseNormType == DVHOptionsPanel.this.params.getDoseNormType()) {
                    return;
                }
                switch (doseNormType) {
                    case CONTOURMAX: {
                        DVHOptionsPanel.this.params.setDoseNormType(DoseNormType.CONTOURMAX);
                        DVHOptionsPanel.this.setDoseCapEnabled(false);
                        DVHOptionsPanel.this.doseEntry.setVisible(false);
                        break;
                    }
                    case DOSEMAX: {
                        DVHOptionsPanel.this.params.setDoseNormType(DoseNormType.DOSEMAX);
                        DVHOptionsPanel.this.setDoseCapEnabled(false);
                        DVHOptionsPanel.this.doseEntry.setVisible(false);
                        break;
                    }
                    case ABSOLUTE: {
                        DVHOptionsPanel.this.params.setDoseNormType(DoseNormType.ABSOLUTE);
                        DVHOptionsPanel.this.setDoseCapEnabled(true);
                        DVHOptionsPanel.this.doseEntry.setVisible(false);
                        break;
                    }
                    case PRESCRIPTION: {
                        DVHOptionsPanel.this.params.setDoseNormType(DoseNormType.PRESCRIPTION);
                        DVHOptionsPanel.this.setDoseCapEnabled(true);
                        DVHOptionsPanel.this.doseEntry.setVisible(true);
                    }
                }
                DVHOptionsPanel.this.doseEntry.getParent().invalidate();
                DVHOptionsPanel.this.doseEntry.getParent().validate();
                DVHOptionsPanel.this.doseEntry.getParent().repaint();
            }
        };
        this.maxDisplayDoseCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DVHOptionsPanel.this.params.setUseDoseCap(DVHOptionsPanel.this.maxDisplayDoseCheckBox.isSelected());
                DVHOptionsPanel.this.doseCap.setEnabled(DVHOptionsPanel.this.maxDisplayDoseCheckBox.isSelected());
            }
        });
        this.doseCap.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    DVHOptionsPanel.this.rxCapDar.b();
                }
            }
        });
        this.doseCap.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                DVHOptionsPanel.this.rxCapDar.b();
            }
        });
        this.normalizationType.addActionListener(actionListener);
        this.doseEntry.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    DVHOptionsPanel.this.rxDar.b();
                }
            }
        });
        this.doseEntry.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                DVHOptionsPanel.this.rxDar.b();
            }
        });
        this.normalizeVolume.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DVHOptionsPanel.this.params.setNormalizedVolume(DVHOptionsPanel.this.normalizeVolume.isSelected());
            }
        });
        this.updateFieldsInternal();
    }

    public void updateFields() {
        MIMSwingUtils.a(new Runnable(){

            @Override
            public void run() {
                DVHOptionsPanel.this.updateFieldsInternal();
            }
        });
    }

    private void updateFieldsInternal() {
        try {
            NumberFormat numberFormat = NumberFormatFactory.a();
            float f2 = this.params.getRxDose().getValueInCurrentUnit();
            this.doseEntry.setText(numberFormat.format(f2));
            this.normalizeVolume.setSelected(this.params.isNormalizedVolume());
            this.showGrid.setSelected(this.params.isShowGridLines());
            this.normalizationType.setSelectedItem(this.params.getDoseNormType());
            if (this.params.getDoseNormType() == DoseNormType.PRESCRIPTION) {
                this.doseEntry.setVisible(true);
            } else {
                this.doseEntry.setVisible(false);
            }
            this.maxDisplayDoseCheckBox.setSelected(this.params.isUseDoseCap());
            Float f3 = Float.valueOf(this.params.getDoseCap().getValueInCurrentUnit());
            this.doseCap.setText(numberFormat.format(f3));
            this.doseCap.setEnabled(this.maxDisplayDoseCheckBox.isSelected());
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error updating fields in DVH viewer", throwable, this);
        }
    }

    private float getDoseFieldValue(JTextField jTextField) {
        try {
            String string = jTextField.getText();
            if (!cn.g(string)) {
                return Float.parseFloat(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            ay.d((Object)("Invalid entry in DVH Viewer dose field: " + jTextField.getText()), (Throwable)numberFormatException, this);
        }
        return 0.0f;
    }

    private void setDoseCapEnabled(boolean bl2) {
        this.maxDisplayDoseCheckBox.setEnabled(bl2);
        this.doseCap.setEnabled(bl2);
        this.repaint();
    }
}

