/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.google.common.collect.Lists;
import com.mimvista.dicom.rtdose.DoseValue;
import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.dicom.rtdose.gui.BlackWhiteLookAndFeel;
import com.mimvista.dicom.rtdose.gui.DVHDisplayState;
import com.mimvista.dicom.rtdose.gui.DVHFrame;
import com.mimvista.dicom.rtdose.gui.DVHLineStyleRenderer;
import com.mimvista.dicom.rtdose.gui.DvhDisplayInfo;
import com.mimvista.dicom.rtdose.gui.DvhLineStyle;
import com.mimvista.mui.overlays.OverlayColor;
import com.mimvista.mui.overlays.OverlayColorPool;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.preferencesNew.ConfigPrefs;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.util.Messages;
import com.mimvista.util.NumberFormatFactory;
import com.mimvista.util.ay;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class DVHPanelItem
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static Color[] defaultColors = new Color[]{Color.RED, Color.CYAN, Color.YELLOW, Color.GREEN, Color.ORANGE, Color.BLUE};
    protected static final int COLOR_SETTING_PICKER_HEIGHT = 28;
    protected static final Dimension COLOR_SETTING_PICKER_DIMS = new Dimension(130, 28);
    protected static final float COLOR_SETTING_FONT = 11.0f;
    private JCheckBox dvhCheck = new JCheckBox();
    private JLabel dvhName = new JLabel();
    private JLabel roiIncluded = new JLabel();
    private DvhDisplayInfo ddi;
    private final DVHDisplayState dvhDisplay;
    private JComboBox btnColor;
    private JComboBox btnStroke;

    public DVHPanelItem(DvhDisplayInfo dvhDisplayInfo, DVHDisplayState dVHDisplayState) {
        Object object;
        this.ddi = dvhDisplayInfo;
        this.dvhDisplay = dVHDisplayState;
        this.setBorder(BorderFactory.createLineBorder(MIMLookAndFeel.d()));
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paint(Graphics graphics) {
                super.paint(graphics);
                if (DVHPanelItem.this.ddi.isSelected()) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setPaint(Color.RED);
                    graphics2D.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                    graphics2D.drawRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
                }
            }
        };
        jPanel.setLayout(new GridBagLayout());
        final JPanel jPanel2 = jPanel;
        JPanel jPanel3 = new JPanel(this.getBorderLayout());
        JPanel jPanel4 = new JPanel(this.getBorderLayout());
        JPanel jPanel5 = new JPanel(this.getBorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jPanel5, gridBagConstraints);
        this.add(jPanel);
        String string = dvhDisplayInfo.getDVH().getName();
        this.dvhName.setText(string);
        this.dvhName.setToolTipText(string);
        this.dvhName.setPreferredSize(COLOR_SETTING_PICKER_DIMS);
        this.dvhCheck.setSelected(dvhDisplayInfo.isVisible());
        this.dvhCheck.setPreferredSize(new Dimension(25, 20));
        jPanel3.add((Component)this.dvhCheck, "West");
        jPanel3.add((Component)this.dvhName, "Center");
        this.dvhCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DVHPanelItem.this.dvhDisplay.setVisible(DVHPanelItem.this.ddi, DVHPanelItem.this.dvhCheck.isSelected());
                if (!DVHPanelItem.this.dvhCheck.isSelected()) {
                    DVHPanelItem.this.dvhDisplay.unselectDVH(DVHPanelItem.this.ddi);
                    jPanel2.repaint();
                }
            }
        });
        jPanel4.add((Component)this.roiIncluded, "Center");
        this.btnColor = this.makeColorDropDown(dvhDisplayInfo);
        this.btnStroke = this.makeStrokeDropDown(dvhDisplayInfo);
        jPanel3.add((Component)this.btnColor, "East");
        jPanel4.add((Component)this.btnStroke, "East");
        this.btnStroke.setSelectedItem(dvhDisplayInfo.getLineStyle());
        JLabel jLabel = new JLabel(this.getStatTextTop());
        jLabel.setToolTipText(this.getStatTextTop());
        jPanel4.add((Component)jLabel, "West");
        JLabel jLabel2 = new JLabel(this.getStatTextBottom());
        jLabel2.setToolTipText(this.getStatTextBottom());
        jPanel5.add((Component)jLabel2, "West");
        if (!Double.isNaN(dvhDisplayInfo.getDVH().calculateTCP())) {
            object = new JPanel(this.getBorderLayout());
            ++gridBagConstraints.gridy;
            jPanel.add((Component)object, gridBagConstraints);
            JLabel jLabel3 = new JLabel(DVHPanelItem.getStatTextAdditional(dvhDisplayInfo));
            ((Container)object).add((Component)jLabel3, "West");
        }
        object = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                DVHPanelItem.this.dvhDisplay.selectDVH(DVHPanelItem.this.ddi);
            }
        };
        this.addMouseListener((MouseListener)object);
        this.dvhName.addMouseListener((MouseListener)object);
        jLabel.addMouseListener((MouseListener)object);
    }

    public void setChecked(boolean bl2) {
        this.dvhCheck.setSelected(bl2);
    }

    public void setStroke(Stroke stroke) {
        this.btnStroke.setSelectedItem(stroke);
    }

    private JComboBox makeColorDropDown(final DvhDisplayInfo dvhDisplayInfo) {
        JComboBox<Object> jComboBox = new JComboBox<Object>();
        jComboBox.setModel(new ColorSquarePickerModel(dvhDisplayInfo, new FuncUtils.m<OverlayColor>(){

            @Override
            public void doIt(OverlayColor overlayColor) {
                try {
                    DVHPanelItem.this.dvhDisplay.updateColor(dvhDisplayInfo, overlayColor.color);
                }
                catch (Exception exception) {
                    ay.d((Object)"Error setting DVH color", (Throwable)exception, this.getClass());
                }
            }
        }));
        jComboBox.setRenderer(new PrettyColorSquareRenderer());
        jComboBox.setPreferredSize(COLOR_SETTING_PICKER_DIMS);
        jComboBox.setFont(jComboBox.getFont().deriveFont(11.0f));
        jComboBox.setMaximumRowCount(50);
        return jComboBox;
    }

    private JComboBox makeStrokeDropDown(DvhDisplayInfo dvhDisplayInfo) {
        JComboBox<Object> jComboBox = new JComboBox<Object>();
        jComboBox.setModel(new StrokePickerModel(dvhDisplayInfo, new FuncUtils.m<DvhDisplayInfo>(){

            @Override
            public void doIt(DvhDisplayInfo dvhDisplayInfo) {
                DVHPanelItem.this.dvhDisplay.updateStroke(dvhDisplayInfo, (DvhLineStyle)DVHPanelItem.this.btnStroke.getSelectedItem());
            }
        }));
        jComboBox.setRenderer(new DvhPrettyStrokeRenderer());
        jComboBox.setPreferredSize(COLOR_SETTING_PICKER_DIMS);
        jComboBox.setFont(jComboBox.getFont().deriveFont(11.0f));
        jComboBox.setMaximumRowCount(50);
        return jComboBox;
    }

    String getStatTextTop() {
        List<String> list = DVHPanelItem.getStatStrings(this.ddi.getDVH());
        return list.get(0) + ", " + list.get(1);
    }

    String getStatTextBottom() {
        List<String> list = DVHPanelItem.getStatStrings(this.ddi.getDVH());
        return list.get(2) + ", " + list.get(3) + ", " + list.get(4);
    }

    public static String getStatTextAdditional(DvhDisplayInfo dvhDisplayInfo) {
        double d2 = 100.0 * dvhDisplayInfo.getDVH().calculateTCP();
        String string = Double.isNaN(d2) ? "-" : NumberFormatFactory.a().format(d2) + "%";
        String string2 = Messages.a("Dose", "TCP_PROPERTY_TITLE") + ": " + string;
        return string2;
    }

    public static List<String> getStatStrings(DoseVolumeHistogram doseVolumeHistogram) {
        NumberFormat numberFormat = NumberFormatFactory.a();
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(numberFormat.format(doseVolumeHistogram.getMaxVolume()) + (ConfigPrefs.showCcInsteadOfMl.getValue() != false ? DVHFrame.props.b("DVH_UNIT_CC") : DVHFrame.props.b("DVH_UNIT_ML")));
        DoseValue doseValue = new DoseValue();
        doseValue.setValueInGy((float)doseVolumeHistogram.getMaxDose());
        arrayList.add(DVHFrame.props.b("DVH_MAX_DOSE") + ": " + numberFormat.format(doseValue.getValueInCurrentUnit()) + DoseValue.doseUnit.name());
        doseValue.setValueInGy((float)doseVolumeHistogram.getMinDose());
        arrayList.add(DVHFrame.props.b("DVH_MIN_DOSE") + ": " + numberFormat.format(doseValue.getValueInCurrentUnit()) + DoseValue.doseUnit.name());
        doseValue.setValueInGy((float)doseVolumeHistogram.getMeanDose());
        arrayList.add(DVHFrame.props.b("DVH_MEAN_DOSE") + ": " + numberFormat.format(doseValue.getValueInCurrentUnit()) + DoseValue.doseUnit.name());
        doseValue.setValueInGy((float)doseVolumeHistogram.getDoseStdDev());
        arrayList.add(DVHFrame.props.b("DVH_SD_DOSE") + ": " + numberFormat.format(doseValue.getValueInCurrentUnit()) + DoseValue.doseUnit.name());
        return arrayList;
    }

    public JLabel makeLabelForCapture(BlackWhiteLookAndFeel blackWhiteLookAndFeel, boolean bl2) {
        JLabel jLabel = new JLabel(new ImageIcon(this.makeStrokeImage(blackWhiteLookAndFeel.getWhite())));
        if (bl2) {
            jLabel.setText(this.ddi.getDVH().getName());
        } else {
            String string = "<html><body><strong>" + this.ddi.getDVH().getName() + "</strong><br>" + this.getStatTextTop() + "<br>" + this.getStatTextBottom();
            if (this.ddi.getDVH().hasBedInfo()) {
                string = string + "<br>" + DVHPanelItem.getStatTextAdditional(this.ddi);
            }
            jLabel.setText(string + "</body></html>");
        }
        jLabel.setVerticalAlignment(0);
        jLabel.setVerticalTextPosition(0);
        return jLabel;
    }

    private BufferedImage makeStrokeImage(Color color) {
        BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, 16, 16);
        if (this.ddi.getLineStyle() == null) {
            graphics2D.setStroke(new BasicStroke(1.0f));
        } else {
            graphics2D.setStroke(this.ddi.getLineStyle().getStroke());
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.ddi.getColor());
        graphics2D.drawLine(0, 8, 15, 8);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BorderLayout getBorderLayout() {
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(5);
        return borderLayout;
    }

    public void refresh() {
    }

    protected class DvhPrettyStrokeRenderer
    extends DVHLineStyleRenderer {
        private static final long serialVersionUID = 1L;

        protected DvhPrettyStrokeRenderer() {
        }

        @Override
        public Color getColor() {
            return DVHPanelItem.this.ddi.getColor();
        }
    }

    protected static class PrettyColorSquareRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;
        private Map<Color, Icon> iconCache = new HashMap<Color, Icon>();

        protected PrettyColorSquareRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            Object object2;
            Object object3;
            super.getListCellRendererComponent((JList<?>)jList, object, n2, bl2, bl3);
            OverlayColor overlayColor = null;
            if (object instanceof OverlayColor) {
                overlayColor = (OverlayColor)object;
            } else if (object instanceof Color) {
                object3 = (Color)object;
                object2 = new OverlayColorPool();
                for (OverlayColor overlayColor2 : ((OverlayColorPool)object2).b()) {
                    if (!((Color)object3).equals(overlayColor2.color)) continue;
                    overlayColor = overlayColor2;
                }
            }
            if (overlayColor == null) {
                return this;
            }
            this.setText(overlayColor.name);
            object3 = this.iconCache.get(overlayColor.color);
            if (object3 == null) {
                object2 = new BufferedImage(20, 20, 5);
                Graphics graphics = ((BufferedImage)object2).getGraphics();
                graphics.setColor(overlayColor.color);
                graphics.fillRect(1, 1, ((BufferedImage)object2).getWidth() - 2, ((BufferedImage)object2).getHeight() - 2);
                object3 = new ImageIcon((Image)object2);
                graphics.dispose();
                this.iconCache.put(overlayColor.color, (Icon)object3);
            }
            this.setIcon((Icon)object3);
            return this;
        }
    }

    protected static class StrokePickerModel
    extends DefaultComboBoxModel {
        private static final long serialVersionUID = 1L;
        private DvhDisplayInfo ddi;
        private FuncUtils.m<DvhDisplayInfo> applyChangesListener;
        private List<DvhLineStyle> strokes = Lists.newArrayList((Object[])DvhLineStyle.values());

        public StrokePickerModel(DvhDisplayInfo dvhDisplayInfo, FuncUtils.m<DvhDisplayInfo> m2) {
            this.ddi = dvhDisplayInfo;
            this.applyChangesListener = m2;
        }

        @Override
        public void setSelectedItem(Object object) {
            super.setSelectedItem(object);
            if (!(object instanceof DvhLineStyle)) {
                return;
            }
            this.ddi.setLineStyle((DvhLineStyle)object);
            if (this.applyChangesListener != null) {
                this.applyChangesListener.doIt(this.ddi);
            }
        }

        @Override
        public DvhLineStyle getSelectedItem() {
            return this.ddi.getLineStyle();
        }

        @Override
        public int getIndexOf(Object object) {
            return this.strokes.indexOf(object);
        }

        @Override
        public DvhLineStyle getElementAt(int n2) {
            return this.strokes.get(n2);
        }

        @Override
        public int getSize() {
            return this.strokes.size();
        }
    }

    protected static class ColorSquarePickerModel
    extends DefaultComboBoxModel {
        private static final long serialVersionUID = 1L;
        private OverlayColorPool cp = new OverlayColorPool();
        private DvhDisplayInfo ddi;
        private FuncUtils.m<OverlayColor> applyChangesListener;

        public ColorSquarePickerModel(DvhDisplayInfo dvhDisplayInfo, FuncUtils.m<OverlayColor> m2) {
            this.ddi = dvhDisplayInfo;
            this.applyChangesListener = m2;
        }

        @Override
        public void setSelectedItem(Object object) {
            super.setSelectedItem(object);
            if (!(object instanceof OverlayColor)) {
                return;
            }
            if (this.applyChangesListener != null) {
                this.applyChangesListener.doIt((OverlayColor)object);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.ddi.getColor();
        }

        @Override
        public int getIndexOf(Object object) {
            return this.cp.b().indexOf(object);
        }

        @Override
        public Object getElementAt(int n2) {
            return this.cp.b().get(n2);
        }

        @Override
        public int getSize() {
            return this.cp.b().size();
        }
    }
}

