/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.mimvista.dicom.rtdose.DVHCollection;
import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.dicom.rtdose.gui.DVHChartPanel;
import com.mimvista.dicom.rtdose.gui.DVHChartWrapper;
import com.mimvista.dicom.rtdose.gui.DVHDisplay;
import com.mimvista.dicom.rtdose.gui.DVHDisplayParams;
import com.mimvista.dicom.rtdose.gui.DVHPanelItem;
import com.mimvista.dicom.rtdose.gui.DvhDisplayInfo;
import com.mimvista.dicom.rtdose.gui.DvhLineStyle;
import com.mimvista.gui.util.MIMSwingUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DVHPrinter
implements Printable {
    final int STROKE_WIDTH = 36;
    final float SMALLER_FONT_SCALE = 0.8f;
    final int PADDING = 5;
    DVHDisplayParams params;
    DVHChartPanel chartPanel;

    public DVHPrinter(DVHDisplay dVHDisplay) {
        this.params = dVHDisplay.getDVHParams().clone();
        this.params.setReportMode(true);
        DVHChartWrapper dVHChartWrapper = new DVHChartWrapper(this.params);
        this.chartPanel = new DVHChartPanel(dVHChartWrapper, false, null);
        this.chartPanel.setSpecialAnnotations(dVHDisplay.getAnnotations());
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n2) throws PrinterException {
        Graphics2D graphics2D = (Graphics2D)graphics;
        LegendLayout legendLayout = this.doLayout(graphics2D, pageFormat);
        if (n2 >= legendLayout.getNumberOfPages()) {
            return 1;
        }
        Rectangle rectangle = this.getChartArea(pageFormat);
        if (n2 == 0) {
            graphics2D.translate(rectangle.x, rectangle.y);
            this.chartPanel.setSize(rectangle.width, rectangle.height);
            this.chartPanel.doLayout();
            this.chartPanel.validate();
            this.chartPanel.print(graphics2D);
            graphics2D.translate(-rectangle.x, -rectangle.y);
        }
        this.drawLegend(legendLayout, graphics2D, n2);
        return 0;
    }

    private LegendLayout doLayout(Graphics2D graphics2D, PageFormat pageFormat) {
        LegendLayout legendLayout = new LegendLayout(graphics2D, pageFormat);
        for (Map.Entry<DVHCollection, List<DvhDisplayInfo>> entry : this.params.getFilteredDVHs().entrySet()) {
            DVHCollection dVHCollection = entry.getKey();
            legendLayout.putDVHHeader(dVHCollection.getCollectionInfoStrings());
            for (DvhDisplayInfo dvhDisplayInfo : entry.getValue()) {
                if (!dvhDisplayInfo.isVisible()) continue;
                DoseVolumeHistogram doseVolumeHistogram = dvhDisplayInfo.getDVH();
                legendLayout.putDVHBlock(doseVolumeHistogram.getName(), dvhDisplayInfo.getLineStyle(), dvhDisplayInfo.getColor(), DVHPanelItem.getStatStrings(doseVolumeHistogram));
            }
        }
        return legendLayout;
    }

    private void drawLegend(LegendLayout legendLayout, Graphics2D graphics2D, int n2) {
        Object object;
        Object object2;
        if (legendLayout.textPositions.containsKey((Object)n2)) {
            object2 = graphics2D.getPaint();
            object = graphics2D.getFont();
            graphics2D.setPaint(Color.BLACK);
            for (Object object3 : legendLayout.textPositions.get((Object)n2)) {
                if (((PositionedText)object3).bold) {
                    graphics2D.setFont(graphics2D.getFont().deriveFont(1));
                }
                graphics2D.setFont(graphics2D.getFont().deriveFont(((PositionedText)object3).size));
                graphics2D.drawString(((PositionedText)object3).text, ((PositionedText)object3).position.x, ((PositionedText)object3).position.y);
                graphics2D.setFont((Font)object);
            }
            graphics2D.setPaint((Paint)object2);
        }
        if (legendLayout.strokePositions.containsKey((Object)n2)) {
            object2 = graphics2D.getStroke();
            object = graphics2D.getPaint();
            for (Object object3 : legendLayout.strokePositions.get((Object)n2)) {
                graphics2D.setStroke(((PositionedStroke)object3).stroke);
                graphics2D.setPaint(((PositionedStroke)object3).color);
                graphics2D.draw(((PositionedStroke)object3).line);
            }
            graphics2D.setStroke((Stroke)object2);
            graphics2D.setPaint((Paint)object);
        }
    }

    private Rectangle getChartArea(PageFormat pageFormat) {
        Rectangle rectangle = this.getUsableRect(pageFormat);
        rectangle.height = this.getChartHeight(rectangle.height);
        return rectangle;
    }

    private List<Rectangle> getLegendAreasForPage(PageFormat pageFormat, int n2) {
        int n3;
        ArrayList arrayList = Lists.newArrayList();
        Rectangle rectangle = this.getUsableRect(pageFormat);
        if (n2 == 0) {
            n3 = this.getChartHeight(rectangle.height);
            rectangle.height -= n3;
            rectangle.y += n3;
        }
        for (n3 = 0; n3 < 3; ++n3) {
            Rectangle rectangle2 = new Rectangle();
            rectangle2.x = rectangle.x + n3 * rectangle.width / 3;
            rectangle2.y = rectangle.y;
            rectangle2.height = rectangle.height;
            rectangle2.width = rectangle.width / 3;
            arrayList.add(rectangle2);
        }
        return arrayList;
    }

    private int getChartHeight(int n2) {
        return (int)Math.floor((double)n2 * 0.7);
    }

    private Rectangle getUsableRect(PageFormat pageFormat) {
        Rectangle rectangle = new Rectangle();
        rectangle.x = (int)Math.ceil(pageFormat.getImageableX());
        rectangle.y = (int)Math.ceil(pageFormat.getImageableY());
        rectangle.height = (int)Math.floor(pageFormat.getImageableHeight() - ((double)rectangle.y - pageFormat.getImageableY()));
        rectangle.width = (int)Math.floor(pageFormat.getImageableWidth() - ((double)rectangle.x - pageFormat.getImageableX()));
        return rectangle;
    }

    class LegendLayout {
        Multimap<Integer, PositionedText> textPositions = HashMultimap.create();
        Multimap<Integer, PositionedStroke> strokePositions = HashMultimap.create();
        int currentPage;
        PageFormat page;
        Iterator<Rectangle> currentRects;
        Graphics2D g2d;
        Rectangle currentRect;
        int remainingHeight;

        public LegendLayout(Graphics2D graphics2D, PageFormat pageFormat) {
            this.g2d = graphics2D;
            this.page = pageFormat;
            this.currentPage = 0;
            this.currentRects = DVHPrinter.this.getLegendAreasForPage(pageFormat, this.currentPage).iterator();
            this.currentRect = this.currentRects.next();
            this.remainingHeight = this.currentRect.height;
        }

        /*
         * WARNING - void declaration
         */
        public void putDVHHeader(Collection<String> collection) {
            boolean bl2 = false;
            Font font = this.g2d.getFont();
            float f2 = 1.0f;
            while (!bl2) {
                void var9_13;
                Object object2;
                this.g2d.setFont(font.deriveFont(1, font.getSize2D() * f2));
                FontMetrics fontMetrics = this.g2d.getFontMetrics();
                ArrayList arrayList = Lists.newArrayList();
                int n2 = this.currentRect.width - 10;
                for (String object22 : collection) {
                    object2 = MIMSwingUtils.b(object22, n2, fontMetrics);
                    if (MIMSwingUtils.a((String[])object2, fontMetrics) > n2) {
                        object2 = MIMSwingUtils.a(object22, n2, fontMetrics);
                    }
                    for (String string : object2) {
                        arrayList.add(string);
                    }
                }
                int n3 = 0;
                for (Object object2 : arrayList) {
                    n3 = (int)((double)n3 + fontMetrics.getStringBounds((String)object2, this.g2d).getHeight());
                }
                if (n3 > this.remainingHeight) {
                    if (this.currentPage == 0 || this.currentRect.height != this.remainingHeight) {
                        this.nextRect();
                        continue;
                    }
                    f2 *= 0.75f;
                    continue;
                }
                int n4 = this.currentRect.y + this.currentRect.height - this.remainingHeight;
                object2 = arrayList.iterator();
                while (object2.hasNext()) {
                    String string = (String)object2.next();
                    Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, this.g2d);
                    PositionedText positionedText = new PositionedText();
                    positionedText.text = string;
                    positionedText.bold = true;
                    positionedText.size = this.g2d.getFont().getSize2D();
                    positionedText.position = new Point2D.Float(this.currentRect.x + 5, (float)(var9_13 + fontMetrics.getAscent()));
                    this.textPositions.put((Object)this.currentPage, (Object)positionedText);
                    var9_13 += (int)Math.ceil(rectangle2D.getHeight());
                }
                this.remainingHeight = this.currentRect.y + this.currentRect.height - var9_13;
                bl2 = true;
            }
            this.g2d.setFont(font);
        }

        public void putDVHBlock(String string, DvhLineStyle dvhLineStyle, Color color, List<String> list) {
            boolean bl2 = false;
            Font font = this.g2d.getFont();
            float f2 = 1.0f;
            while (!bl2) {
                PositionedText positionedText;
                Rectangle2D rectangle2D;
                int n2;
                Object object;
                this.g2d.setFont(font.deriveFont(1, font.getSize2D() * f2));
                FontMetrics fontMetrics = this.g2d.getFontMetrics();
                int n3 = this.currentRect.width - 10;
                int n4 = n3 - 36 - 5;
                int n5 = 0;
                String[] stringArray = MIMSwingUtils.b(string, n4, fontMetrics);
                if (MIMSwingUtils.a(stringArray, fontMetrics) > n4) {
                    stringArray = MIMSwingUtils.a(string, n4, fontMetrics);
                }
                for (String string2 : stringArray) {
                    n5 = (int)((double)n5 + fontMetrics.getStringBounds(string2, this.g2d).getHeight());
                }
                this.g2d.setFont(font.deriveFont(font.getSize2D() * 0.8f * f2));
                fontMetrics = this.g2d.getFontMetrics();
                ArrayList arrayList = Lists.newArrayList();
                Object object2 = null;
                for (String string2 : list) {
                    if (object2 == null) {
                        object2 = string2;
                        continue;
                    }
                    object = (String)object2 + ", " + string2;
                    if (fontMetrics.getStringBounds((String)object, this.g2d).getWidth() > (double)n3) {
                        arrayList.add(object2);
                        object2 = string2;
                        continue;
                    }
                    object2 = object;
                }
                arrayList.add(object2);
                double d2 = -1.0;
                object = arrayList.iterator();
                while (object.hasNext()) {
                    String string3 = (String)object.next();
                    String[] stringArray2 = fontMetrics.getStringBounds(string3, this.g2d);
                    n5 = (int)((double)n5 + stringArray2.getHeight());
                    d2 = Math.max(d2, stringArray2.getWidth());
                }
                if (n5 > this.remainingHeight) {
                    if (this.currentPage == 0 || this.currentRect.height != this.remainingHeight) {
                        this.nextRect();
                        continue;
                    }
                    f2 *= 0.75f;
                    continue;
                }
                int n6 = n2 = this.currentRect.y + this.currentRect.height - this.remainingHeight;
                this.g2d.setFont(font.deriveFont(1, font.getSize2D() * f2));
                fontMetrics = this.g2d.getFontMetrics();
                for (String string4 : stringArray) {
                    rectangle2D = fontMetrics.getStringBounds(string4, this.g2d);
                    positionedText = new PositionedText();
                    positionedText.text = string4;
                    positionedText.size = this.g2d.getFont().getSize2D();
                    positionedText.bold = true;
                    positionedText.position = new Point2D.Float(this.currentRect.x + 36 + 10, n2 + fontMetrics.getAscent());
                    this.textPositions.put((Object)this.currentPage, (Object)positionedText);
                    n2 += (int)Math.ceil(rectangle2D.getHeight());
                }
                int n7 = n6 + (n2 - n6) / 2;
                PositionedStroke positionedStroke = new PositionedStroke();
                positionedStroke.stroke = dvhLineStyle.getStroke();
                positionedStroke.color = color;
                positionedStroke.line = new Line2D.Float(this.currentRect.x + 5, n7, this.currentRect.x + 5 + 36, n7);
                this.strokePositions.put((Object)this.currentPage, (Object)positionedStroke);
                this.g2d.setFont(font.deriveFont((float)font.getSize() * 0.8f * f2));
                fontMetrics = this.g2d.getFontMetrics();
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    String string4;
                    string4 = (String)iterator.next();
                    rectangle2D = fontMetrics.getStringBounds(string4, this.g2d);
                    positionedText = new PositionedText();
                    positionedText.text = string4;
                    positionedText.size = this.g2d.getFont().getSize2D();
                    positionedText.position = new Point2D.Float(this.currentRect.x + 5, n2 + fontMetrics.getAscent());
                    this.textPositions.put((Object)this.currentPage, (Object)positionedText);
                    n2 += (int)Math.ceil(rectangle2D.getHeight());
                }
                this.remainingHeight = this.currentRect.y + this.currentRect.height - n2;
                bl2 = true;
            }
            this.g2d.setFont(font);
        }

        private void nextRect() {
            if (this.currentRects.hasNext()) {
                this.currentRect = this.currentRects.next();
            } else {
                ++this.currentPage;
                this.currentRects = DVHPrinter.this.getLegendAreasForPage(this.page, this.currentPage).iterator();
                this.currentRect = this.currentRects.next();
            }
            this.remainingHeight = this.currentRect.height;
        }

        public int getNumberOfPages() {
            return this.currentPage + 1;
        }
    }

    class PositionedStroke {
        Stroke stroke;
        Color color;
        Line2D.Float line;

        PositionedStroke() {
        }
    }

    class PositionedText {
        String text;
        Point2D.Float position;
        boolean bold = false;
        float size;

        PositionedText() {
        }
    }
}

