/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.google.common.collect.Lists;
import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.dicom.rtdose.ReferencedRoi;
import com.mimvista.mui.overlays.SimpleVolumetricContourOverlayishBase;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public abstract class DVHProducer {
    protected final WeakReference<SimpleVolumetricContourOverlayishBase> vcob;
    protected final boolean mimGenerated = false;

    public abstract DoseVolumeHistogram getDVH();

    public DVHProducer(SimpleVolumetricContourOverlayishBase simpleVolumetricContourOverlayishBase) {
        this.vcob = simpleVolumetricContourOverlayishBase == null ? null : new WeakReference<SimpleVolumetricContourOverlayishBase>(simpleVolumetricContourOverlayishBase);
    }

    public boolean isMIMGenerated() {
        return true;
    }

    public String getName() {
        return this.getNameForReporting();
    }

    public String getNameForReporting() {
        ArrayList arrayList = new ArrayList();
        if (this.getGeneratedFrom() != null) {
            arrayList = Lists.newArrayList((Object[])new ReferencedRoi[]{ReferencedRoi.defaultFromVco(this.getGeneratedFrom())});
        } else if (this.getDVH() != null && this.getDVH().getNumberOfReferencedRois() > 0) {
            arrayList = Lists.newArrayList(this.getDVH().getRois());
        }
        if (!arrayList.isEmpty()) {
            return DoseVolumeHistogram.getNameForReportingFromRois(arrayList);
        }
        return "";
    }

    public SimpleVolumetricContourOverlayishBase getGeneratedFrom() {
        return this.vcob == null ? null : (SimpleVolumetricContourOverlayishBase)this.vcob.get();
    }

    public static DVHProducer supply(final DoseVolumeHistogram doseVolumeHistogram) {
        return new DVHProducer(doseVolumeHistogram.getGeneratedFrom()){

            @Override
            public DoseVolumeHistogram getDVH() {
                return doseVolumeHistogram;
            }

            @Override
            public boolean isMIMGenerated() {
                return doseVolumeHistogram.isMIMGenerated();
            }
        };
    }
}

