/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.mimvista.dicom.rtdose.gui.DVHDisplayParams;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.swing.DelayedActionRunner;
import com.mimvista.util.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DVHSearchPanel
extends JPanel {
    private static final long serialVersionUID = -4779493492136272587L;
    private final DVHDisplayParams dvhParams;
    private JTextField searchBox;
    Set<FuncUtils.m<String>> textListeners = new HashSet<FuncUtils.m<String>>();

    public DVHSearchPanel(final DVHDisplayParams dVHDisplayParams) {
        super(new BorderLayout());
        this.dvhParams = dVHDisplayParams;
        this.setBorder(BorderFactory.createTitledBorder(Messages.a("DVH").getProperty("DVH_SEARCH")));
        this.searchBox = new JTextField();
        this.searchBox.getDocument().addDocumentListener(this.getSearchListener());
        this.add((Component)this.searchBox, "Center");
        JButton jButton = new JButton();
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                DVHSearchPanel.this.searchBox.setText("");
                DVHSearchPanel.this.fireZeListeners();
            }
        });
        jButton.setIcon(ImageManipulator.c("x_red.svg", 16, 16));
        this.add((Component)jButton, "East");
        this.addListener(new FuncUtils.m<String>(){

            @Override
            public void doIt(String string) {
                dVHDisplayParams.filterDVHsBasedOnSearch(string);
            }
        });
    }

    private DocumentListener getSearchListener() {
        return new DocumentListener(){
            DelayedActionRunner refreshDelayer = new DelayedActionRunner(100, new Runnable(){

                @Override
                public void run() {
                    DVHSearchPanel.this.fireZeListeners();
                }
            });

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.removeUpdate(documentEvent);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.removeUpdate(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.refreshDelayer.b();
            }
        };
    }

    public void addListener(FuncUtils.m<String> m2) {
        this.textListeners.add(m2);
    }

    public void removeListener(FuncUtils.m<String> m2) {
        this.textListeners.remove(m2);
    }

    private void fireZeListeners() {
        for (FuncUtils.m<String> m2 : this.textListeners) {
            m2.doIt(this.searchBox.getText());
        }
    }

    public void setText(String string) {
        this.searchBox.setText(string);
        this.fireZeListeners();
    }
}

