/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.mimvista.d;
import com.mimvista.dicom.rtdose.gui.DVHTableModel;
import com.mimvista.internals.statistics.Statistician;
import com.mimvista.report.data.b.f;
import com.mimvista.report.data.overlay.ReportableContour;
import com.mimvista.util.Messages;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.List;

public class DVHTableColumnModel
extends DVHTableModel {
    private static final long serialVersionUID = 1625296626249068251L;

    public DVHTableColumnModel(f f2) {
        this(f2, true, null, null, null);
    }

    public DVHTableColumnModel(f f2, boolean bl2, @d List<ReportableContour> list, @d Statistician.e e2, @d List<BigDecimal> list2) {
        super(f2, true, false, list, e2, list2);
    }

    @Override
    public int getRowCount() {
        int n2 = 0;
        if (this.dvhData != null) {
            n2 += this.dvhData.columnHeaders.length;
        }
        if (this.confData != null) {
            n2 += this.confData.columnHeaders.length;
        }
        return n2;
    }

    @Override
    public int getColumnCount() {
        return this.contours.size() + 1;
    }

    @Override
    public Class<?> getColumnClass(int n2) {
        if (n2 == 0) {
            return String[].class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int n2) {
        if (n2 == 0) {
            return Messages.a("Dose").getProperty("DOSE_PANEL_TITLE");
        }
        if (n2 > 0 && n2 <= this.contours.size()) {
            return ((ReportableContour)this.contours.get(n2 - 1)).getName();
        }
        return null;
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        int n4;
        int n5 = n4 = this.dvhData != null ? this.dvhData.columnHeaders.length : 0;
        if (n3 == 0) {
            if (this.dvhData != null && n2 >= 0 && n2 < this.dvhData.columnHeaders.length) {
                String string = this.dvhData.columnHeaders[n2];
                String[] stringArray = string.split("\\\\");
                return stringArray;
            }
            if (this.confData != null && n2 >= n4 && n2 < this.confData.columnHeaders.length + n4) {
                return new String[]{this.confData.columnHeaders[n2 - n4]};
            }
        } else if (n3 > 0 && n3 <= this.contours.size()) {
            double d2;
            if (this.dvhData != null && n2 >= 0 && n2 < this.dvhData.columnHeaders.length) {
                double d3 = this.dvhData.contourPcts.get(n3 - 1)[n2];
                double d4 = this.dvhData.contourVals.get(n3 - 1)[n2];
                if (!Double.isNaN(d3) && !Double.isNaN(d4)) {
                    NumberFormat numberFormat = DVHTableColumnModel.getNumberFormat();
                    return new String[]{numberFormat.format(d3), numberFormat.format(d4)};
                }
            } else if (this.confData != null && n2 >= n4 && n2 < this.confData.columnHeaders.length + n4 && !Double.isNaN(d2 = this.confData.contourVals.get(n3 - 1)[n2 - n4])) {
                return DVHTableColumnModel.getNumberFormat().format(d2);
            }
            return "-";
        }
        return null;
    }
}

