/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.google.common.collect.Lists;
import com.mimvista.brachytherapy.report.a.a;
import com.mimvista.d;
import com.mimvista.dicom.rtdose.DoseValue;
import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.internals.statistics.IsodoseStatistician;
import com.mimvista.internals.statistics.OverlayStatistician;
import com.mimvista.internals.statistics.Statistician;
import com.mimvista.mui.overlays.Overlayish;
import com.mimvista.preferencesNew.DosePrefs;
import com.mimvista.report.data.b.f;
import com.mimvista.report.data.overlay.ReportableContour;
import com.mimvista.util.Messages;
import com.mimvista.util.NumberFormatFactory;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public abstract class DVHTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    protected List<ReportableContour> contours = Lists.newArrayList();
    public final f dose;
    protected DVHColumnData dvhData = null;
    protected ConformityColumnData confData = null;
    protected boolean percentVolume = true;
    protected OverlayStatistician.e statListener;
    protected boolean isUserSelected = false;
    protected List<ReportableContour> userSelectedContours;
    protected boolean includeUnitsInColumnHeaders = true;
    protected List<BigDecimal> highlightedRows = Lists.newArrayList();

    public DVHTableModel(f f2) {
        this(f2, true, true, null, null, null);
    }

    public DVHTableModel(f f2, boolean bl2, boolean bl3, @d List<ReportableContour> list, @d Statistician.e e2, @d List<BigDecimal> list2) {
        this.dose = f2;
        this.percentVolume = bl2;
        this.includeUnitsInColumnHeaders = bl3;
        if (list != null) {
            this.isUserSelected = true;
            this.userSelectedContours = list;
        }
        if (list2 != null) {
            this.highlightedRows.addAll(list2);
        }
        this.statListener = new RebuildStatsListener(this);
        f2.b().a(this.statListener);
        this.rebuild(e2);
    }

    public void setShowUnitsInColumns(boolean bl2) {
        this.includeUnitsInColumnHeaders = bl2;
        this.rebuild(null);
    }

    public void cleanup() {
        this.dose.b().c(this.statListener);
    }

    public boolean isNormalizedVolume() {
        return this.percentVolume;
    }

    public void rebuild() {
        MIMSwingUtils.a(new Runnable(){

            @Override
            public void run() {
                DVHTableModel.this.rebuild(null);
                DVHTableModel.this.fireTableRowsUpdated(0, DVHTableModel.this.getRowCount() - 1);
            }
        });
    }

    public void setNormalizeVolume(boolean bl2) {
        if (bl2 != this.percentVolume) {
            this.percentVolume = bl2;
            MIMSwingUtils.a(new Runnable(){

                @Override
                public void run() {
                    DVHTableModel.this.rebuild(null);
                    DVHTableModel.this.fireTableRowsUpdated(0, DVHTableModel.this.getRowCount() - 1);
                }
            });
        }
    }

    public void setUserSelectedContours(List<? extends ReportableContour> list) {
        if (this.isUserSelected && list.equals(this.userSelectedContours)) {
            return;
        }
        this.userSelectedContours = Lists.newArrayList(list);
        this.isUserSelected = true;
        MIMSwingUtils.a(new Runnable(){

            @Override
            public void run() {
                DVHTableModel.this.rebuild(null);
            }
        });
    }

    public List<? extends ReportableContour> getUserSelectedContours() {
        return Lists.newArrayList(this.userSelectedContours);
    }

    public void setHighlightedRows(List<BigDecimal> list) {
        this.highlightedRows.clear();
        this.highlightedRows.addAll(list);
    }

    public List<BigDecimal> getHighlightedRows() {
        return Lists.newArrayList(this.highlightedRows);
    }

    public void highlightRow(BigDecimal bigDecimal, boolean bl2) {
        if (bl2 && !this.highlightedRows.contains(bigDecimal)) {
            this.highlightedRows.add(bigDecimal);
        } else if (!bl2) {
            this.highlightedRows.remove(bigDecimal);
        }
    }

    public int getNumberOfDoseRows() {
        if (this.dvhData != null) {
            return this.dvhData.columnHeaders.length;
        }
        return 0;
    }

    private List<? extends ReportableContour> getAvaliableContourList() {
        return this.dose.getVolume().m().c();
    }

    private boolean setContourList(List<? extends ReportableContour> list) {
        ArrayList arrayList = Lists.newArrayList();
        for (ReportableContour reportableContour : list) {
            if (!this.dose.b().a(reportableContour)) continue;
            arrayList.add(reportableContour);
        }
        boolean bl2 = !arrayList.equals(this.contours);
        this.contours = arrayList;
        return bl2;
    }

    private void rebuild(@d Statistician.e e2) {
        boolean bl2 = this.isUserSelected ? this.setContourList(this.userSelectedContours) : this.setContourList(this.getAvaliableContourList());
        if (e2 == null) {
            e2 = this.dose.b().d();
        }
        double[] dArray = this.getDoseVals();
        DVHColumnData dVHColumnData = this.generateDVHData(this.contours, dArray, this.dvhData, e2);
        ConformityColumnData conformityColumnData = this.generateConformityData(this.contours, e2);
        boolean bl3 = this.dvhData == null || !Arrays.equals(this.dvhData.columnHeaders, dVHColumnData.columnHeaders) || this.confData == null || !Arrays.equals(this.confData.columnHeaders, conformityColumnData.columnHeaders);
        boolean bl4 = false;
        if (bl2 || bl3 || !dVHColumnData.valuesEqual(this.dvhData) || !conformityColumnData.valuesEqual(this.confData)) {
            bl4 = true;
        }
        this.dvhData = dVHColumnData;
        this.confData = conformityColumnData;
        if (bl3) {
            this.fireTableStructureChanged();
        } else if (bl2) {
            this.fireTableDataChanged();
        } else if (bl4) {
            this.fireTableRowsUpdated(0, this.contours.size() - 1);
        }
    }

    private double[] getDoseVals() {
        double d2 = this.dose.getRxDose().getValueInGy();
        BigDecimal bigDecimal = DosePrefs.getDvhTablePercentStepSizeAsProperRawPercentOrAsGraysIfPercentsAreGrays();
        boolean bl2 = DosePrefs.dvhTablePercentsAreGrays.getValue();
        return a.a(bigDecimal, d2, bl2);
    }

    protected static NumberFormat getNumberFormat() {
        return NumberFormatFactory.a();
    }

    private DVHColumnData generateDVHData(List<ReportableContour> list, double[] dArray, DVHColumnData dVHColumnData, Statistician.e e2) {
        String[] stringArray = new String[dArray.length];
        NumberFormat numberFormat = DVHTableModel.getNumberFormat();
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            double d2 = dArray[i2] * 100.0 / (double)this.dose.getRxDose().getValueInGy();
            DoseValue doseValue = new DoseValue();
            doseValue.setValueInGy((float)dArray[i2]);
            stringArray[i2] = this.includeUnitsInColumnHeaders ? numberFormat.format(d2) + "% Rx\\" + numberFormat.format(doseValue.getValueInCurrentUnit()) + DoseValue.doseUnit.name() : numberFormat.format(d2) + "\\" + numberFormat.format(doseValue.getValueInCurrentUnit());
        }
        ArrayList arrayList = Lists.newArrayList();
        ArrayList arrayList2 = Lists.newArrayList();
        IsodoseStatistician.e e3 = e2.a(IsodoseStatistician.b);
        int n2 = -1;
        boolean bl2 = false;
        for (ReportableContour reportableContour : list) {
            DoseVolumeHistogram doseVolumeHistogram;
            double[] dArray2 = new double[dArray.length];
            double[] dArray3 = new double[dArray.length];
            DoseVolumeHistogram doseVolumeHistogram2 = doseVolumeHistogram = e3 != null ? e3.a().get(reportableContour) : null;
            if (doseVolumeHistogram != null) {
                bl2 = true;
                double d3 = doseVolumeHistogram.getMaxVolume();
                for (int i3 = 0; i3 < dArray.length; ++i3) {
                    double d4 = doseVolumeHistogram.getInterpolatedMLValue(dArray[i3]);
                    if (d4 > 0.001) {
                        n2 = Math.max(n2, i3);
                    }
                    dArray3[i3] = d4 * 100.0 / d3;
                    dArray2[i3] = d4;
                }
            } else {
                for (int i4 = 0; i4 < dArray.length; ++i4) {
                    dArray3[i4] = Double.NaN;
                    dArray2[i4] = Double.NaN;
                }
            }
            arrayList2.add(dArray2);
            arrayList.add(dArray3);
        }
        if (!bl2 && dVHColumnData != null && dVHColumnData.columnHeaders != null && dVHColumnData.columnHeaders.length > 0 && dVHColumnData.columnHeaders.length <= stringArray.length) {
            boolean bl3 = true;
            for (int i5 = 0; i5 < dVHColumnData.columnHeaders.length; ++i5) {
                if (dVHColumnData.columnHeaders[i5].equals(stringArray[i5])) continue;
                bl3 = false;
                break;
            }
            if (bl3) {
                n2 = Math.max(0, dVHColumnData.columnHeaders.length - 2);
            }
        }
        stringArray = Arrays.copyOf(stringArray, Math.min(stringArray.length, n2 + 2));
        for (int i6 = 0; i6 < arrayList2.size(); ++i6) {
            double[] dArray4 = (double[])arrayList2.get(i6);
            arrayList2.set(i6, Arrays.copyOf(dArray4, Math.min(dArray4.length, n2 + 2)));
            dArray4 = (double[])arrayList.get(i6);
            arrayList.set(i6, Arrays.copyOf(dArray4, Math.min(dArray4.length, n2 + 2)));
        }
        DVHColumnData dVHColumnData2 = new DVHColumnData();
        dVHColumnData2.columnHeaders = stringArray;
        dVHColumnData2.contourVals = arrayList2;
        dVHColumnData2.contourPcts = arrayList;
        return dVHColumnData2;
    }

    private ConformityColumnData generateConformityData(List<ReportableContour> list, Statistician.e e2) {
        ConformityColumnData conformityColumnData = new ConformityColumnData();
        Messages messages = Messages.a("Dose");
        conformityColumnData.columnHeaders = new String[]{messages.b("CI"), messages.b("NCI"), messages.b("HI")};
        conformityColumnData.contourVals = Lists.newArrayListWithCapacity((int)list.size());
        IsodoseStatistician.b b2 = e2.a(IsodoseStatistician.d);
        IsodoseStatistician.b b3 = e2.a(IsodoseStatistician.e);
        IsodoseStatistician.b b4 = e2.a(IsodoseStatistician.f);
        for (ReportableContour reportableContour : list) {
            Double d2;
            Double d3;
            Double d4;
            double[] dArray = new double[]{Double.NaN, Double.NaN, Double.NaN};
            Double d5 = d4 = b2 != null ? b2.a().get(reportableContour) : null;
            if (d4 != null) {
                dArray[0] = d4;
            }
            Double d6 = d3 = b3 != null ? b3.a().get(reportableContour) : null;
            if (d3 != null) {
                dArray[1] = d3;
            }
            Double d7 = d2 = b4 != null ? b4.a().get(reportableContour) : null;
            if (d2 != null) {
                dArray[2] = d2;
            }
            conformityColumnData.contourVals.add(dArray);
        }
        return conformityColumnData;
    }

    private static class RebuildStatsListener
    extends OverlayStatistician.e {
        private WeakReference<DVHTableModel> modelRef;

        public RebuildStatsListener(DVHTableModel dVHTableModel) {
            this.modelRef = new WeakReference<DVHTableModel>(dVHTableModel);
        }

        @Override
        public void finishedComputingStatistics(Overlayish overlayish) {
            MIMSwingUtils.a(new Runnable(){

                @Override
                public void run() {
                    DVHTableModel dVHTableModel = (DVHTableModel)modelRef.get();
                    if (dVHTableModel != null) {
                        dVHTableModel.rebuild(null);
                    }
                }
            });
        }

        @Override
        public void statsDirtied(Overlayish overlayish) {
            MIMSwingUtils.a(new Runnable(){

                @Override
                public void run() {
                    DVHTableModel dVHTableModel = (DVHTableModel)modelRef.get();
                    if (dVHTableModel != null) {
                        dVHTableModel.rebuild(null);
                    }
                }
            });
        }
    }

    protected static class ConformityColumnData {
        String[] columnHeaders;
        List<double[]> contourVals;

        protected ConformityColumnData() {
        }

        boolean valuesEqual(ConformityColumnData conformityColumnData) {
            if (conformityColumnData == null) {
                return false;
            }
            if (this.contourVals.size() != conformityColumnData.contourVals.size()) {
                return false;
            }
            for (int i2 = 0; i2 < this.contourVals.size(); ++i2) {
                if (Arrays.equals(this.contourVals.get(i2), conformityColumnData.contourVals.get(i2))) continue;
                return false;
            }
            return true;
        }
    }

    protected static class DVHColumnData {
        String[] columnHeaders;
        List<double[]> contourVals;
        List<double[]> contourPcts;

        protected DVHColumnData() {
        }

        boolean valuesEqual(DVHColumnData dVHColumnData) {
            int n2;
            if (dVHColumnData == null) {
                return false;
            }
            if (this.contourPcts.size() != dVHColumnData.contourPcts.size()) {
                return false;
            }
            for (n2 = 0; n2 < this.contourPcts.size(); ++n2) {
                if (Arrays.equals(this.contourPcts.get(n2), dVHColumnData.contourPcts.get(n2))) continue;
                return false;
            }
            if (this.contourVals.size() != dVHColumnData.contourVals.size()) {
                return false;
            }
            for (n2 = 0; n2 < this.contourVals.size(); ++n2) {
                if (Arrays.equals(this.contourVals.get(n2), dVHColumnData.contourVals.get(n2))) continue;
                return false;
            }
            return true;
        }
    }
}

