/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.mimvista.d;
import com.mimvista.dicom.rtdose.gui.DVHTableModel;
import com.mimvista.internals.statistics.OverlayStatistician;
import com.mimvista.internals.statistics.Statistician;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.report.data.b.f;
import com.mimvista.util.Messages;

public class DVHTableRowModel
extends DVHTableModel {
    private static final long serialVersionUID = 5670822611350932647L;

    public DVHTableRowModel(f f2, @d Statistician.e e2) {
        super(f2, true, true, null, e2, null);
    }

    @Override
    public int getRowCount() {
        return this.contours.size();
    }

    @Override
    public int getColumnCount() {
        int n2 = 1;
        if (this.dvhData != null) {
            n2 += this.dvhData.columnHeaders.length;
        }
        if (this.confData != null) {
            n2 += this.confData.columnHeaders.length;
        }
        return n2;
    }

    @Override
    public Class<?> getColumnClass(int n2) {
        if (n2 == 0) {
            return VolumetricContourOverlayish.class;
        }
        return SortableValueWrapper.class;
    }

    @Override
    public String getColumnName(int n2) {
        int n3;
        int n4 = n3 = this.dvhData != null ? 1 + this.dvhData.columnHeaders.length : 1;
        if (n2 == 0) {
            return Messages.a("General", "CONTOUR_OVERLAY");
        }
        if (this.dvhData != null && n2 >= 1 && n2 < this.dvhData.columnHeaders.length + 1) {
            String string = this.dvhData.columnHeaders[n2 - 1];
            String[] stringArray = string.split("\\\\");
            String string2 = "<html><body><p align=\"center\">";
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (i2 > 0) {
                    string2 = string2 + "<br/>";
                }
                string2 = string2 + stringArray[i2];
            }
            string2 = string2 + "</p></body></html>";
            return string2;
        }
        if (this.confData != null && n2 >= n3 && n2 < this.confData.columnHeaders.length + n3) {
            return this.confData.columnHeaders[n2 - n3];
        }
        return null;
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        int n4;
        int n5 = n4 = this.dvhData != null ? 1 + this.dvhData.columnHeaders.length : 1;
        if (n3 == 0) {
            if (n2 >= 0 && n2 < this.contours.size()) {
                return this.contours.get(n2);
            }
        } else {
            if (this.dvhData != null && n3 >= 1 && n3 < this.dvhData.columnHeaders.length + 1) {
                if (n2 >= 0 && n2 < this.dvhData.contourVals.size()) {
                    double[] dArray;
                    double[] dArray2 = dArray = this.percentVolume ? this.dvhData.contourPcts.get(n2) : this.dvhData.contourVals.get(n2);
                    if (!Double.isNaN(dArray[n3 - 1])) {
                        String string = this.percentVolume ? "%" : OverlayStatistician.t();
                        return new SortableValueWrapper(dArray[n3 - 1], string);
                    }
                }
                return "-";
            }
            if (this.confData != null && n3 >= n4 && n3 < this.confData.columnHeaders.length + n4) {
                double d2;
                if (n2 >= 0 && n2 < this.confData.contourVals.size() && !Double.isNaN(d2 = this.confData.contourVals.get(n2)[n3 - n4])) {
                    return new SortableValueWrapper(d2, null);
                }
                return new SortableValueWrapper(null, null);
            }
        }
        return null;
    }

    private static class SortableValueWrapper
    implements Comparable<SortableValueWrapper> {
        private Double value;
        private String unit;

        public SortableValueWrapper(Double d2, String string) {
            this.value = d2;
            this.unit = string;
        }

        public String toString() {
            if (this.value == null) {
                return "-";
            }
            if (this.unit != null) {
                return DVHTableModel.getNumberFormat().format(this.value) + this.unit;
            }
            return DVHTableModel.getNumberFormat().format(this.value);
        }

        @Override
        public int compareTo(SortableValueWrapper sortableValueWrapper) {
            if (this.value == null) {
                if (sortableValueWrapper.value == null) {
                    return 0;
                }
                return -1;
            }
            if (sortableValueWrapper.value == null) {
                return 1;
            }
            return Double.compare(this.value, sortableValueWrapper.value);
        }
    }
}

