/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.dicom.rtdose.DVHCollection;
import com.mimvista.dicom.rtdose.DVHGeneratorFactory;
import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.dicom.rtdose.ReferencedRoi;
import com.mimvista.dicom.rtdose.gui.DVHDisplayParams;
import com.mimvista.dicom.rtdose.gui.DVHProducer;
import com.mimvista.dicom.rtdose.gui.DvhDisplayInfo;
import com.mimvista.dicom.rtdose.gui.DvhDisplayUpdateHandler;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.statistics.IsodoseStatistician;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.mui.overlays.IsodoseOverlay;
import com.mimvista.mui.overlays.OverlayCollection;
import com.mimvista.mui.overlays.Overlayish;
import com.mimvista.mui.overlays.SimpleVolumetricContourOverlayishBase;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.mui.overlays.y;
import com.mimvista.report.gui.content.dvhPlot.d;
import com.mimvista.swing.DelayedActionRunner;
import com.mimvista.util.ay;
import com.mimvista.viewer.RTDoseSeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class DVHUpdateListener
extends DvhDisplayUpdateHandler {
    private final DVHDisplayParams params;
    private Map<ViewController, OverlayCollection.a> vcListenerMap = Maps.newHashMap();
    private final RxAndNameChangeListener rxAndOrNameChangedListener = new RxAndNameChangeListener(this);
    private Map<IsodoseOverlay, y> doseCloseListeners = Maps.newHashMap();
    private y ovListener = new y(){

        @Override
        public void overlayRemoved(Overlayish overlayish) {
            DVHUpdateListener.this.updateDVHs();
        }

        @Override
        public void overlayMetadataChanged(Overlayish overlayish) {
            for (DVHCollection dVHCollection : DVHUpdateListener.this.getCurrentCollections()) {
                for (DvhDisplayInfo dvhDisplayInfo : dVHCollection.getDvhDisplayInfo()) {
                    DoseVolumeHistogram doseVolumeHistogram = dvhDisplayInfo.getDVH();
                    SimpleVolumetricContourOverlayishBase simpleVolumetricContourOverlayishBase = doseVolumeHistogram.getGeneratedFrom();
                    if (simpleVolumetricContourOverlayishBase != overlayish) continue;
                    doseVolumeHistogram.updateRoiIfSingle(ReferencedRoi.defaultFromVco(simpleVolumetricContourOverlayishBase));
                    dvhDisplayInfo.setColor(overlayish.bn_(), false);
                }
            }
            DVHUpdateListener.this.dvhMetadataChanged();
            DVHUpdateListener.this.params.updateFilteredDVHs();
        }
    };
    private DelayedActionRunner updateDar = new DelayedActionRunner(100, new Runnable(){

        @Override
        public void run() {
            DVHUpdateListener.this.updateDVHsImmediately();
        }
    });

    public abstract void dvhMetadataChanged();

    public DVHUpdateListener(DVHDisplayParams dVHDisplayParams) {
        this.params = dVHDisplayParams;
        this.attachToDoseAndContours();
    }

    private y createCloseListener(final IsodoseOverlay isodoseOverlay) {
        return new y(){

            @Override
            public void overlayRemoved(Overlayish overlayish) {
                ArrayList arrayList = Lists.newArrayList();
                try {
                    ArrayList arrayList2 = Lists.newArrayList(DVHUpdateListener.this.getCurrentCollections());
                    for (DVHCollection dVHCollection : arrayList2) {
                        if (isodoseOverlay.C() != dVHCollection.getDoseVolume()) continue;
                        isodoseOverlay.h().a(this);
                        ArrayList arrayList3 = Lists.newArrayList();
                        for (DoseVolumeHistogram doseVolumeHistogram : dVHCollection.getDVHs()) {
                            if (!doseVolumeHistogram.isMIMGenerated()) continue;
                            arrayList3.add(doseVolumeHistogram);
                        }
                        dVHCollection.removeAll(arrayList3);
                        arrayList.add(dVHCollection);
                    }
                }
                catch (Throwable throwable) {
                    ay.d((Object)"Error updating the DVH window", throwable, this.getClass());
                    arrayList.clear();
                }
                DVHUpdateListener.this.params.removeDVHCollections(arrayList);
            }
        };
    }

    private void addIsodoseListeners(IsodoseOverlay isodoseOverlay) {
        this.rxAndOrNameChangedListener.registerOnDose(isodoseOverlay);
        y y2 = this.doseCloseListeners.get(isodoseOverlay);
        if (y2 == null) {
            y2 = this.createCloseListener(isodoseOverlay);
            this.doseCloseListeners.put(isodoseOverlay, y2);
        }
        isodoseOverlay.b(y2);
    }

    @Override
    public void attachToDoseAndContours() {
        for (DVHCollection dVHCollection : this.getCurrentCollections()) {
            Object object;
            Object object2;
            IsodoseOverlay isodoseOverlay = this.findDoseOverlayFor(dVHCollection);
            if (isodoseOverlay == null) continue;
            this.addIsodoseListeners(isodoseOverlay);
            ArrayList arrayList = Lists.newArrayList();
            isodoseOverlay.h().a(this);
            dVHCollection.addIsodoseInformation(isodoseOverlay);
            for (DVHProducer dVHProducer : dVHCollection.getDVHProducers()) {
                object2 = (VolumetricContourOverlayish)dVHProducer.getGeneratedFrom();
                if (!this.isContourValid((VolumetricContourOverlayish)object2)) continue;
                isodoseOverlay.h().a(this, (VolumetricContourOverlayish)object2, true);
                object2.b(this.ovListener);
                object = object2.au();
                if (arrayList.contains(object)) continue;
                arrayList.add(object);
            }
            for (ViewController viewController : arrayList) {
                if (this.vcListenerMap.containsKey(viewController)) continue;
                object2 = viewController.ba();
                object = new DVHUpdateOCListener(this, (OverlayCollection)object2, isodoseOverlay);
                viewController.ba().b((OverlayCollection.a)object);
                this.vcListenerMap.put(viewController, (OverlayCollection.a)object);
            }
        }
    }

    @Override
    public void cleanup() {
        for (DVHCollection object : this.getCurrentCollections()) {
            IsodoseOverlay isodoseOverlay = this.findDoseOverlayFor(object);
            if (isodoseOverlay != null) {
                isodoseOverlay.h().b(this);
                isodoseOverlay.h().a((Object)this);
                y y2 = this.doseCloseListeners.get(isodoseOverlay);
                if (y2 != null) {
                    isodoseOverlay.c(y2);
                }
            }
            for (DoseVolumeHistogram doseVolumeHistogram : object.getDVHs()) {
                VolumetricContourOverlayish volumetricContourOverlayish = (VolumetricContourOverlayish)doseVolumeHistogram.getGeneratedFrom();
                if (volumetricContourOverlayish == null) continue;
                volumetricContourOverlayish.c(this.ovListener);
            }
        }
        this.rxAndOrNameChangedListener.deregisterAll();
        for (ViewController viewController : this.vcListenerMap.keySet()) {
            if (!viewController.bu()) continue;
            viewController.ba().c(this.vcListenerMap.get(viewController));
        }
        this.vcListenerMap.clear();
        this.doseCloseListeners.clear();
    }

    @Override
    public Object getKey() {
        return this;
    }

    @Override
    public void finishedComputingStatistics(Overlayish overlayish) {
        if (this.shouldUpdateDVHCollections(overlayish)) {
            this.updateDVHs();
        }
    }

    private void overlayAddedHandler(Overlayish overlayish, IsodoseOverlay isodoseOverlay) {
        IsodoseOverlay isodoseOverlay2;
        if (overlayish instanceof VolumetricContourOverlayish) {
            VolumetricContourOverlayish volumetricContourOverlayish = (VolumetricContourOverlayish)overlayish;
            if (this.isContourValid(volumetricContourOverlayish) && volumetricContourOverlayish.aq().a() == isodoseOverlay.ao()) {
                overlayish.b(this.ovListener);
                DoseVolumeHistogram doseVolumeHistogram = DVHGeneratorFactory.generate((SimpleVolumetricContourOverlayishBase)volumetricContourOverlayish, isodoseOverlay.C(), null);
                if (doseVolumeHistogram != null) {
                    ArrayList arrayList = Lists.newArrayList();
                    try {
                        ArrayList arrayList2 = Lists.newArrayList(this.getCurrentCollections());
                        for (DVHCollection dVHCollection : arrayList2) {
                            IsodoseOverlay isodoseOverlay3 = this.findDoseOverlayFor(dVHCollection);
                            if (!isodoseOverlay3.equals(isodoseOverlay)) continue;
                            dVHCollection.add(doseVolumeHistogram);
                            DVHCollection dVHCollection2 = this.buildNewDVHCollection(dVHCollection);
                            if (dVHCollection2 != null) {
                                arrayList.add(dVHCollection2);
                            }
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        ay.d((Object)"Error updating the DVH window", throwable, this.getClass());
                        arrayList.clear();
                    }
                    this.params.updateDVHCollections(arrayList);
                }
            }
        } else if (overlayish instanceof IsodoseOverlay && !this.isDoseDuplicate(isodoseOverlay2 = (IsodoseOverlay)overlayish)) {
            DVHCollection dVHCollection = d.a(isodoseOverlay2);
            this.params.addDVHCollection(dVHCollection);
        }
    }

    private boolean isDoseDuplicate(IsodoseOverlay isodoseOverlay) {
        for (DVHCollection dVHCollection : this.getCurrentCollections()) {
            IsodoseOverlay isodoseOverlay2 = this.findDoseOverlayFor(dVHCollection);
            if (isodoseOverlay2 == null) continue;
            SeriesInfo seriesInfo = isodoseOverlay.J();
            SeriesInfo seriesInfo2 = isodoseOverlay2.J();
            if (!seriesInfo.sopInstanceUID.equals(seriesInfo2.sopInstanceUID)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldUpdateDVHCollections(Overlayish overlayish) {
        boolean bl2 = false;
        try {
            if (overlayish instanceof IsodoseOverlay) {
                bl2 = this.doesDoseChangeAffectDVH((IsodoseOverlay)overlayish);
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error checking if the DVH needs updated", throwable, this.getClass());
            bl2 = true;
        }
        return bl2;
    }

    private boolean doesDoseChangeAffectDVH(IsodoseOverlay isodoseOverlay) {
        return this.dosesUsedInDVHCollections().contains(isodoseOverlay);
    }

    private Collection<IsodoseOverlay> dosesUsedInDVHCollections() {
        ArrayList arrayList = Lists.newArrayList(this.getCurrentCollections());
        HashSet<IsodoseOverlay> hashSet = new HashSet<IsodoseOverlay>();
        for (DVHCollection dVHCollection : arrayList) {
            hashSet.add(this.findDoseOverlayFor(dVHCollection));
        }
        return hashSet;
    }

    private boolean isContourValid(VolumetricContourOverlayish volumetricContourOverlayish) {
        return volumetricContourOverlayish != null && !volumetricContourOverlayish.aO() && !volumetricContourOverlayish.aM();
    }

    private void updateDVHs() {
        this.updateDar.b();
    }

    private void updateDVHsImmediately() {
        ArrayList arrayList = Lists.newArrayList();
        try {
            ArrayList arrayList2 = Lists.newArrayList(this.getCurrentCollections());
            for (DVHCollection dVHCollection : arrayList2) {
                IsodoseOverlay isodoseOverlay = this.findDoseOverlayFor(dVHCollection);
                ArrayList arrayList3 = Lists.newArrayList();
                for (DVHProducer dVHProducer : dVHCollection.getDVHProducers()) {
                    VolumetricContourOverlayish volumetricContourOverlayish;
                    if (!dVHProducer.isMIMGenerated() || this.isContourValid(volumetricContourOverlayish = (VolumetricContourOverlayish)dVHProducer.getGeneratedFrom())) continue;
                    arrayList3.add(dVHProducer);
                    if (isodoseOverlay == null || volumetricContourOverlayish == null) continue;
                    isodoseOverlay.h().a((Object)this, volumetricContourOverlayish);
                }
                dVHCollection.removeAll(arrayList3);
                DVHCollection dVHCollection2 = this.buildNewDVHCollection(dVHCollection);
                if (dVHCollection2 == null) {
                    return;
                }
                dVHCollection2.addIsodoseInformation(isodoseOverlay);
                arrayList.add(dVHCollection2);
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error updating the DVH window", throwable, this.getClass());
            arrayList.clear();
        }
        this.params.updateDVHCollections(arrayList);
    }

    private DVHCollection buildNewDVHCollection(DVHCollection dVHCollection) {
        if (!this.wasMIMGenerated(dVHCollection)) {
            return dVHCollection;
        }
        IsodoseOverlay isodoseOverlay = this.findDoseOverlayFor(dVHCollection);
        if (isodoseOverlay == null) {
            return null;
        }
        List<DvhDisplayInfo> list = this.getListOfUpdatedDVHs(isodoseOverlay, dVHCollection);
        if (list.size() > 0) {
            return this.makeCopiedCollectionWithUpdatedDVHs(dVHCollection, list);
        }
        return null;
    }

    private boolean wasMIMGenerated(DVHCollection dVHCollection) {
        for (DVHProducer dVHProducer : dVHCollection.getDVHProducers()) {
            if (dVHProducer.getGeneratedFrom() == null) continue;
            return true;
        }
        return false;
    }

    private List<DvhDisplayInfo> getListOfUpdatedDVHs(IsodoseOverlay isodoseOverlay, DVHCollection dVHCollection) {
        ArrayList arrayList = Lists.newArrayList();
        for (DvhDisplayInfo dvhDisplayInfo : dVHCollection.getDvhDisplayInfo()) {
            DvhDisplayInfo dvhDisplayInfo2 = this.makeNewDVH(isodoseOverlay, dvhDisplayInfo);
            if (dvhDisplayInfo2 != null) {
                arrayList.add(dvhDisplayInfo2);
                continue;
            }
            arrayList.add(dvhDisplayInfo);
        }
        return arrayList;
    }

    private DVHCollection makeCopiedCollectionWithUpdatedDVHs(DVHCollection dVHCollection, List<DvhDisplayInfo> list) {
        DVHCollection dVHCollection2 = dVHCollection.clone();
        dVHCollection2.clear();
        dVHCollection2.addDDIs(list);
        return dVHCollection2;
    }

    private IsodoseOverlay findDoseOverlayFor(DVHCollection dVHCollection) {
        ImageVolumeShort imageVolumeShort = dVHCollection.getVolume();
        if (imageVolumeShort != null) {
            for (IsodoseOverlay isodoseOverlay : imageVolumeShort.n().L()) {
                if (dVHCollection.getDoseVolume() == isodoseOverlay.C()) {
                    return isodoseOverlay;
                }
                if (dVHCollection.getDoseInfo() != isodoseOverlay.getUncopiedMutableInfo()) continue;
                return isodoseOverlay;
            }
            for (IsodoseOverlay isodoseOverlay : imageVolumeShort.n().L()) {
                if (!isodoseOverlay.getUncopiedMutableInfo().ag().equals(dVHCollection.getDoseInfo().ag())) continue;
                return isodoseOverlay;
            }
        }
        return null;
    }

    private DvhDisplayInfo makeNewDVH(IsodoseOverlay isodoseOverlay, DvhDisplayInfo dvhDisplayInfo) {
        DVHProducer dVHProducer = dvhDisplayInfo.getDVHProducer();
        try {
            IsodoseStatistician isodoseStatistician = isodoseOverlay.h();
            VolumetricContourOverlayish volumetricContourOverlayish = (VolumetricContourOverlayish)dVHProducer.getGeneratedFrom();
            DoseVolumeHistogram doseVolumeHistogram = isodoseStatistician.b(volumetricContourOverlayish);
            if (doseVolumeHistogram != null) {
                dvhDisplayInfo.setDVH(doseVolumeHistogram);
            }
            return dvhDisplayInfo;
        }
        catch (Throwable throwable) {
            ay.d((Object)("Error updating DVH: " + (dVHProducer == null ? "null" : dVHProducer.getName())), throwable, this.getClass());
            return null;
        }
    }

    public List<DVHCollection> getCurrentCollections() {
        return this.params.getDVHCollections();
    }

    private static class RxAndNameChangeListener
    implements IsodoseOverlay.a,
    IsodoseOverlay.b {
        private List<WeakReference<IsodoseOverlay>> doseRefs = Lists.newArrayList();
        private WeakReference<DVHUpdateListener> ownerRef;

        public RxAndNameChangeListener(DVHUpdateListener dVHUpdateListener) {
            this.ownerRef = new WeakReference<DVHUpdateListener>(dVHUpdateListener);
        }

        private void deregisterAll() {
            for (WeakReference<IsodoseOverlay> weakReference : this.doseRefs) {
                IsodoseOverlay isodoseOverlay = (IsodoseOverlay)weakReference.get();
                if (isodoseOverlay == null) continue;
                isodoseOverlay.b(this);
                isodoseOverlay.b(this);
            }
            this.doseRefs.clear();
        }

        @Override
        public void doseNameChanged(String string, String string2) {
            this.updateDatas();
        }

        @Override
        public void doseChanged(RTDoseSeriesInfo.RxDose rxDose, RTDoseSeriesInfo.RxDose rxDose2) {
            this.updateDatas();
        }

        private void updateDatas() {
            DVHUpdateListener dVHUpdateListener = (DVHUpdateListener)this.ownerRef.get();
            if (dVHUpdateListener != null) {
                dVHUpdateListener.updateDVHs();
            } else {
                this.deregisterAll();
            }
        }

        public void registerOnDose(IsodoseOverlay isodoseOverlay) {
            isodoseOverlay.a(this);
            isodoseOverlay.a(this);
            this.doseRefs.add(new WeakReference<IsodoseOverlay>(isodoseOverlay));
        }
    }

    private static class DVHUpdateOCListener
    extends OverlayCollection.c<DVHUpdateListener> {
        private IsodoseOverlay dose;

        public DVHUpdateOCListener(DVHUpdateListener dVHUpdateListener, OverlayCollection overlayCollection, IsodoseOverlay isodoseOverlay) {
            super(dVHUpdateListener, overlayCollection);
            this.dose = isodoseOverlay;
        }

        @Override
        public void overlayAddedI(Overlayish overlayish, DVHUpdateListener dVHUpdateListener) {
            dVHUpdateListener.overlayAddedHandler(overlayish, this.dose);
        }

        @Override
        public Object getKey() {
            return this.dose;
        }
    }
}

