/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.mimvista.dicom.rtdose.DoseValue;
import com.mimvista.dicom.rtdose.gui.DVHDisplayParams;
import com.mimvista.dicom.rtdose.gui.DvhChartPointGenerator;
import com.mimvista.dicom.rtdose.gui.DvhDisplayInfo;
import com.mimvista.util.Messages;
import com.mimvista.workflow.backend.t;
import javax.swing.Icon;

public enum DvhAnnotationType implements t
{
    NONE("DVH_ANNOTATION_NONE"){

        @Override
        public DvhChartPointGenerator getPointGenerator(DVHDisplayParams dVHDisplayParams, DvhDisplayInfo dvhDisplayInfo, double d2) {
            throw new IllegalArgumentException(this.name() + " is not supported");
        }
    }
    ,
    DOSE("DVH_ANNOTATION_X"){

        @Override
        public DvhChartPointGenerator getPointGenerator(DVHDisplayParams dVHDisplayParams, DvhDisplayInfo dvhDisplayInfo, double d2) {
            if (dVHDisplayParams.getDoseNormType().isNormalized()) {
                float f2 = (float)dVHDisplayParams.unnormalizeDose(d2, dvhDisplayInfo.getDVH());
                DoseValue doseValue = new DoseValue(f2);
                d2 = doseValue.getValueInGy();
            }
            return new DvhChartPointGenerator.PointGeneratorUsingDose(dvhDisplayInfo, d2);
        }
    }
    ,
    VOLUME("DVH_ANNOTATION_Y"){

        @Override
        public DvhChartPointGenerator getPointGenerator(DVHDisplayParams dVHDisplayParams, DvhDisplayInfo dvhDisplayInfo, double d2) {
            if (dVHDisplayParams.isNormalizedVolume()) {
                d2 = dvhDisplayInfo.getDVH().getMaxVolume() * d2 / 100.0;
            }
            return new DvhChartPointGenerator.PointGeneratorUsingVolume(dvhDisplayInfo, d2);
        }
    };

    final String messageKey;

    private DvhAnnotationType(String string2) {
        this.messageKey = string2;
    }

    public abstract DvhChartPointGenerator getPointGenerator(DVHDisplayParams var1, DvhDisplayInfo var2, double var3);

    @Override
    public String getExternalizedString() {
        return Messages.a("DVH", this.messageKey);
    }

    @Override
    public Icon getIcon(int n2) {
        return null;
    }
}

