/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.google.common.collect.Lists;
import com.mimvista.dicom.devices.dump.gui.TableColumnAdjuster;
import com.mimvista.dicom.rtdose.DVHCollection;
import com.mimvista.dicom.rtdose.gui.BlackWhiteLookAndFeel;
import com.mimvista.dicom.rtdose.gui.DVHChartPanel;
import com.mimvista.dicom.rtdose.gui.DVHChartWrapper;
import com.mimvista.dicom.rtdose.gui.DVHDisplayParams;
import com.mimvista.dicom.rtdose.gui.DVHPanelItem;
import com.mimvista.dicom.rtdose.gui.DvhDisplayInfo;
import com.mimvista.mui.captures.Capture;
import com.mimvista.report.gui.content.dvhPlot.DvhLegendData;
import com.mimvista.util.Messages;
import com.mimvista.util.Pair;
import com.mimvista.util.cn;
import com.mimvista.viewer.SeriesInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class DvhCaptureMaker {
    final DVHChartPanel dvhChart;
    final DVHDisplayParams params;
    public static Comparator<Map.Entry<DVHCollection, List<DvhDisplayInfo>>> DVH_ENTRY_COMPARATOR = new Comparator<Map.Entry<DVHCollection, List<DvhDisplayInfo>>>(){

        @Override
        public int compare(Map.Entry<DVHCollection, List<DvhDisplayInfo>> entry, Map.Entry<DVHCollection, List<DvhDisplayInfo>> entry2) {
            Date date = entry.getKey().getDoseInfo().acqDate;
            Date date2 = entry2.getKey().getDoseInfo().acqDate;
            String string = entry.getKey().getUpdatedSeriesDesc();
            String string2 = entry2.getKey().getUpdatedSeriesDesc();
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            if (date == null || date2 == null) {
                return string.compareTo(string2);
            }
            if (date.compareTo(date2) == 0) {
                return string.compareTo(string2);
            }
            return date.compareTo(date2);
        }
    };

    public DvhCaptureMaker(DVHChartPanel dVHChartPanel, DVHDisplayParams dVHDisplayParams) {
        this.params = dVHDisplayParams.clone();
        DVHChartWrapper dVHChartWrapper = new DVHChartWrapper(this.params);
        this.dvhChart = new DVHChartPanel(dVHChartWrapper, dVHChartPanel.getFrame());
        this.dvhChart.setSpecialAnnotations(dVHChartPanel.getSpecialAnnotations());
        this.dvhChart.setSize(dVHChartPanel.getSize());
    }

    public Capture makeCapture() {
        Object object2;
        List<JPanel> list = this.getDetailedLegend(this.params.getLookAndFeel(), true);
        Dimension dimension = new Dimension(0, 0);
        for (JPanel jPanel : list) {
            object2 = jPanel.getPreferredSize();
            dimension.height = Math.max(dimension.height, ((Dimension)object2).height);
            dimension.width += ((Dimension)object2).width + 5;
        }
        Dimension dimension2 = this.dvhChart.getSize();
        int n2 = Math.max(dimension.height, Math.max(dimension2.width, dimension2.height));
        for (JPanel object3 : list) {
            object3.setSize(object3.getPreferredSize().width, n2);
            object3.doLayout();
        }
        this.dvhChart.setMaximumDrawHeight(n2);
        this.dvhChart.setMaximumDrawWidth(n2);
        this.dvhChart.setSize(n2, n2);
        this.dvhChart.doLayout();
        object2 = new BufferedImage(dimension.width + n2, n2, 2);
        Graphics2D graphics2D = ((BufferedImage)object2).createGraphics();
        int n3 = n2;
        for (JPanel jPanel : list) {
            int n4 = jPanel.getPreferredSize().width;
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create(n3, 0, n4, n2);
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D2.setBackground(Color.BLACK);
            graphics2D2.clearRect(0, 0, n4, n2);
            jPanel.print(graphics2D2);
            graphics2D2.dispose();
            n3 += n4 + 5;
        }
        Graphics2D graphics2D3 = (Graphics2D)graphics2D.create(0, 0, n2, n2);
        graphics2D3.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.dvhChart.print(graphics2D3);
        graphics2D3.dispose();
        graphics2D.dispose();
        ArrayList arrayList = Lists.newArrayList();
        return new Capture((BufferedImage)object2, Messages.a("DVH", "DVH_CAPTURE_DESCRIPTION"), true, arrayList);
    }

    public List<Component> getNewLegend(BlackWhiteLookAndFeel blackWhiteLookAndFeel, Map<DvhLegendData.DvhLegendStats, Boolean> map) {
        DvhLegendData dvhLegendData = new DvhLegendData(this.params, map);
        JPanel jPanel = new JPanel();
        DvhCaptureMaker.modifyLAF(jPanel, blackWhiteLookAndFeel);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JXTable jXTable = new JXTable((TableModel)dvhLegendData.a());
        jXTable.setAutoResizeMode(3);
        jXTable.setCellSelectionEnabled(false);
        jXTable.setEditable(false);
        jXTable.setSortable(false);
        jXTable.setShowGrid(true, true);
        jXTable.setDefaultRenderer(Image.class, new TableCellRenderer(){
            Box box = Box.createHorizontalBox();
            JLabel label = new JLabel();
            ImageIcon icon = new ImageIcon();
            {
                this.label.setAlignmentX(0.5f);
                this.box.add(Box.createHorizontalGlue());
                this.box.add(this.label);
                this.box.add(Box.createHorizontalGlue());
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
                if (object instanceof Image) {
                    this.icon.setImage((Image)object);
                    this.label.setIcon(this.icon);
                } else {
                    this.label.setIcon(null);
                }
                return this.box;
            }
        });
        TableColumnAdjuster tableColumnAdjuster = new TableColumnAdjuster((JTable)jXTable);
        tableColumnAdjuster.setColumnHeaderIncluded(true);
        for (MouseListener object2 : jXTable.getMouseListeners()) {
            jXTable.removeMouseListener(object2);
        }
        jXTable.addHighlighter(HighlighterFactory.createAlternateStriping((Color)blackWhiteLookAndFeel.getWhite(), (Color)blackWhiteLookAndFeel.getWhite().darker()));
        DvhCaptureMaker.modifyLAF((Component)jXTable, blackWhiteLookAndFeel);
        DvhCaptureMaker.modifyLAF(jXTable.getTableHeader(), blackWhiteLookAndFeel);
        jXTable.getTableHeader().setBorder(new CompoundBorder(jXTable.getTableHeader().getBorder(), new MatteBorder(0, 0, 0, 1, blackWhiteLookAndFeel.getBlack())));
        jXTable.setBorder((Border)new CompoundBorder(jXTable.getBorder(), new MatteBorder(0, 1, 0, 0, blackWhiteLookAndFeel.getBlack())));
        JPanel jPanel2 = new JPanel();
        DvhCaptureMaker.modifyLAF(jPanel2, blackWhiteLookAndFeel);
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jXTable.getTableHeader(), "North");
        jPanel2.add((Component)jXTable, "Center");
        tableColumnAdjuster.adjustColumns();
        JPanel jPanel3 = new JPanel();
        DvhCaptureMaker.modifyLAF(jPanel3, blackWhiteLookAndFeel);
        jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.fill = 1;
        Pair<Integer, List<DvhLegendData.c>> pair = dvhLegendData.d();
        for (DvhLegendData.c c2 : (List)pair.y) {
            Color color = blackWhiteLookAndFeel.getWhite();
            if (gridBagConstraints.gridy > 1 && gridBagConstraints.gridy % 2 != 0) {
                color = color.darker();
            }
            for (int i2 = 0; i2 < c2.a(); ++i2) {
                int n2;
                gridBagConstraints.weightx = gridBagConstraints.gridx == 0 ? 1.0 : 0.0;
                JLabel jLabel = c2.a(i2);
                DvhCaptureMaker.modifyLAF(jLabel, blackWhiteLookAndFeel);
                jLabel.setOpaque(true);
                jLabel.setBackground(color);
                jLabel.setBorder(new MatteBorder(0, 0, 1, 0, blackWhiteLookAndFeel.getBlack()));
                gridBagConstraints.gridwidth = n2 = c2.c(i2);
                jPanel3.add((Component)jLabel, gridBagConstraints);
                gridBagConstraints.gridx += n2;
            }
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
        }
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        DvhCaptureMaker.modifyLAF(jPanel4, blackWhiteLookAndFeel);
        jPanel2.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel3.setBorder(new EmptyBorder(0, 5, 5, 5));
        jPanel4.add((Component)jPanel2, "North");
        jPanel4.add((Component)jPanel3, "Center");
        return Lists.newArrayList((Object[])new Component[]{jPanel4});
    }

    public List<JPanel> getDetailedLegend(BlackWhiteLookAndFeel blackWhiteLookAndFeel, boolean bl2) {
        ArrayList<JPanel> arrayList = new ArrayList<JPanel>();
        ArrayList arrayList2 = Lists.newArrayList(this.params.getFilteredDVHs().entrySet());
        Collections.sort(arrayList2, DVH_ENTRY_COMPARATOR);
        for (Map.Entry entry : arrayList2) {
            DVHCollection dVHCollection = (DVHCollection)entry.getKey();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 3));
            jPanel.setForeground(blackWhiteLookAndFeel.getBlack());
            jPanel.setBackground(blackWhiteLookAndFeel.getWhite());
            StringBuilder stringBuilder = new StringBuilder("<html>");
            boolean bl3 = true;
            for (String string : dVHCollection.getCollectionInfoStrings()) {
                if (!bl3) {
                    stringBuilder.append("<br>");
                }
                stringBuilder.append(string);
                bl3 = false;
            }
            stringBuilder.append("</html>");
            JLabel jLabel = new JLabel(stringBuilder.toString());
            jLabel.setOpaque(true);
            jLabel.setAlignmentX(0.0f);
            jLabel.setForeground(blackWhiteLookAndFeel.getBlack());
            jLabel.setBackground(blackWhiteLookAndFeel.getWhite());
            jLabel.setBorder(BorderFactory.createLineBorder(jLabel.getBackground(), 5));
            jPanel.add(jLabel);
            if (!bl2) {
                arrayList.add(jPanel);
            }
            for (DvhDisplayInfo dvhDisplayInfo : (List)entry.getValue()) {
                if (!dvhDisplayInfo.isVisible()) continue;
                DVHPanelItem dVHPanelItem = new DVHPanelItem(dvhDisplayInfo, null);
                JLabel jLabel2 = dVHPanelItem.makeLabelForCapture(blackWhiteLookAndFeel, false);
                jLabel2.setAlignmentX(0.0f);
                jLabel2.setHorizontalAlignment(2);
                jLabel2.setForeground(blackWhiteLookAndFeel.getBlack());
                jLabel2.setBackground(blackWhiteLookAndFeel.getWhite());
                jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 5));
                if (bl2) {
                    jPanel.add(jLabel2);
                    jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                    continue;
                }
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new BoxLayout(jPanel2, 3));
                jPanel2.setForeground(blackWhiteLookAndFeel.getBlack());
                jPanel2.setBackground(blackWhiteLookAndFeel.getWhite());
                jPanel2.add(jLabel2);
                jPanel2.add(Box.createRigidArea(new Dimension(0, 5)));
                arrayList.add(jPanel2);
            }
            if (!bl2) continue;
            arrayList.add(jPanel);
        }
        return arrayList;
    }

    public List<JPanel> getLegendSmall(BlackWhiteLookAndFeel blackWhiteLookAndFeel, int n2) {
        ArrayList<JPanel> arrayList = new ArrayList<JPanel>();
        for (Map.Entry<DVHCollection, List<DvhDisplayInfo>> entry : this.params.getFilteredDVHs().entrySet()) {
            Serializable serializable;
            Serializable serializable2;
            ArrayList arrayList2 = Lists.newArrayList();
            int n3 = 0;
            for (DvhDisplayInfo dvhDisplayInfo : entry.getValue()) {
                if (!dvhDisplayInfo.isVisible()) continue;
                serializable2 = new DVHPanelItem(dvhDisplayInfo, null);
                serializable = ((DVHPanelItem)serializable2).makeLabelForCapture(blackWhiteLookAndFeel, true);
                serializable.setAlignmentX(0.0f);
                serializable.setHorizontalAlignment(2);
                serializable.setForeground(blackWhiteLookAndFeel.getBlack());
                serializable.setBackground(blackWhiteLookAndFeel.getWhite());
                int n4 = serializable.getPreferredSize().width;
                if (n4 > n3) {
                    n3 = n4;
                }
                arrayList2.add(serializable);
            }
            if (arrayList2.isEmpty()) continue;
            DVHCollection dVHCollection = entry.getKey();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.setForeground(blackWhiteLookAndFeel.getBlack());
            jPanel.setBackground(blackWhiteLookAndFeel.getWhite());
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            serializable2 = new StringBuilder("<html><b>");
            serializable = dVHCollection.getDoseInfo();
            if (!cn.h(dVHCollection.getUpdatedSeriesDesc())) {
                ((StringBuilder)serializable2).append(dVHCollection.getUpdatedSeriesDesc());
                ((StringBuilder)serializable2).append("<br/>");
            } else if (!cn.h(((SeriesInfo)serializable).seriesDesc)) {
                ((StringBuilder)serializable2).append(((SeriesInfo)serializable).seriesDesc);
                ((StringBuilder)serializable2).append("<br/>");
            }
            if (!cn.h(((SeriesInfo)serializable).doseComment)) {
                ((StringBuilder)serializable2).append(((SeriesInfo)serializable).doseComment);
            }
            ((StringBuilder)serializable2).append("</b></html>");
            JLabel jLabel = new JLabel(((StringBuilder)serializable2).toString());
            jLabel.setOpaque(true);
            jLabel.setAlignmentX(0.0f);
            jLabel.setHorizontalAlignment(2);
            jLabel.setForeground(blackWhiteLookAndFeel.getBlack());
            jLabel.setBackground(blackWhiteLookAndFeel.getWhite());
            jPanel.add((Component)jLabel, "North");
            if (n3 == 0) {
                n3 = n2;
            }
            JPanel jPanel2 = new JPanel(new GridLayout(0, Math.max(1, n2 / n3), 0, 0));
            jPanel2.setBackground(blackWhiteLookAndFeel.getWhite());
            jPanel2.setForeground(blackWhiteLookAndFeel.getBlack());
            jPanel.add(jPanel2);
            for (JLabel jLabel2 : arrayList2) {
                jPanel2.add(jLabel2);
            }
            arrayList.add(jPanel);
        }
        return arrayList;
    }

    private static void modifyLAF(Component component, BlackWhiteLookAndFeel blackWhiteLookAndFeel) {
        component.setForeground(blackWhiteLookAndFeel.getBlack());
        component.setBackground(blackWhiteLookAndFeel.getWhite());
    }
}

