/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.dicom.rtdose.gui.DvhDisplayInfo;
import com.mimvista.dicom.rtdose.gui.DvhPoint;

public abstract class DvhChartPointGenerator {
    protected DvhDisplayInfo dvhDisplayInfo;
    public final double value;

    DvhChartPointGenerator(DvhDisplayInfo dvhDisplayInfo, double d2) {
        this.dvhDisplayInfo = dvhDisplayInfo;
        this.value = d2;
    }

    abstract DvhPoint generate();

    public static class PointGeneratorUsingVolume
    extends DvhChartPointGenerator {
        PointGeneratorUsingVolume(DvhDisplayInfo dvhDisplayInfo, double d2) {
            super(dvhDisplayInfo, d2);
        }

        @Override
        DvhPoint generate() {
            DoseVolumeHistogram doseVolumeHistogram = this.dvhDisplayInfo.getDVH();
            if (doseVolumeHistogram == null) {
                return null;
            }
            DvhPoint dvhPoint = new DvhPoint();
            dvhPoint.x = doseVolumeHistogram.getInterpolatedGyValue(this.value);
            dvhPoint.y = this.value;
            return dvhPoint;
        }
    }

    public static class PointGeneratorUsingDose
    extends DvhChartPointGenerator {
        PointGeneratorUsingDose(DvhDisplayInfo dvhDisplayInfo, double d2) {
            super(dvhDisplayInfo, d2);
        }

        @Override
        DvhPoint generate() {
            DoseVolumeHistogram doseVolumeHistogram = this.dvhDisplayInfo.getDVH();
            if (doseVolumeHistogram == null) {
                return null;
            }
            DvhPoint dvhPoint = new DvhPoint();
            dvhPoint.x = this.value;
            dvhPoint.y = doseVolumeHistogram.getInterpolatedMLValue(this.value);
            return dvhPoint;
        }
    }
}

