/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.google.common.base.Objects;
import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.dicom.rtdose.gui.DVHProducer;
import com.mimvista.dicom.rtdose.gui.DvhLineStyle;
import com.mimvista.mui.overlays.OverlayColorPool;
import com.mimvista.mui.overlays.SimpleVolumetricContourOverlayishBase;
import com.mimvista.util.ay;
import com.mimvista.util.bm;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class DvhDisplayInfo
implements bm,
Serializable,
Cloneable {
    private static final long serialVersionUID = 8668989075016136795L;
    private transient DVHProducer dvh;
    private Color prevDisplayColor = null;
    private Color displayColor = null;
    private DvhLineStyle lineStyle = DvhLineStyle.THIN_SOLID;
    private boolean visible = true;
    private boolean selected = false;

    public DvhDisplayInfo(DoseVolumeHistogram doseVolumeHistogram) {
        this(DVHProducer.supply(doseVolumeHistogram));
    }

    public DvhDisplayInfo(DVHProducer dVHProducer) {
        this.dvh = dVHProducer;
        SimpleVolumetricContourOverlayishBase simpleVolumetricContourOverlayishBase = dVHProducer.getGeneratedFrom();
        this.displayColor = simpleVolumetricContourOverlayishBase != null ? simpleVolumetricContourOverlayishBase.bn_() : OverlayColorPool.a(0);
        this.prevDisplayColor = this.displayColor;
    }

    public DvhDisplayInfo(DoseVolumeHistogram doseVolumeHistogram, Color color) {
        this(doseVolumeHistogram);
        this.prevDisplayColor = this.displayColor = color;
    }

    public DoseVolumeHistogram getDVH() {
        return this.dvh.getDVH();
    }

    public DVHProducer getDVHProducer() {
        return this.dvh;
    }

    public void setDVH(DoseVolumeHistogram doseVolumeHistogram) {
        this.dvh = DVHProducer.supply(doseVolumeHistogram);
    }

    public void setDVH(DVHProducer dVHProducer) {
        this.dvh = dVHProducer;
    }

    public Color getColor() {
        return this.displayColor;
    }

    public void setColor(Color color, boolean bl2) {
        if (bl2) {
            this.displayColor = color;
        } else if (!Objects.equal((Object)color, (Object)this.prevDisplayColor)) {
            this.prevDisplayColor = this.displayColor;
            this.displayColor = color;
        }
    }

    public DvhLineStyle getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(DvhLineStyle dvhLineStyle) {
        this.lineStyle = dvhLineStyle;
    }

    public boolean isVisible() {
        if (this.getDVH() != null) {
            return this.visible;
        }
        return false;
    }

    public void setVisible(boolean bl2) {
        this.visible = bl2;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl2) {
        this.selected = bl2;
    }

    public DvhDisplayInfo clone() {
        try {
            return (DvhDisplayInfo)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ay.d((Object)"Couldn't clone DvhDisplayInfo", (Throwable)cloneNotSupportedException, this);
            return null;
        }
    }

    @Override
    public String getName() {
        return this.getDVHProducer().getNameForReporting();
    }

    public String toString() {
        return this.getDVHProducer().getNameForReporting();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.lineStyle == null) {
            this.lineStyle = DvhLineStyle.THIN_SOLID;
        }
    }
}

