/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui;

import com.google.common.collect.Lists;
import com.mimvista.dicom.rtdose.DVHCollection;
import com.mimvista.dicom.rtdose.gui.DvhDisplayInfo;
import com.mimvista.dicom.rtdose.gui.DvhLineStyle;
import com.mimvista.numerics.helpers.FuncUtils;
import java.util.List;
import javax.swing.DefaultComboBoxModel;

public class StrokePickerModel
extends DefaultComboBoxModel<DvhLineStyle> {
    private static final long serialVersionUID = 1L;
    private DVHCollection dvhc;
    private FuncUtils.m<DVHCollection> applyChangesListener;
    private List<DvhLineStyle> strokes = Lists.newArrayList((Object[])DvhLineStyle.values());

    public StrokePickerModel(DVHCollection dVHCollection, FuncUtils.m<DVHCollection> m2) {
        this.dvhc = dVHCollection;
        this.applyChangesListener = m2;
    }

    @Override
    public void setSelectedItem(Object object) {
        super.setSelectedItem(object);
        if (!(object instanceof DvhLineStyle)) {
            return;
        }
        DvhLineStyle dvhLineStyle = (DvhLineStyle)object;
        this.dvhc.setLineStyle(dvhLineStyle);
        for (DvhDisplayInfo dvhDisplayInfo : this.dvhc.getDvhDisplayInfo()) {
            dvhDisplayInfo.setLineStyle((DvhLineStyle)object);
        }
        if (this.applyChangesListener != null) {
            this.applyChangesListener.doIt(this.dvhc);
        }
    }

    @Override
    public Object getSelectedItem() {
        if (this.dvhc == null) {
            return null;
        }
        if (this.dvhc.getLineStyle() == null) {
            return this.dvhc.getDvhDisplayInfo().get(0).getLineStyle();
        }
        return this.dvhc.getLineStyle();
    }

    @Override
    public int getIndexOf(Object object) {
        return this.strokes.indexOf(object);
    }

    @Override
    public DvhLineStyle getElementAt(int n2) {
        return this.strokes.get(n2);
    }

    @Override
    public int getSize() {
        return this.strokes.size();
    }
}

