/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui.constraint;

import com.mimvista.dicom.rtdose.gui.constraint.ConstraintRow;
import com.mimvista.dose.constraints.AppliedConstraint;
import com.mimvista.dose.constraints.AppliedDoseContourConstraint;
import com.mimvista.mui.overlays.AbstractContourOverlayish;
import com.mimvista.mui.overlays.IsodoseOverlay;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.response.StatisticDerivationType;
import java.util.List;

class ConstraintComparisonRow {
    final IsodoseOverlay currentDose;
    final IsodoseOverlay comparisonDose;
    final AppliedDoseContourConstraint constraint;
    final ConstraintRow currentConstraint;
    final ConstraintRow comparisonConstraint;

    public ConstraintComparisonRow(IsodoseOverlay isodoseOverlay, IsodoseOverlay isodoseOverlay2, AppliedDoseContourConstraint appliedDoseContourConstraint) {
        this.currentDose = isodoseOverlay;
        this.comparisonDose = isodoseOverlay2;
        this.constraint = appliedDoseContourConstraint;
        this.currentConstraint = this.buildConstraintRow(isodoseOverlay, appliedDoseContourConstraint);
        this.comparisonConstraint = this.buildConstraintRow(isodoseOverlay2, appliedDoseContourConstraint);
    }

    public VolumetricContourOverlayish getCurrentContour() {
        if (this.currentConstraint != null) {
            return this.currentConstraint.vco;
        }
        return null;
    }

    public VolumetricContourOverlayish getComparisonContour() {
        if (this.comparisonConstraint != null) {
            return this.comparisonConstraint.vco;
        }
        return null;
    }

    public String getConstraintName() {
        if (this.constraint != null) {
            return this.constraint.name;
        }
        return "";
    }

    public Double getCurrentValue() {
        if (this.currentConstraint != null) {
            return this.currentConstraint.getValue(this.currentDose);
        }
        return null;
    }

    public Double getComparisonValue() {
        if (this.comparisonConstraint != null) {
            return this.comparisonConstraint.getValue(this.comparisonDose);
        }
        return null;
    }

    public Double getDerivedValue(StatisticDerivationType statisticDerivationType) {
        if (this.currentConstraint == null || this.currentDose == null || this.comparisonConstraint == null || this.comparisonDose == null) {
            return null;
        }
        Double d2 = this.currentConstraint.getValue(this.currentDose);
        Double d3 = this.comparisonConstraint.getValue(this.comparisonDose);
        if (d2 == null || d3 == null) {
            return null;
        }
        return statisticDerivationType.a(Float.valueOf(d2.floatValue()), Float.valueOf(d3.floatValue())).floatValue();
    }

    private ConstraintRow buildConstraintRow(IsodoseOverlay isodoseOverlay, AppliedDoseContourConstraint appliedDoseContourConstraint) {
        return new ConstraintRow(this.getMatchingOverlay(isodoseOverlay, appliedDoseContourConstraint), appliedDoseContourConstraint);
    }

    private VolumetricContourOverlayish getMatchingOverlay(IsodoseOverlay isodoseOverlay, AppliedConstraint appliedConstraint) {
        if (isodoseOverlay != null && appliedConstraint != null) {
            List<AbstractContourOverlayish> list = isodoseOverlay.ao().n().D();
            for (AbstractContourOverlayish abstractContourOverlayish : list) {
                if (!abstractContourOverlayish.w()) continue;
                VolumetricContourOverlayish volumetricContourOverlayish = abstractContourOverlayish.G();
                if (!appliedConstraint.matches(abstractContourOverlayish)) continue;
                return volumetricContourOverlayish;
            }
        }
        return null;
    }
}

