/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.rtdose.gui.constraint;

import com.google.common.collect.Lists;
import com.mimvista.dose.constraints.DoseConstraintSet;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;

public class DoseConstraintCombo
extends JComboBox<DoseConstraintSet> {
    private static final long serialVersionUID = 1L;

    public DoseConstraintCombo(boolean bl2) {
        ArrayList arrayList = Lists.newArrayList();
        if (bl2) {
            arrayList.add(DoseConstraintSet.nonePersona);
        }
        arrayList.addAll(DoseConstraintSet.getUserPreferencedPersonas());
        for (DoseConstraintSet doseConstraintSet : arrayList) {
            this.addItem(doseConstraintSet);
        }
        this.setRenderer(new ConstraintCellRenderer());
    }

    public DoseConstraintCombo() {
        this(false);
    }

    public DoseConstraintCombo(DoseConstraintSet doseConstraintSet) {
        this();
        if (doseConstraintSet != null) {
            this.setSelectedItem(doseConstraintSet);
        }
    }

    public void addDoseConstraintIfMissing(DoseConstraintSet doseConstraintSet) {
        if (doseConstraintSet != null) {
            ComboBoxModel comboBoxModel = this.getModel();
            boolean bl2 = false;
            for (int i2 = 0; i2 < comboBoxModel.getSize(); ++i2) {
                Object e2 = comboBoxModel.getElementAt(i2);
                if (!doseConstraintSet.equals(e2)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                this.addItem(doseConstraintSet);
            }
        }
    }

    @Override
    public DoseConstraintSet getSelectedItem() {
        Object object = super.getSelectedItem();
        if (object instanceof DoseConstraintSet) {
            return (DoseConstraintSet)object;
        }
        return null;
    }

    private class ConstraintCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private ConstraintCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            JLabel jLabel = new JLabel();
            if (object instanceof DoseConstraintSet) {
                DoseConstraintSet doseConstraintSet = (DoseConstraintSet)object;
                jLabel.setText(doseConstraintSet.name);
            }
            return jLabel;
        }
    }
}

